# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CoreApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a batch deployment request  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a batch deployment request  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a batch deployment version request  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a batch deployment version request  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a batch pipeline request  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a batch pipeline request  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a batch pipeline version request  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a batch pipeline version request  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_create(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The uploaded blob file can be retrieved by passing the blob_id. The returned blob_id may be passed in a deployment or pipeline request as input.  ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_create_with_http_info(project_name, file, **kwargs)  # noqa: E501

    def blobs_create_with_http_info(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The uploaded blob file can be retrieved by passing the blob_id. The returned blob_id may be passed in a deployment or pipeline request as input.  ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create_with_http_info(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_create`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_delete(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_delete_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_delete_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_delete`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_get(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_get_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_get_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_get`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_list(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BlobList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def blobs_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BlobList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'range', 'creation_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'range' in local_var_params
            and local_var_params['range'] is not None):  # noqa: E501
            if not isinstance(local_var_params['range'], int):  # noqa: E501
                raise ApiValueError("Parameter `range` must be an integer when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'creation_date' in local_var_params
            and local_var_params['creation_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['creation_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `creation_date` must be a string when calling `blobs_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'range' in local_var_params and local_var_params['range'] is not None:  # noqa: E501
            query_params.append(('range', local_var_params['range']))  # noqa: E501
        if 'creation_date' in local_var_params and local_var_params['creation_date'] is not None:  # noqa: E501
            query_params.append(('creation_date', local_var_params['creation_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlobList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_update(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id. The uploaded blob file can be retrieved by passing the blob_id.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_update_with_http_info(project_name, blob_id, file, **kwargs)  # noqa: E501

    def blobs_update_with_http_info(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id. The uploaded blob file can be retrieved by passing the blob_id.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update_with_http_info(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_get(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BuildList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.builds_get_with_http_info(project_name, build_id, deployment_name, version, **kwargs)  # noqa: E501

    def builds_get_with_http_info(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get_with_http_info(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BuildList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'build_id', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'build_id' is set
        if self.api_client.client_side_validation and ('build_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['build_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `build_id` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'build_id' in local_var_params
            and local_var_params['build_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['build_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `build_id` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'build_id' in local_var_params:
            path_params['build_id'] = local_var_params['build_id']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\"   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BuildList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.builds_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def builds_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\"   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BuildList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BuildList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_audit_events_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_audit_events_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_audit_events_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_audit_events_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_copy(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_copy_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_copy import EnvironmentVariableCopy

                local_var_params['data'] = EnvironmentVariableCopy(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_delete(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_get(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_get_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_environment_variables_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_update(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_update_with_http_info(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_batch_delete(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple deployment requests  # noqa: E501

         ### Description Delete multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_delete(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_batch_delete_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple deployment requests  # noqa: E501

         ### Description Delete multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_batch_get(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_get(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_batch_get_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a direct deployment request  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a direct deployment request  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_delete(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete a deployment request  # noqa: E501

         ### Description Delete a deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_delete(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def deployment_requests_delete_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete a deployment request  # noqa: E501

         ### Description Delete a deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_get(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get a deployment request  # noqa: E501

         ### Description Get a request of the default version of a deployment. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the deployment (and version) names if the request is directly made to the deployment    - the pipeline (and version) names if the request is part of a pipeline request    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"deployment\": \"deployment-1\",     \"deployment_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_get(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_get_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def deployment_requests_get_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get a deployment request  # noqa: E501

         ### Description Get a request of the default version of a deployment. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the deployment (and version) names if the request is directly made to the deployment    - the pipeline (and version) names if the request is part of a pipeline request    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"deployment\": \"deployment-1\",     \"deployment_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_get_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `deployment_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_requests_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'status', 'success', 'limit', 'offset', 'sort', 'pipeline', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline' in local_var_params
            and local_var_params['pipeline'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline'], bool):  # noqa: E501
                raise ApiValueError("Parameter `pipeline` must be a boolean when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `deployment_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'pipeline' in local_var_params and local_var_params['pipeline'] is not None:  # noqa: E501
            query_params.append(('pipeline', local_var_params['pipeline']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_update(self, project_name, deployment_name, request_id, data, **kwargs):  # noqa: E501
        """Update a deployment request  # noqa: E501

         ### Description Update a deployment request for the default version of a deployment. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_update(project_name, deployment_name, request_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_update_with_http_info(project_name, deployment_name, request_id, data, **kwargs)  # noqa: E501

    def deployment_requests_update_with_http_info(self, project_name, deployment_name, request_id, data, **kwargs):  # noqa: E501
        """Update a deployment request  # noqa: E501

         ### Description Update a deployment request for the default version of a deployment. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_update_with_http_info(project_name, deployment_name, request_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_request_update import DeploymentRequestUpdate

                local_var_params['data'] = DeploymentRequestUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_copy(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_copy_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_copy import EnvironmentVariableCopy

                local_var_params['data'] = EnvironmentVariableCopy(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_delete(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_get(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_get_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_update(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_update_with_http_info(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_batch_delete(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple deployment version requests  # noqa: E501

         ### Description Delete multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_delete(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_batch_delete_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple deployment version requests  # noqa: E501

         ### Description Delete multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_version_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_batch_get(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment version requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_get(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_batch_get_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment version requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_version_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a direct deployment version request  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a direct deployment version request  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_delete(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a deployment version request  # noqa: E501

         ### Description Delete a deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_delete(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def deployment_version_requests_delete_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a deployment version request  # noqa: E501

         ### Description Delete a deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_get(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get a deployment version request  # noqa: E501

         ### Description Get a request for a deployment version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_get(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def deployment_version_requests_get_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get a deployment version request  # noqa: E501

         ### Description Get a request for a deployment version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `deployment_version_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_version_requests_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'status', 'success', 'limit', 'offset', 'sort', 'pipeline', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline' in local_var_params
            and local_var_params['pipeline'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline'], bool):  # noqa: E501
                raise ApiValueError("Parameter `pipeline` must be a boolean when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `deployment_version_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'pipeline' in local_var_params and local_var_params['pipeline'] is not None:  # noqa: E501
            query_params.append(('pipeline', local_var_params['pipeline']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_update(self, project_name, deployment_name, request_id, version, data, **kwargs):  # noqa: E501
        """Update a deployment version request  # noqa: E501

         ### Description Update a deployment request for a deployment version. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_update(project_name, deployment_name, request_id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_update_with_http_info(project_name, deployment_name, request_id, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_update_with_http_info(self, project_name, deployment_name, request_id, version, data, **kwargs):  # noqa: E501
        """Update a deployment version request  # noqa: E501

         ### Description Update a deployment request for a deployment version. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_update_with_http_info(project_name, deployment_name, request_id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_request_update import DeploymentRequestUpdate

                local_var_params['data'] = DeploymentRequestUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.6, python3.7, python3.8, python3.9, python3.6_cuda, python3.7_cuda, python3.8_cuda, python3.9_cuda or r4.0. The default value is python3.7. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB. This value determines the memory allocated to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 16384 respectively. - `instance_type`: Reserved instance type for the version. This value determines the allocation of memory to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048mb. The minimum and maximum values are 256mb and 16384mb respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 (300 for GPU deployments) and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```  ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"instance_type\": \"512mb\" } ```  ```   \"version\": \"version-1\",   \"language\": \"python3.6_cuda\",   \"instance_type\": \"16384mb_t4\",   \"maximum_instances\": 1 ```  ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*.  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_versions_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.6, python3.7, python3.8, python3.9, python3.6_cuda, python3.7_cuda, python3.8_cuda, python3.9_cuda or r4.0. The default value is python3.7. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB. This value determines the memory allocated to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 16384 respectively. - `instance_type`: Reserved instance type for the version. This value determines the allocation of memory to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048mb. The minimum and maximum values are 256mb and 16384mb respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 (300 for GPU deployments) and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```  ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"instance_type\": \"512mb\" } ```  ```   \"version\": \"version-1\",   \"language\": \"python3.6_cuda\",   \"instance_type\": \"16384mb_t4\",   \"maximum_instances\": 1 ```  ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*.  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_version_create import DeploymentVersionCreate

                local_var_params['data'] = DeploymentVersionCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_delete(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

         ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_delete_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_delete_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

         ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_get(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_get_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_get_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory usage for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"memory_allocation\": 512,     \"instance_type\": \"512mb\",     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"memory_allocation\": 256,     \"instance_type\": \"256mb\",     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentVersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_versions_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory usage for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"memory_allocation\": 512,     \"instance_type\": \"512mb\",     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"memory_allocation\": 256,     \"instance_type\": \"256mb\",     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentVersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployment_versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentVersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_update(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Optional Parameters  - `version`: New name for the version - `memory_allocation`: (deprecated) New reserved memory for the version in MiB - `instance_type`: New instance type for the version - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Request Examples  ``` {   \"version\": \"new-version\" } ```  ``` {   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*.  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_versions_update_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Optional Parameters  - `version`: New name for the version - `memory_allocation`: (deprecated) New reserved memory for the version in MiB - `instance_type`: New instance type for the version - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored  #### Request Examples  ``` {   \"version\": \"new-version\" } ```  ``` {   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: (deprecated) Reserved memory for the version in MiB - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*.  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"memory_allocation\": 512,   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_version_update import DeploymentVersionUpdate

                local_var_params['data'] = DeploymentVersionUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  Possible widgets for the input fields are: - **textbox**: textbox - **numberbox**: numberbox - **slider**: slider - **dropdown**: dropdown - **switch**: switch - **button**: upload button - **drawer**: drawer - **image_preview**: image upload with preview  Possible widgets for the output fields are: - **textbox**: textbox - **button**: download button - **image_preview**: image preview  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  A deployment with structured input and output type and field widgets ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def deployments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  Possible widgets for the input fields are: - **textbox**: textbox - **numberbox**: numberbox - **slider**: slider - **dropdown**: dropdown - **switch**: switch - **button**: upload button - **drawer**: drawer - **image_preview**: image upload with preview  Possible widgets for the output fields are: - **textbox**: textbox - **button**: download button - **image_preview**: image preview  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  A deployment with structured input and output type and field widgets ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_create import DeploymentCreate

                local_var_params['data'] = DeploymentCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_delete(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_delete_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_delete_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_get(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and widget - `output_fields`: The list of deployment output fields containing name, data_type and widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_get_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_get_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and widget - `output_fields`: The list of deployment output fields containing name, data_type and widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_list(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def deployments_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_update(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment  ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default. - `input_fields`: New input fields for the deployment - `output_fields`: New output fields for the deployment  Input and output fields can be updated (name, data type or widget), added or removed. For deployments that are attached in a pipeline or contain any input/output widgets, fields must be updated one at a time so that the updates can be performed while preserving the mapping/widgets.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and (optional) widget - `output_fields`: The list of deployment output fields containing name, data_type and (optional) widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_update_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployments_update_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment  ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default. - `input_fields`: New input fields for the deployment - `output_fields`: New output fields for the deployment  Input and output fields can be updated (name, data type or widget), added or removed. For deployments that are attached in a pipeline or contain any input/output widgets, fields must be updated one at a time so that the updates can be performed while preserving the mapping/widgets.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and (optional) widget - `output_fields`: The list of deployment output fields containing name, data_type and (optional) widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_update import DeploymentUpdate

                local_var_params['data'] = DeploymentUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create an export  # noqa: E501

         ### Description Create an export by selecting the objects in the export  ### Optional Parameters - `deployments`: Dictionary containing the deployments to export - `pipelines`: Dictionary containing the pipelines to export - `environment_variables`: Dictionary containing the project-level environment variables to export  #### Request Examples  ``` {   \"deployments\": {     \"deployment-1\": {       \"versions\": {         \"version-1\": {           \"environment_variables\": {             \"VERSION_ENV_VAR_NAME_1\": {               \"include_value\": true             },             \"VERSION_ENV_VAR_NAME_2\": {               \"include_value\": false             }           }         },         \"version-2\": {}       },       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_NAME_1\": {           \"include_value\": false         }       }     },     \"deployment-2\": {       \"versions\": {}     }   },   \"pipelines\": {     \"pipeline-1\": {       \"versions\": {         \"version-1\": {},         \"version-2\": {}       }     },     \"pipeline-2\": {       \"versions\": {}     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_NAME_1\": {       \"include_value\": false     }   } } ```  ### Response Structure Details of the created export - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ExportCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExportList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.exports_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def exports_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create an export  # noqa: E501

         ### Description Create an export by selecting the objects in the export  ### Optional Parameters - `deployments`: Dictionary containing the deployments to export - `pipelines`: Dictionary containing the pipelines to export - `environment_variables`: Dictionary containing the project-level environment variables to export  #### Request Examples  ``` {   \"deployments\": {     \"deployment-1\": {       \"versions\": {         \"version-1\": {           \"environment_variables\": {             \"VERSION_ENV_VAR_NAME_1\": {               \"include_value\": true             },             \"VERSION_ENV_VAR_NAME_2\": {               \"include_value\": false             }           }         },         \"version-2\": {}       },       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_NAME_1\": {           \"include_value\": false         }       }     },     \"deployment-2\": {       \"versions\": {}     }   },   \"pipelines\": {     \"pipeline-1\": {       \"versions\": {         \"version-1\": {},         \"version-2\": {}       }     },     \"pipeline-2\": {       \"versions\": {}     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_NAME_1\": {       \"include_value\": false     }   } } ```  ### Response Structure Details of the created export - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ExportCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExportList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `exports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.export_create import ExportCreate

                local_var_params['data'] = ExportCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExportList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_delete(self, project_name, export_id, **kwargs):  # noqa: E501
        """Delete an export  # noqa: E501

         ### Description Delete an export from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_delete(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.exports_delete_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_delete_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Delete an export  # noqa: E501

         ### Description Delete an export from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_delete_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_delete`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_download(self, project_name, export_id, **kwargs):  # noqa: E501
        """Download an export  # noqa: E501

         ### Description Download an export in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_download(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.exports_download_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_download_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Download an export  # noqa: E501

         ### Description Download an export in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_download_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_download`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_get(self, project_name, export_id, **kwargs):  # noqa: E501
        """Get an export  # noqa: E501

         ### Description Get the details of an export in a project  ### Response Structure - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes - `deployments`: Dictionary of the deployments in the export - `pipelines`: Dictionary of the pipelines in the export - `environment_variables`: Dictionary of the environment variables in the export   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_get(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.exports_get_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_get_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Get an export  # noqa: E501

         ### Description Get the details of an export in a project  ### Response Structure - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes - `deployments`: Dictionary of the deployments in the export - `pipelines`: Dictionary of the pipelines in the export - `environment_variables`: Dictionary of the environment variables in the export   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_get_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_get`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_list(self, project_name, **kwargs):  # noqa: E501
        """List exports  # noqa: E501

         ### Description List all exports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the export. Can be 'pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the exports in the project  - `id`: Unique identifier for the export (UUID)  - `creation_date`: Time the export was created  - `status`: The status of the export  - `error_message`: The error message in case of a failure  - `size`: Size of the export in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": null   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"completed\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ExportList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.exports_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def exports_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List exports  # noqa: E501

         ### Description List all exports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the export. Can be 'pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the exports in the project  - `id`: Unique identifier for the export (UUID)  - `creation_date`: Time the export was created  - `status`: The status of the export  - `error_message`: The error message in case of a failure  - `size`: Size of the export in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": null   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"completed\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ExportList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `exports_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExportList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_create(self, project_name, **kwargs):  # noqa: E501
        """Create an import  # noqa: E501

         ### Description Create an import by uploading a zip file, providing a link to an import file or by giving an export id. Only one of the fields `file`, `import_link` or `export_id` may be given at a time.  When providing a link to an import file, make sure it is publicly downloadable.   ### Required Parameters  Only one of the following fields should be given: - `file`: A zip file - `import_link`: url to a publicly downloadable zip file - `export_id`: UUID of a previously created export in the same project  ### Optional Parameters - `skip_confirmation`: Whether to skip the confirmation step, default to False  ### Response Structure Details of the created import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": 28391 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_create(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file:
        :param str import_link:
        :param str export_id:
        :param bool skip_confirmation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_create_with_http_info(project_name, **kwargs)  # noqa: E501

    def imports_create_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Create an import  # noqa: E501

         ### Description Create an import by uploading a zip file, providing a link to an import file or by giving an export id. Only one of the fields `file`, `import_link` or `export_id` may be given at a time.  When providing a link to an import file, make sure it is publicly downloadable.   ### Required Parameters  Only one of the following fields should be given: - `file`: A zip file - `import_link`: url to a publicly downloadable zip file - `export_id`: UUID of a previously created export in the same project  ### Optional Parameters - `skip_confirmation`: Whether to skip the confirmation step, default to False  ### Response Structure Details of the created import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": 28391 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_create_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file:
        :param str import_link:
        :param str export_id:
        :param bool skip_confirmation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'import_link', 'export_id', 'skip_confirmation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_link' in local_var_params
            and local_var_params['import_link'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_link'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_link` must be a string when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'skip_confirmation' in local_var_params
            and local_var_params['skip_confirmation'] is not None):  # noqa: E501
            if not isinstance(local_var_params['skip_confirmation'], bool):  # noqa: E501
                raise ApiValueError("Parameter `skip_confirmation` must be a boolean when calling `imports_create`")  # noqa: E501

        if self.api_client.client_side_validation and ('import_link' in local_var_params and  # noqa: E501
                                                        len(local_var_params['import_link']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `import_link` when calling `imports_create`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'import_link' in local_var_params:
            form_params.append(('import_link', local_var_params['import_link']))  # noqa: E501
        if 'export_id' in local_var_params:
            form_params.append(('export_id', local_var_params['export_id']))  # noqa: E501
        if 'skip_confirmation' in local_var_params:
            form_params.append(('skip_confirmation', local_var_params['skip_confirmation']))  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_delete(self, project_name, import_id, **kwargs):  # noqa: E501
        """Delete an import  # noqa: E501

         ### Description Delete an import from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_delete(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_delete_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_delete_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Delete an import  # noqa: E501

         ### Description Delete an import from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_delete_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_delete`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_download(self, project_name, import_id, **kwargs):  # noqa: E501
        """Download an import  # noqa: E501

         ### Description Download an import in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_download(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_download_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_download_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Download an import  # noqa: E501

         ### Description Download an import in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_download_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_download`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_get(self, project_name, import_id, **kwargs):  # noqa: E501
        """Get an import  # noqa: E501

         ### Description Get the details of an import in a project  ### Response Structure - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes - `deployments`: Dictionary of the deployments in the import - `pipelines`: Dictionary of the pipelines in the import - `environment_variables`: Dictionary of the environment variables in the import   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_get(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_get_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_get_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Get an import  # noqa: E501

         ### Description Get the details of an import in a project  ### Response Structure - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes - `deployments`: Dictionary of the deployments in the import - `pipelines`: Dictionary of the pipelines in the import - `environment_variables`: Dictionary of the environment variables in the import   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_get_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_get`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_list(self, project_name, **kwargs):  # noqa: E501
        """List imports  # noqa: E501

         ### Description List all imports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the import. Can be 'pending', 'scanning', 'confirmation', 'confirmation_pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the imports in the project  - `id`: Unique identifier for the import (UUID)  - `creation_date`: Time the import was created  - `status`: The status of the import  - `error_message`: The error message in case of a failure  - `size`: Size of the import in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 126832   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ImportList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def imports_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List imports  # noqa: E501

         ### Description List all imports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the import. Can be 'pending', 'scanning', 'confirmation', 'confirmation_pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the imports in the project  - `id`: Unique identifier for the import (UUID)  - `creation_date`: Time the import was created  - `status`: The status of the import  - `error_message`: The error message in case of a failure  - `size`: Size of the import in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 126832   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ImportList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `imports_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImportList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_update(self, project_name, import_id, data, **kwargs):  # noqa: E501
        """Confirm an import  # noqa: E501

         ### Description Confirm (and update) an import by selecting the objects in the import  ### Optional Parameters - `deployments`: Dictionary containing the deployments to create - `pipelines`: Dictionary containing the pipelines to create - `environment_variables`: Dictionary containing the project-level environment variables to create  #### Request Examples  ``` {     \"deployments\": {     \"deployment-1: {       \"description\": \"\",       \"labels\": {         \"my-label\": \"my-value\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"zip\": \"deployments/deployment_deployment-1/versions/deployment_deployment-1_version_v1.zip\",           \"description\": \"\",           \"labels\": {},           \"language\": \"python3.7\",           \"maximum_idle_time\": 300,           \"maximum_instances\": 5,           \"memory_allocation\": 256,           \"minimum_instances\": 0,           \"environment_variables\": {             \"VERSION_ENV_VAR_1\": {               \"value\": \"my-secret-value\",               \"secret\": true             },             \"VERSION_ENV_VAR_2\": {               \"value\": \"test2\"             }           },           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ],       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_1\": {           \"value\": \"my-secret-value\",           \"secret\": true         },         \"DEPLOYMENT_ENV_VAR_2\": {           \"value\": \"test\"         }       }     }   },   \"pipelines\": {     \"pipeline-1: {       \"description\": \"\",       \"labels\": {         \"test\": \"label\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"description\": \"\",           \"labels\": {},           \"objects\": [             {               \"name\": \"obj-1\",               \"reference_name\": \"deployment-1\",               \"reference_version\": \"v1\"             }           ],           \"attachments\": [             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"input\",                       \"destination_field_name\": \"input\"                     }                   ],                   \"source_name\": \"pipeline_start\"                 }               ],               \"destination_name\": \"obj-1\"             },             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"output\",                       \"destination_field_name\": \"output\"                     }                   ],                   \"source_name\": \"obj-1\"                 }               ],               \"destination_name\": \"pipeline_end\"             }           ],           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ]     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_1\": {       \"value\": \"value1\",       \"secret\": true     },     \"PROJECT_ENV_VAR_2\": {       \"value\": \"value2\"     }   } } ```  ### Response Structure Details of the updated import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_update(project_name, import_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param ImportUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_update_with_http_info(project_name, import_id, data, **kwargs)  # noqa: E501

    def imports_update_with_http_info(self, project_name, import_id, data, **kwargs):  # noqa: E501
        """Confirm an import  # noqa: E501

         ### Description Confirm (and update) an import by selecting the objects in the import  ### Optional Parameters - `deployments`: Dictionary containing the deployments to create - `pipelines`: Dictionary containing the pipelines to create - `environment_variables`: Dictionary containing the project-level environment variables to create  #### Request Examples  ``` {     \"deployments\": {     \"deployment-1: {       \"description\": \"\",       \"labels\": {         \"my-label\": \"my-value\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"zip\": \"deployments/deployment_deployment-1/versions/deployment_deployment-1_version_v1.zip\",           \"description\": \"\",           \"labels\": {},           \"language\": \"python3.7\",           \"maximum_idle_time\": 300,           \"maximum_instances\": 5,           \"memory_allocation\": 256,           \"minimum_instances\": 0,           \"environment_variables\": {             \"VERSION_ENV_VAR_1\": {               \"value\": \"my-secret-value\",               \"secret\": true             },             \"VERSION_ENV_VAR_2\": {               \"value\": \"test2\"             }           },           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ],       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_1\": {           \"value\": \"my-secret-value\",           \"secret\": true         },         \"DEPLOYMENT_ENV_VAR_2\": {           \"value\": \"test\"         }       }     }   },   \"pipelines\": {     \"pipeline-1: {       \"description\": \"\",       \"labels\": {         \"test\": \"label\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"description\": \"\",           \"labels\": {},           \"objects\": [             {               \"name\": \"obj-1\",               \"reference_name\": \"deployment-1\",               \"reference_version\": \"v1\"             }           ],           \"attachments\": [             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"input\",                       \"destination_field_name\": \"input\"                     }                   ],                   \"source_name\": \"pipeline_start\"                 }               ],               \"destination_name\": \"obj-1\"             },             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"output\",                       \"destination_field_name\": \"output\"                     }                   ],                   \"source_name\": \"obj-1\"                 }               ],               \"destination_name\": \"pipeline_end\"             }           ],           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ]     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_1\": {       \"value\": \"value1\",       \"secret\": true     },     \"PROJECT_ENV_VAR_2\": {       \"value\": \"value2\"     }   } } ```  ### Response Structure Details of the updated import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_update_with_http_info(project_name, import_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param ImportUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_update`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.import_update import ImportUpdate

                local_var_params['data'] = ImportUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def instance_types_list(self, organization_name, **kwargs):  # noqa: E501
        """List instance types  # noqa: E501

         ### Description  Get list of available deployment instance types for an organization  ### Response Structure  Details of the instance type - `id`: Unique identifier for the instance type (UUID)   - `name`: Name of the deployment instance type   - `display_name`: Readable name of the deployment instance type   - `memory_allocation`: Integer indicating memory allocation for this instance type (Mi)   - `cpu_allocation`: Integer indicating CPU allocation for this instance type (milliCPU)   - `gpu_allocation`: Integer indicating number of GPU cores for this instance type   - `gpu_enabled`: Boolean indicating if the GPU resource is enabled for this instance type   - `gpu_type`: Type of the GPU enabled for this instance type    #### Response Examples  ``` [   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"name\": \"512mb\",     \"display_name\": \"512 MB\",     \"memory_allocation\": 512,     \"cpu_allocation\": 125,     \"gpu_allocation\": 0,     \"gpu_enabled\": false,     \"gpu_type\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.instance_types_list(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentInstanceType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.instance_types_list_with_http_info(organization_name, **kwargs)  # noqa: E501

    def instance_types_list_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List instance types  # noqa: E501

         ### Description  Get list of available deployment instance types for an organization  ### Response Structure  Details of the instance type - `id`: Unique identifier for the instance type (UUID)   - `name`: Name of the deployment instance type   - `display_name`: Readable name of the deployment instance type   - `memory_allocation`: Integer indicating memory allocation for this instance type (Mi)   - `cpu_allocation`: Integer indicating CPU allocation for this instance type (milliCPU)   - `gpu_allocation`: Integer indicating number of GPU cores for this instance type   - `gpu_enabled`: Boolean indicating if the GPU resource is enabled for this instance type   - `gpu_type`: Type of the GPU enabled for this instance type    #### Response Examples  ``` [   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"name\": \"512mb\",     \"display_name\": \"512 MB\",     \"memory_allocation\": 512,     \"cpu_allocation\": 125,     \"gpu_allocation\": 0,     \"gpu_enabled\": false,     \"gpu_type\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.instance_types_list_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentInstanceType], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method instance_types_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `instance_types_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `instance_types_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/instance-types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentInstanceType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def metrics_get(self, project_name, metric, start_date, end_date, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `request_duration`: Average time in seconds for a pipeline request to complete  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline version  - `object_failed_requests`: Number of failed requests made to deployments in a pipeline  Metrics on deployment version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Average time in seconds for a request to complete  - `memory_peak`: Peak memory used during a request  - `instances`: Number of active deployment instances  - `credits`: Usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_date`: Starting date for the metric values to be returned. It should be provided in datetime isoformat. - `end_date`: Ending date for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `deployment_version` or `pipeline_version`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`. - `user_id`: Uuid of the user for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type` generated by all users.  ### Response Structure  - `start_date`: Timestamp denoting the start of the period over which the metric was measured - `end_date`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 12:03:00 ``` [   {     \"start_date\": \"2019-11-13T12:00:00+00:00\",     \"end_date\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_date\": \"2019-11-13T12:01:00+00:00\",     \"end_date\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_date\": \"2019-11-13T12:02:00+00:00\",     \"end_date\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 14:00:00 ``` [   {    \"start_date\": \"2019-11-13T12:00:00+00:00\",    \"end_date\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_date\": \"2019-11-13T13:00:00+00:00\",     \"end_date\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_date\": \"2019-11-13T14:00:00+00:00\",     \"end_date\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```  With interval as day, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-14 12:00:00 ``` [   {    \"start_date\": \"2019-11-13T00:00:00+00:00\",    \"end_date\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_date\": \"2019-11-14T00:00:00+00:00\",     \"end_date\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```  With interval as month, start_date as 2019-11-13 12:00:00 and end_date as 2019-12-13 12:00:00 ``` [   {    \"start_date\": \"2019-11-01T00:00:00+00:00\",    \"end_date\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get(project_name, metric, start_date, end_date, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_date: (required)
        :param str end_date: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param str user_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Metrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.metrics_get_with_http_info(project_name, metric, start_date, end_date, object_type, **kwargs)  # noqa: E501

    def metrics_get_with_http_info(self, project_name, metric, start_date, end_date, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `request_duration`: Average time in seconds for a pipeline request to complete  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline version  - `object_failed_requests`: Number of failed requests made to deployments in a pipeline  Metrics on deployment version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Average time in seconds for a request to complete  - `memory_peak`: Peak memory used during a request  - `instances`: Number of active deployment instances  - `credits`: Usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_date`: Starting date for the metric values to be returned. It should be provided in datetime isoformat. - `end_date`: Ending date for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `deployment_version` or `pipeline_version`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`. - `user_id`: Uuid of the user for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type` generated by all users.  ### Response Structure  - `start_date`: Timestamp denoting the start of the period over which the metric was measured - `end_date`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 12:03:00 ``` [   {     \"start_date\": \"2019-11-13T12:00:00+00:00\",     \"end_date\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_date\": \"2019-11-13T12:01:00+00:00\",     \"end_date\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_date\": \"2019-11-13T12:02:00+00:00\",     \"end_date\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 14:00:00 ``` [   {    \"start_date\": \"2019-11-13T12:00:00+00:00\",    \"end_date\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_date\": \"2019-11-13T13:00:00+00:00\",     \"end_date\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_date\": \"2019-11-13T14:00:00+00:00\",     \"end_date\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```  With interval as day, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-14 12:00:00 ``` [   {    \"start_date\": \"2019-11-13T00:00:00+00:00\",    \"end_date\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_date\": \"2019-11-14T00:00:00+00:00\",     \"end_date\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```  With interval as month, start_date as 2019-11-13 12:00:00 and end_date as 2019-12-13 12:00:00 ``` [   {    \"start_date\": \"2019-11-01T00:00:00+00:00\",    \"end_date\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get_with_http_info(project_name, metric, start_date, end_date, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_date: (required)
        :param str end_date: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param str user_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Metrics], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'metric', 'start_date', 'end_date', 'object_type', 'interval', 'object_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metrics_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'metric' is set
        if self.api_client.client_side_validation and ('metric' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if self.api_client.client_side_validation and ('start_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_date` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if self.api_client.client_side_validation and ('end_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_date` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'object_type' is set
        if self.api_client.client_side_validation and ('object_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_type` when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metric' in local_var_params
            and local_var_params['metric'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metric'], str):  # noqa: E501
                raise ApiValueError("Parameter `metric` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'object_type' in local_var_params
            and local_var_params['object_type'] is not None):  # noqa: E501
            if not isinstance(local_var_params['object_type'], str):  # noqa: E501
                raise ApiValueError("Parameter `object_type` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'interval' in local_var_params
            and local_var_params['interval'] is not None):  # noqa: E501
            if not isinstance(local_var_params['interval'], str):  # noqa: E501
                raise ApiValueError("Parameter `interval` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'object_id' in local_var_params
            and local_var_params['object_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['object_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `object_id` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `metrics_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'metric' in local_var_params:
            path_params['metric'] = local_var_params['metric']  # noqa: E501

        query_params = []
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'object_type' in local_var_params and local_var_params['object_type'] is not None:  # noqa: E501
            query_params.append(('object_type', local_var_params['object_type']))  # noqa: E501
        if 'object_id' in local_var_params and local_var_params['object_id'] is not None:  # noqa: E501
            query_params.append(('object_id', local_var_params['object_id']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/metrics/{metric}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Metrics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create notification groups  # noqa: E501

         ### Description  Create a notification group by defining a name and a list of contacts  ### Required Parameters  - `name`: Name of the notification group. It is unique within a project.  ### Optional Parameters - `contacts`: A list of dictionaries containing the following keys:   - `type`: Type of the contact. It can be `email`.   - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```  ### Response Structure  Details of the created notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param NotificationGroupCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notification_groups_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def notification_groups_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create notification groups  # noqa: E501

         ### Description  Create a notification group by defining a name and a list of contacts  ### Required Parameters  - `name`: Name of the notification group. It is unique within a project.  ### Optional Parameters - `contacts`: A list of dictionaries containing the following keys:   - `type`: Type of the contact. It can be `email`.   - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```  ### Response Structure  Details of the created notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param NotificationGroupCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `notification_groups_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.notification_group_create import NotificationGroupCreate

                local_var_params['data'] = NotificationGroupCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_delete(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Delete notification group  # noqa: E501

         ### Description  Delete a notification group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_delete(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notification_groups_delete_with_http_info(project_name, notification_group_name, **kwargs)  # noqa: E501

    def notification_groups_delete_with_http_info(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Delete notification group  # noqa: E501

         ### Description  Delete a notification group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_delete_with_http_info(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_delete`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_get(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Get notification group  # noqa: E501

         ### Description  Retrieve details of a single notification group in a project  ### Response Structure  Details of a notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_get(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notification_groups_get_with_http_info(project_name, notification_group_name, **kwargs)  # noqa: E501

    def notification_groups_get_with_http_info(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Get notification group  # noqa: E501

         ### Description  Retrieve details of a single notification group in a project  ### Response Structure  Details of a notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_get_with_http_info(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_get`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_list(self, project_name, **kwargs):  # noqa: E501
        """List notification groups  # noqa: E501

         ### Description  List the notification groups in a project  ### Response Structure  A list of details of the notification groups in the project - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` [   {     \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",     \"name\": \"notification-group-1\",     \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user@ubiops.com\"         }       },       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.2@ubiops.com\"         }       }     ],   },   {     \"id\": \"7193ca09-d28b-4fce-a15a-11e0bc9f7f6f\",     \"name\": \"notification-group-2\",      \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.3@ubiops.com\"         }       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[NotificationGroupList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notification_groups_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def notification_groups_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List notification groups  # noqa: E501

         ### Description  List the notification groups in a project  ### Response Structure  A list of details of the notification groups in the project - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` [   {     \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",     \"name\": \"notification-group-1\",     \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user@ubiops.com\"         }       },       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.2@ubiops.com\"         }       }     ],   },   {     \"id\": \"7193ca09-d28b-4fce-a15a-11e0bc9f7f6f\",     \"name\": \"notification-group-2\",      \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.3@ubiops.com\"         }       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[NotificationGroupList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NotificationGroupList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_update(self, project_name, notification_group_name, data, **kwargs):  # noqa: E501
        """Update notification group  # noqa: E501

         ### Description  Update a notification group  ### Optional Parameters  - `name`: New name for the deployment - `contacts`: A list of dictionaries containing the following keys:  - `type`: Type of the contact. It can be `email`.  - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"new-notification-group-name\" } ```  ### Response Structure  Details of the updated notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"new-notification-group-name\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_update(project_name, notification_group_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param NotificationGroupUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.notification_groups_update_with_http_info(project_name, notification_group_name, data, **kwargs)  # noqa: E501

    def notification_groups_update_with_http_info(self, project_name, notification_group_name, data, **kwargs):  # noqa: E501
        """Update notification group  # noqa: E501

         ### Description  Update a notification group  ### Optional Parameters  - `name`: New name for the deployment - `contacts`: A list of dictionaries containing the following keys:  - `type`: Type of the contact. It can be `email`.  - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"new-notification-group-name\" } ```  ### Response Structure  Details of the updated notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"new-notification-group-name\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_update_with_http_info(project_name, notification_group_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param NotificationGroupUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_update`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.notification_group_update import NotificationGroupUpdate

                local_var_params['data'] = NotificationGroupUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_create(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_create_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organization_users_create_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.organization_user_create import OrganizationUserCreate

                local_var_params['data'] = OrganizationUserCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_delete(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_delete_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_delete_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_get(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_get_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_get_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_get`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_list(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationUserDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_list_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_users_list_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationUserDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationUserDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_update(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_update_with_http_info(organization_name, user_id, data, **kwargs)  # noqa: E501

    def organization_users_update_with_http_info(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update_with_http_info(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.organization_user_update import OrganizationUserUpdate

                local_var_params['data'] = OrganizationUserUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_create(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year. If you are going to use a subscription other than the free subscription, you should provide the end date.  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_end_date\": \"2021-03-25\" } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_create_with_http_info(data, **kwargs)  # noqa: E501

    def organizations_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year. If you are going to use a subscription other than the free subscription, you should provide the end date.  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_end_date\": \"2021-03-25\" } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.organization_create import OrganizationCreate

                local_var_params['data'] = OrganizationCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_get(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription of the organization   - `subscription_self_service`: Boolean indicating if the organization subscription is self service    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\",   \"subscription_self_service\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription of the organization   - `subscription_self_service`: Boolean indicating if the organization subscription is self service    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\",   \"subscription_self_service\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_list(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_list_with_http_info(**kwargs)  # noqa: E501

    def organizations_list_with_http_info(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_resource_usage(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_resource_usage_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_resource_usage_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceUsage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_resource_usage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_resource_usage`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_resource_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_update(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If you are going to update the subscription plan of the organization to a subscription other than free, you have to provide the end date. - `subscription_start_date`: Start date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will start from the provided date. If you are going to update the subscription of the organization or schedule a subscription for a time in future, you have to provide the start date.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_update_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organizations_update_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If you are going to update the subscription plan of the organization to a subscription other than free, you have to provide the end date. - `subscription_start_date`: Start date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will start from the provided date. If you are going to update the subscription of the organization or schedule a subscription for a time in future, you have to provide the start date.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.organization_update import OrganizationUpdate

                local_var_params['data'] = OrganizationUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_usage_get(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. It contains **the details of each metric aggregated per month.**   ### Optional Parameters  - `start_date`: date indicating the start date to fetch usage data from. If omitted, results are generated for current subscription period. - `end_date`: date indicating the end date to fetch usage data until. If omitted, results are generated for current subscription period. - `interval`: interval for which the usage data is fetched. It can be 'day' or 'month'. It defaults to 'month'.  If no **start_date** or **end_date** is given, the current subscription period is used, e.g. if the usage details are requested on 01-12-2020 and the subscription started on 20-11-2020, the results will contain data from 20-11-2020 to 20-12-2020. When **start_date** and **end_date** are given, this month period is used, e.g. if 12-11-2020 is given as start date and 12-12-2020 as end date, the results will contain data from 12-11-2020 to 12-12-2020.  ### Response Structure - `metric`: Metric name - `object_type`: Type of object the metric was measured for (deployment_version or pipeline_version) - `usage`: an array of objects each containing the following:   - `start_date`: Timestamp denoting the start of the current subscription period or the provided date   - `end_date`: Timestamp denoting the end of the current subscription period or the provided date   - `value`: Aggregated metric value for the given unit over the given month   #### Response Examples 2019-08-01 as start date and 2019-09-01 as end date ``` [   {     \"object_type\": \"deployment_version\",     \"metric\": \"credits\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1484124       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1204       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1598       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1840       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 400       }       ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_usage_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param datetime start_date:
        :param datetime end_date:
        :param str interval:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Usage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_usage_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_usage_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. It contains **the details of each metric aggregated per month.**   ### Optional Parameters  - `start_date`: date indicating the start date to fetch usage data from. If omitted, results are generated for current subscription period. - `end_date`: date indicating the end date to fetch usage data until. If omitted, results are generated for current subscription period. - `interval`: interval for which the usage data is fetched. It can be 'day' or 'month'. It defaults to 'month'.  If no **start_date** or **end_date** is given, the current subscription period is used, e.g. if the usage details are requested on 01-12-2020 and the subscription started on 20-11-2020, the results will contain data from 20-11-2020 to 20-12-2020. When **start_date** and **end_date** are given, this month period is used, e.g. if 12-11-2020 is given as start date and 12-12-2020 as end date, the results will contain data from 12-11-2020 to 12-12-2020.  ### Response Structure - `metric`: Metric name - `object_type`: Type of object the metric was measured for (deployment_version or pipeline_version) - `usage`: an array of objects each containing the following:   - `start_date`: Timestamp denoting the start of the current subscription period or the provided date   - `end_date`: Timestamp denoting the end of the current subscription period or the provided date   - `value`: Aggregated metric value for the given unit over the given month   #### Response Examples 2019-08-01 as start date and 2019-09-01 as end date ``` [   {     \"object_type\": \"deployment_version\",     \"metric\": \"credits\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1484124       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1204       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1598       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1840       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 400       }       ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_usage_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param datetime start_date:
        :param datetime end_date:
        :param str interval:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Usage], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'start_date', 'end_date', 'interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_usage_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_usage_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_usage_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'interval' in local_var_params
            and local_var_params['interval'] is not None):  # noqa: E501
            if not isinstance(local_var_params['interval'], str):  # noqa: E501
                raise ApiValueError("Parameter `interval` must be a string when calling `organizations_usage_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Usage]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_list(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PermissionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_list_with_http_info(**kwargs)  # noqa: E501

    def permissions_list_with_http_info(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PermissionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_audit_events_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_audit_events_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_batch_delete(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline requests  # noqa: E501

         ### Description Delete multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_delete(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_batch_delete_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline requests  # noqa: E501

         ### Description Delete multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_batch_get(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline requests  # noqa: E501

         ### Description Retrieve multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_get(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_batch_get_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline requests  # noqa: E501

         ### Description Retrieve multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a pipeline request  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300  (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"error_message\": \"Invalid message format\"      }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a pipeline request  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300  (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"error_message\": \"Invalid message format\"      }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_timeout' in local_var_params
            and local_var_params['pipeline_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_timeout' in local_var_params
            and local_var_params['deployment_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `deployment_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_delete(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete a pipeline request  # noqa: E501

         ### Description Delete a request for the default version of a pipeline. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_delete(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def pipeline_requests_delete_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete a pipeline request  # noqa: E501

         ### Description Delete a request for the default version of a pipeline. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_get(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get a pipeline request  # noqa: E501

         ### Description Get a request for the default version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the pipeline (and version) names if the request is directly made to the pipeline    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\"     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"pipeline\": \"pipeline-1\",     \"pipeline\"_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_get(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def pipeline_requests_get_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get a pipeline request  # noqa: E501

         ### Description Get a request for the default version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the pipeline (and version) names if the request is directly made to the pipeline    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\"     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"pipeline\": \"pipeline-1\",     \"pipeline\"_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `pipeline_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_requests_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'status', 'success', 'limit', 'offset', 'sort', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `pipeline_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between objects in a pipeline version. An attachment can only be made between objects that have already been added to the pipeline version.  The objects where the attachment starts is called the source objects. The object that is linked is called the destination object. When attaching source objects to a destination object, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all output fields of all source objects need to be used in the mapping. It is also possible that one source output field links to multiple destination input fields.  The *pipeline_start* object can only be a source object. The *pipeline_end* object can only be a destination object.  In case of plain type of objects, the mapping `source_field_name` and `destination_field_name` must be omitted or given as null.  ### Required Parameters  - `destination_name`: Name of the destination object in the pipeline version - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name). Each item in the sources list must contain source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two structured deployments ``` {   \"destination_name\": \"deployment-2-v1\",   \"sources\": [     {       \"source_name\": \"deployment-1-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-output-field-1\",           \"destination_field_name\": \"deployment-2-input-field-1\"         },         {           \"source_field_name\": \"deployment-output-field-2\",           \"destination_field_name\": \"deployment-2-input-field-2\"         },         {           \"source_field_name\": \"deployment-output-field-3\",           \"destination_field_name\": \"deployment-2-input-field-3\"         }       ]     },   ] } ``` An attachment between two plain input/output type deployments ``` {   \"destination_name\": \"plain-deployment-v4\",   \"sources\": [     {       \"source_name\": \"plain-deployment-v3\",       \"mapping\": []     }   ] } ```  An attachment between a pipeline_start object and deployment ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```  An attachment between a deployment and a pipeline_end object ``` {   \"destination_name\": \"pipeline_end\",   \"sources\": [     {       \"source_name\": \"deployment-3-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-3-output-field-1\",           \"destination_field_name\": \"pipeline-output-field-1\"         },         {           \"source_field_name\": \"deployment-3-output-field-2\",           \"destination_field_name\": \"pipeline-output-field-2\"         }       ]     }   ] } ```  ### Response Structure  Details of the created attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param AttachmentsCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttachmentsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between objects in a pipeline version. An attachment can only be made between objects that have already been added to the pipeline version.  The objects where the attachment starts is called the source objects. The object that is linked is called the destination object. When attaching source objects to a destination object, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all output fields of all source objects need to be used in the mapping. It is also possible that one source output field links to multiple destination input fields.  The *pipeline_start* object can only be a source object. The *pipeline_end* object can only be a destination object.  In case of plain type of objects, the mapping `source_field_name` and `destination_field_name` must be omitted or given as null.  ### Required Parameters  - `destination_name`: Name of the destination object in the pipeline version - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name). Each item in the sources list must contain source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two structured deployments ``` {   \"destination_name\": \"deployment-2-v1\",   \"sources\": [     {       \"source_name\": \"deployment-1-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-output-field-1\",           \"destination_field_name\": \"deployment-2-input-field-1\"         },         {           \"source_field_name\": \"deployment-output-field-2\",           \"destination_field_name\": \"deployment-2-input-field-2\"         },         {           \"source_field_name\": \"deployment-output-field-3\",           \"destination_field_name\": \"deployment-2-input-field-3\"         }       ]     },   ] } ``` An attachment between two plain input/output type deployments ``` {   \"destination_name\": \"plain-deployment-v4\",   \"sources\": [     {       \"source_name\": \"plain-deployment-v3\",       \"mapping\": []     }   ] } ```  An attachment between a pipeline_start object and deployment ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```  An attachment between a deployment and a pipeline_end object ``` {   \"destination_name\": \"pipeline_end\",   \"sources\": [     {       \"source_name\": \"deployment-3-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-3-output-field-1\",           \"destination_field_name\": \"pipeline-output-field-1\"         },         {           \"source_field_name\": \"deployment-3-output-field-2\",           \"destination_field_name\": \"pipeline-output-field-2\"         }       ]     }   ] } ```  ### Response Structure  Details of the created attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param AttachmentsCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttachmentsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.attachments_create import AttachmentsCreate

                local_var_params['data'] = AttachmentsCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttachmentsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_delete(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete object attachment  # noqa: E501

         ### Description  Delete an attachment in a pipeline version. The referenced and original objects of the attachment still exist in the pipeline version, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_delete(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_delete_with_http_info(project_name, attachment_id, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_delete_with_http_info(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete object attachment  # noqa: E501

         ### Description  Delete an attachment in a pipeline version. The referenced and original objects of the attachment still exist in the pipeline version, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_delete_with_http_info(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'attachment_id', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'attachment_id' is set
        if self.api_client.client_side_validation and ('attachment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attachment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attachment_id` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'attachment_id' in local_var_params
            and local_var_params['attachment_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['attachment_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `attachment_id` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'attachment_id' in local_var_params:
            path_params['attachment_id'] = local_var_params['attachment_id']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments/{attachment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_destination_get(self, project_name, destination_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List the attachments of a destination object  # noqa: E501

         ### Description  List attachments of a destination object in a pipeline version  ### Response Structure  A list of details of the attachments of the given destination object in the pipeline version - `destination_name`: Name of the destination object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v1\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_destination_get(project_name, destination_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_destination_get_with_http_info(project_name, destination_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_destination_get_with_http_info(self, project_name, destination_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List the attachments of a destination object  # noqa: E501

         ### Description  List attachments of a destination object in a pipeline version  ### Response Structure  A list of details of the attachments of the given destination object in the pipeline version - `destination_name`: Name of the destination object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v1\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_destination_get_with_http_info(project_name, destination_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'destination_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_destination_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'destination_name' is set
        if self.api_client.client_side_validation and ('destination_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['destination_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `destination_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'destination_name' in local_var_params
            and local_var_params['destination_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['destination_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `destination_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'destination_name' in local_var_params:
            path_params['destination_name'] = local_var_params['destination_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{destination_name}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_get(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Get object attachment  # noqa: E501

         ### Description  Get the details of a single attachment in a pipeline  ### Response Structure  Details of the attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-3-v1\",   \"sources\": [     {       \"source_name\": \"deployment-2-v2\",       \"mapping\": [         {           \"source_field_name\": \"deployment-2-output-field-1\",           \"destination_field_name\": \"deployment-3-input-field-1\"         },         {           \"source_field_name\": \"deployment-2-output-field-2\",           \"destination_field_name\": \"deployment-3-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_get(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttachmentsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_get_with_http_info(project_name, attachment_id, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_get_with_http_info(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Get object attachment  # noqa: E501

         ### Description  Get the details of a single attachment in a pipeline  ### Response Structure  Details of the attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-3-v1\",   \"sources\": [     {       \"source_name\": \"deployment-2-v2\",       \"mapping\": [         {           \"source_field_name\": \"deployment-2-output-field-1\",           \"destination_field_name\": \"deployment-3-input-field-1\"         },         {           \"source_field_name\": \"deployment-2-output-field-2\",           \"destination_field_name\": \"deployment-3-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_get_with_http_info(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttachmentsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'attachment_id', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'attachment_id' is set
        if self.api_client.client_side_validation and ('attachment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attachment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attachment_id` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'attachment_id' in local_var_params
            and local_var_params['attachment_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['attachment_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `attachment_id` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'attachment_id' in local_var_params:
            path_params['attachment_id'] = local_var_params['attachment_id']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments/{attachment_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttachmentsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_list(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline version  ### Response Structure  A list of details of the attachments in the pipeline - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the source object(s) and mapping of the fields. One attachment can have multiple source objects.  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-2-v2\",     \"sources\": [       {         \"source_name\": \"pipeline_start\",         \"mapping\": [           {             \"source_field_name\": \"pipeline-input-field-1\",             \"destination_field_name\": \"deployment-input-field-1\"           },           {             \"source_field_name\": \"pipeline-input-field-2\",             \"destination_field_name\": \"deployment-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {          \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           },           {             \"source_field_name\": \"deployment-output-field-3\",             \"destination_field_name\": \"deployment-3-input-field-3\"           }         ]       }     ]   },   {     \"destination_name\": \"pipeline_end\",     \"sources\": [       {         \"source_name\": \"deployment-3-v1\",         \"mapping\": [           {             \"source_field_name\": \"deployment-3-output-field-1\",             \"destination_field_name\": \"pipeline-output-field-1\"           },           {             \"source_field_name\": \"deployment-3-output-field-2\",             \"destination_field_name\": \"pipeline-output-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_list(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_list_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_list_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline version  ### Response Structure  A list of details of the attachments in the pipeline - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the source object(s) and mapping of the fields. One attachment can have multiple source objects.  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-2-v2\",     \"sources\": [       {         \"source_name\": \"pipeline_start\",         \"mapping\": [           {             \"source_field_name\": \"pipeline-input-field-1\",             \"destination_field_name\": \"deployment-input-field-1\"           },           {             \"source_field_name\": \"pipeline-input-field-2\",             \"destination_field_name\": \"deployment-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {          \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           },           {             \"source_field_name\": \"deployment-output-field-3\",             \"destination_field_name\": \"deployment-3-input-field-3\"           }         ]       }     ]   },   {     \"destination_name\": \"pipeline_end\",     \"sources\": [       {         \"source_name\": \"deployment-3-v1\",         \"mapping\": [           {             \"source_field_name\": \"deployment-3-output-field-1\",             \"destination_field_name\": \"pipeline-output-field-1\"           },           {             \"source_field_name\": \"deployment-3-output-field-2\",             \"destination_field_name\": \"pipeline-output-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_list_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_environment_variables_list(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_environment_variables_list_with_http_info(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline object  # noqa: E501

         ### Description  Create a pipeline object for a pipeline version. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline version. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline version as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline version. - `reference_name`: Name of the object it will reference - `version`: Version name of reference object. Do not provide this field to refer to the default version of the reference.  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_objects_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline object  # noqa: E501

         ### Description  Create a pipeline object for a pipeline version. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline version. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline version as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline version. - `reference_name`: Name of the object it will reference - `version`: Version name of reference object. Do not provide this field to refer to the default version of the reference.  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.pipeline_version_object_create import PipelineVersionObjectCreate

                local_var_params['data'] = PipelineVersionObjectCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP