"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const targets = require("@aws-cdk/aws-events-targets");
const lambda = require("@aws-cdk/aws-lambda");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const config = require("../lib");
const app = new cdk.App();
class ConfigStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        /// !show
        // A custom rule that runs on configuration changes of EC2 instances
        const fn = new lambda.Function(this, 'CustomFunction', {
            code: lambda.AssetCode.fromInline('exports.handler = (event) => console.log(event);'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X
        });
        const customRule = new config.CustomRule(this, 'Custom', {
            configurationChanges: true,
            lambdaFunction: fn
        });
        customRule.scopeToResource('AWS::EC2::Instance');
        // A rule to detect stacks drifts
        const driftRule = new config.CloudFormationStackDriftDetectionCheck(this, 'Drift');
        // Topic for compliance events
        const complianceTopic = new sns.Topic(this, 'ComplianceTopic');
        // Send notification on compliance change
        driftRule.onComplianceChange('ComplianceChange', {
            target: new targets.SnsTopic(complianceTopic)
        });
        /// !hide
    }
}
new ConfigStack(app, 'aws-cdk-config-rule-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucnVsZS5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5ydWxlLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHVEQUF1RDtBQUN2RCw4Q0FBOEM7QUFDOUMsd0NBQXdDO0FBQ3hDLHFDQUFxQztBQUNyQyxpQ0FBaUM7QUFFakMsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFMUIsTUFBTSxXQUFZLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDakMsWUFBWSxLQUFjLEVBQUUsRUFBVSxFQUFFLEtBQXNCO1FBQzVELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLFNBQVM7UUFDVCxvRUFBb0U7UUFDcEUsTUFBTSxFQUFFLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUNyRCxJQUFJLEVBQUUsTUFBTSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsa0RBQWtELENBQUM7WUFDckYsT0FBTyxFQUFFLGVBQWU7WUFDeEIsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztTQUNwQyxDQUFDLENBQUM7UUFFSCxNQUFNLFVBQVUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRTtZQUN2RCxvQkFBb0IsRUFBRSxJQUFJO1lBQzFCLGNBQWMsRUFBRSxFQUFFO1NBQ25CLENBQUMsQ0FBQztRQUVILFVBQVUsQ0FBQyxlQUFlLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUVqRCxpQ0FBaUM7UUFDakMsTUFBTSxTQUFTLEdBQUcsSUFBSSxNQUFNLENBQUMsc0NBQXNDLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRW5GLDhCQUE4QjtRQUM5QixNQUFNLGVBQWUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFFL0QseUNBQXlDO1FBQ3pDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsRUFBRTtZQUMvQyxNQUFNLEVBQUUsSUFBSSxPQUFPLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQztTQUM5QyxDQUFDLENBQUM7UUFDSCxTQUFTO0lBQ1gsQ0FBQztDQUNGO0FBRUQsSUFBSSxXQUFXLENBQUMsR0FBRyxFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFDbEQsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgdGFyZ2V0cyBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzLXRhcmdldHMnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY29uZmlnIGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNsYXNzIENvbmZpZ1N0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcsIHByb3BzPzogY2RrLlN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIC8vLyAhc2hvd1xuICAgIC8vIEEgY3VzdG9tIHJ1bGUgdGhhdCBydW5zIG9uIGNvbmZpZ3VyYXRpb24gY2hhbmdlcyBvZiBFQzIgaW5zdGFuY2VzXG4gICAgY29uc3QgZm4gPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHRoaXMsICdDdXN0b21GdW5jdGlvbicsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Bc3NldENvZGUuZnJvbUlubGluZSgnZXhwb3J0cy5oYW5kbGVyID0gKGV2ZW50KSA9PiBjb25zb2xlLmxvZyhldmVudCk7JyksXG4gICAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTBfWFxuICAgIH0pO1xuXG4gICAgY29uc3QgY3VzdG9tUnVsZSA9IG5ldyBjb25maWcuQ3VzdG9tUnVsZSh0aGlzLCAnQ3VzdG9tJywge1xuICAgICAgY29uZmlndXJhdGlvbkNoYW5nZXM6IHRydWUsXG4gICAgICBsYW1iZGFGdW5jdGlvbjogZm5cbiAgICB9KTtcblxuICAgIGN1c3RvbVJ1bGUuc2NvcGVUb1Jlc291cmNlKCdBV1M6OkVDMjo6SW5zdGFuY2UnKTtcblxuICAgIC8vIEEgcnVsZSB0byBkZXRlY3Qgc3RhY2tzIGRyaWZ0c1xuICAgIGNvbnN0IGRyaWZ0UnVsZSA9IG5ldyBjb25maWcuQ2xvdWRGb3JtYXRpb25TdGFja0RyaWZ0RGV0ZWN0aW9uQ2hlY2sodGhpcywgJ0RyaWZ0Jyk7XG5cbiAgICAvLyBUb3BpYyBmb3IgY29tcGxpYW5jZSBldmVudHNcbiAgICBjb25zdCBjb21wbGlhbmNlVG9waWMgPSBuZXcgc25zLlRvcGljKHRoaXMsICdDb21wbGlhbmNlVG9waWMnKTtcblxuICAgIC8vIFNlbmQgbm90aWZpY2F0aW9uIG9uIGNvbXBsaWFuY2UgY2hhbmdlXG4gICAgZHJpZnRSdWxlLm9uQ29tcGxpYW5jZUNoYW5nZSgnQ29tcGxpYW5jZUNoYW5nZScsIHtcbiAgICAgIHRhcmdldDogbmV3IHRhcmdldHMuU25zVG9waWMoY29tcGxpYW5jZVRvcGljKVxuICAgIH0pO1xuICAgIC8vLyAhaGlkZVxuICB9XG59XG5cbm5ldyBDb25maWdTdGFjayhhcHAsICdhd3MtY2RrLWNvbmZpZy1ydWxlLWludGVnJyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==