#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', 'networkx', 'more-itertools', 'numpy', ]

setup_requirements = ['pytest-runner', ]

test_requirements = ['pytest>=3', 'pandas', ]

setup(
    author="NAGY, Attila",
    author_email='nagy.attila@gmail.com',
    python_requires='>=3.5',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Pandas DAG",
    entry_points={
        'console_scripts': [
            'pandag=pandag.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='pandag',
    name='pandag',
    packages=find_packages(include=['pandag', 'pandag.*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/Mikata-Project/pandag',
    version='0.0.9',
    zip_safe=False,
)
