# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from collections import OrderedDict
import functools
import re
from typing import Dict, Mapping, Optional, Sequence, Tuple, Type, Union
import pkg_resources

from google.api_core.client_options import ClientOptions
from google.api_core import exceptions as core_exceptions
from google.api_core import gapic_v1
from google.api_core import retry as retries
from google.auth import credentials as ga_credentials  # type: ignore
from google.oauth2 import service_account  # type: ignore

try:
    OptionalRetry = Union[retries.Retry, gapic_v1.method._MethodDefault]
except AttributeError:  # pragma: NO COVER
    OptionalRetry = Union[retries.Retry, object]  # type: ignore

from google.api_core import operation  # type: ignore
from google.api_core import operation_async  # type: ignore
from google.cloud.network_services_v1.services.network_services import pagers
from google.cloud.network_services_v1.types import common
from google.cloud.network_services_v1.types import endpoint_policy
from google.cloud.network_services_v1.types import (
    endpoint_policy as gcn_endpoint_policy,
)
from google.protobuf import empty_pb2  # type: ignore
from google.protobuf import field_mask_pb2  # type: ignore
from google.protobuf import timestamp_pb2  # type: ignore
from .transports.base import NetworkServicesTransport, DEFAULT_CLIENT_INFO
from .transports.grpc_asyncio import NetworkServicesGrpcAsyncIOTransport
from .client import NetworkServicesClient


class NetworkServicesAsyncClient:
    """"""

    _client: NetworkServicesClient

    DEFAULT_ENDPOINT = NetworkServicesClient.DEFAULT_ENDPOINT
    DEFAULT_MTLS_ENDPOINT = NetworkServicesClient.DEFAULT_MTLS_ENDPOINT

    authorization_policy_path = staticmethod(
        NetworkServicesClient.authorization_policy_path
    )
    parse_authorization_policy_path = staticmethod(
        NetworkServicesClient.parse_authorization_policy_path
    )
    client_tls_policy_path = staticmethod(NetworkServicesClient.client_tls_policy_path)
    parse_client_tls_policy_path = staticmethod(
        NetworkServicesClient.parse_client_tls_policy_path
    )
    endpoint_policy_path = staticmethod(NetworkServicesClient.endpoint_policy_path)
    parse_endpoint_policy_path = staticmethod(
        NetworkServicesClient.parse_endpoint_policy_path
    )
    server_tls_policy_path = staticmethod(NetworkServicesClient.server_tls_policy_path)
    parse_server_tls_policy_path = staticmethod(
        NetworkServicesClient.parse_server_tls_policy_path
    )
    common_billing_account_path = staticmethod(
        NetworkServicesClient.common_billing_account_path
    )
    parse_common_billing_account_path = staticmethod(
        NetworkServicesClient.parse_common_billing_account_path
    )
    common_folder_path = staticmethod(NetworkServicesClient.common_folder_path)
    parse_common_folder_path = staticmethod(
        NetworkServicesClient.parse_common_folder_path
    )
    common_organization_path = staticmethod(
        NetworkServicesClient.common_organization_path
    )
    parse_common_organization_path = staticmethod(
        NetworkServicesClient.parse_common_organization_path
    )
    common_project_path = staticmethod(NetworkServicesClient.common_project_path)
    parse_common_project_path = staticmethod(
        NetworkServicesClient.parse_common_project_path
    )
    common_location_path = staticmethod(NetworkServicesClient.common_location_path)
    parse_common_location_path = staticmethod(
        NetworkServicesClient.parse_common_location_path
    )

    @classmethod
    def from_service_account_info(cls, info: dict, *args, **kwargs):
        """Creates an instance of this client using the provided credentials
            info.

        Args:
            info (dict): The service account private key info.
            args: Additional arguments to pass to the constructor.
            kwargs: Additional arguments to pass to the constructor.

        Returns:
            NetworkServicesAsyncClient: The constructed client.
        """
        return NetworkServicesClient.from_service_account_info.__func__(NetworkServicesAsyncClient, info, *args, **kwargs)  # type: ignore

    @classmethod
    def from_service_account_file(cls, filename: str, *args, **kwargs):
        """Creates an instance of this client using the provided credentials
            file.

        Args:
            filename (str): The path to the service account private key json
                file.
            args: Additional arguments to pass to the constructor.
            kwargs: Additional arguments to pass to the constructor.

        Returns:
            NetworkServicesAsyncClient: The constructed client.
        """
        return NetworkServicesClient.from_service_account_file.__func__(NetworkServicesAsyncClient, filename, *args, **kwargs)  # type: ignore

    from_service_account_json = from_service_account_file

    @classmethod
    def get_mtls_endpoint_and_cert_source(
        cls, client_options: Optional[ClientOptions] = None
    ):
        """Return the API endpoint and client cert source for mutual TLS.

        The client cert source is determined in the following order:
        (1) if `GOOGLE_API_USE_CLIENT_CERTIFICATE` environment variable is not "true", the
        client cert source is None.
        (2) if `client_options.client_cert_source` is provided, use the provided one; if the
        default client cert source exists, use the default one; otherwise the client cert
        source is None.

        The API endpoint is determined in the following order:
        (1) if `client_options.api_endpoint` if provided, use the provided one.
        (2) if `GOOGLE_API_USE_CLIENT_CERTIFICATE` environment variable is "always", use the
        default mTLS endpoint; if the environment variabel is "never", use the default API
        endpoint; otherwise if client cert source exists, use the default mTLS endpoint, otherwise
        use the default API endpoint.

        More details can be found at https://google.aip.dev/auth/4114.

        Args:
            client_options (google.api_core.client_options.ClientOptions): Custom options for the
                client. Only the `api_endpoint` and `client_cert_source` properties may be used
                in this method.

        Returns:
            Tuple[str, Callable[[], Tuple[bytes, bytes]]]: returns the API endpoint and the
                client cert source to use.

        Raises:
            google.auth.exceptions.MutualTLSChannelError: If any errors happen.
        """
        return NetworkServicesClient.get_mtls_endpoint_and_cert_source(client_options)  # type: ignore

    @property
    def transport(self) -> NetworkServicesTransport:
        """Returns the transport used by the client instance.

        Returns:
            NetworkServicesTransport: The transport used by the client instance.
        """
        return self._client.transport

    get_transport_class = functools.partial(
        type(NetworkServicesClient).get_transport_class, type(NetworkServicesClient)
    )

    def __init__(
        self,
        *,
        credentials: ga_credentials.Credentials = None,
        transport: Union[str, NetworkServicesTransport] = "grpc_asyncio",
        client_options: ClientOptions = None,
        client_info: gapic_v1.client_info.ClientInfo = DEFAULT_CLIENT_INFO,
    ) -> None:
        """Instantiates the network services client.

        Args:
            credentials (Optional[google.auth.credentials.Credentials]): The
                authorization credentials to attach to requests. These
                credentials identify the application to the service; if none
                are specified, the client will attempt to ascertain the
                credentials from the environment.
            transport (Union[str, ~.NetworkServicesTransport]): The
                transport to use. If set to None, a transport is chosen
                automatically.
            client_options (ClientOptions): Custom options for the client. It
                won't take effect if a ``transport`` instance is provided.
                (1) The ``api_endpoint`` property can be used to override the
                default endpoint provided by the client. GOOGLE_API_USE_MTLS_ENDPOINT
                environment variable can also be used to override the endpoint:
                "always" (always use the default mTLS endpoint), "never" (always
                use the default regular endpoint) and "auto" (auto switch to the
                default mTLS endpoint if client certificate is present, this is
                the default value). However, the ``api_endpoint`` property takes
                precedence if provided.
                (2) If GOOGLE_API_USE_CLIENT_CERTIFICATE environment variable
                is "true", then the ``client_cert_source`` property can be used
                to provide client certificate for mutual TLS transport. If
                not provided, the default SSL client certificate will be used if
                present. If GOOGLE_API_USE_CLIENT_CERTIFICATE is "false" or not
                set, no client certificate will be used.

        Raises:
            google.auth.exceptions.MutualTlsChannelError: If mutual TLS transport
                creation failed for any reason.
        """
        self._client = NetworkServicesClient(
            credentials=credentials,
            transport=transport,
            client_options=client_options,
            client_info=client_info,
        )

    async def list_endpoint_policies(
        self,
        request: Union[endpoint_policy.ListEndpointPoliciesRequest, dict] = None,
        *,
        parent: str = None,
        retry: OptionalRetry = gapic_v1.method.DEFAULT,
        timeout: float = None,
        metadata: Sequence[Tuple[str, str]] = (),
    ) -> pagers.ListEndpointPoliciesAsyncPager:
        r"""Lists EndpointPolicies in a given project and
        location.


        .. code-block:: python

            from google.cloud import network_services_v1

            def sample_list_endpoint_policies():
                # Create a client
                client = network_services_v1.NetworkServicesClient()

                # Initialize request argument(s)
                request = network_services_v1.ListEndpointPoliciesRequest(
                    parent="parent_value",
                )

                # Make the request
                page_result = client.list_endpoint_policies(request=request)

                # Handle the response
                for response in page_result:
                    print(response)

        Args:
            request (Union[google.cloud.network_services_v1.types.ListEndpointPoliciesRequest, dict]):
                The request object. Request used with the
                ListEndpointPolicies method.
            parent (:class:`str`):
                Required. The project and location from which the
                EndpointPolicies should be listed, specified in the
                format ``projects/*/locations/global``.

                This corresponds to the ``parent`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry.Retry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.cloud.network_services_v1.services.network_services.pagers.ListEndpointPoliciesAsyncPager:
                Response returned by the
                ListEndpointPolicies method.
                Iterating over this object will yield
                results and resolve additional pages
                automatically.

        """
        # Create or coerce a protobuf request object.
        # Quick check: If we got a request object, we should *not* have
        # gotten any keyword arguments that map to the request.
        has_flattened_params = any([parent])
        if request is not None and has_flattened_params:
            raise ValueError(
                "If the `request` argument is set, then none of "
                "the individual field arguments should be set."
            )

        request = endpoint_policy.ListEndpointPoliciesRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if parent is not None:
            request.parent = parent

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = gapic_v1.method_async.wrap_method(
            self._client._transport.list_endpoint_policies,
            default_timeout=None,
            client_info=DEFAULT_CLIENT_INFO,
        )

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", request.parent),)),
        )

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # This method is paged; wrap the response in a pager, which provides
        # an `__aiter__` convenience method.
        response = pagers.ListEndpointPoliciesAsyncPager(
            method=rpc,
            request=request,
            response=response,
            metadata=metadata,
        )

        # Done; return the response.
        return response

    async def get_endpoint_policy(
        self,
        request: Union[endpoint_policy.GetEndpointPolicyRequest, dict] = None,
        *,
        name: str = None,
        retry: OptionalRetry = gapic_v1.method.DEFAULT,
        timeout: float = None,
        metadata: Sequence[Tuple[str, str]] = (),
    ) -> endpoint_policy.EndpointPolicy:
        r"""Gets details of a single EndpointPolicy.

        .. code-block:: python

            from google.cloud import network_services_v1

            def sample_get_endpoint_policy():
                # Create a client
                client = network_services_v1.NetworkServicesClient()

                # Initialize request argument(s)
                request = network_services_v1.GetEndpointPolicyRequest(
                    name="name_value",
                )

                # Make the request
                response = client.get_endpoint_policy(request=request)

                # Handle the response
                print(response)

        Args:
            request (Union[google.cloud.network_services_v1.types.GetEndpointPolicyRequest, dict]):
                The request object. Request used with the
                GetEndpointPolicy method.
            name (:class:`str`):
                Required. A name of the EndpointPolicy to get. Must be
                in the format
                ``projects/*/locations/global/endpointPolicies/*``.

                This corresponds to the ``name`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry.Retry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.cloud.network_services_v1.types.EndpointPolicy:
                EndpointPolicy is a resource that
                helps apply desired configuration on the
                endpoints that match specific criteria.
                For example, this resource can be used
                to apply "authentication config" an all
                endpoints that serve on port 8080.

        """
        # Create or coerce a protobuf request object.
        # Quick check: If we got a request object, we should *not* have
        # gotten any keyword arguments that map to the request.
        has_flattened_params = any([name])
        if request is not None and has_flattened_params:
            raise ValueError(
                "If the `request` argument is set, then none of "
                "the individual field arguments should be set."
            )

        request = endpoint_policy.GetEndpointPolicyRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if name is not None:
            request.name = name

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = gapic_v1.method_async.wrap_method(
            self._client._transport.get_endpoint_policy,
            default_timeout=None,
            client_info=DEFAULT_CLIENT_INFO,
        )

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("name", request.name),)),
        )

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Done; return the response.
        return response

    async def create_endpoint_policy(
        self,
        request: Union[gcn_endpoint_policy.CreateEndpointPolicyRequest, dict] = None,
        *,
        parent: str = None,
        endpoint_policy: gcn_endpoint_policy.EndpointPolicy = None,
        endpoint_policy_id: str = None,
        retry: OptionalRetry = gapic_v1.method.DEFAULT,
        timeout: float = None,
        metadata: Sequence[Tuple[str, str]] = (),
    ) -> operation_async.AsyncOperation:
        r"""Creates a new EndpointPolicy in a given project and
        location.


        .. code-block:: python

            from google.cloud import network_services_v1

            def sample_create_endpoint_policy():
                # Create a client
                client = network_services_v1.NetworkServicesClient()

                # Initialize request argument(s)
                endpoint_policy = network_services_v1.EndpointPolicy()
                endpoint_policy.name = "name_value"
                endpoint_policy.type_ = "GRPC_SERVER"

                request = network_services_v1.CreateEndpointPolicyRequest(
                    parent="parent_value",
                    endpoint_policy_id="endpoint_policy_id_value",
                    endpoint_policy=endpoint_policy,
                )

                # Make the request
                operation = client.create_endpoint_policy(request=request)

                print("Waiting for operation to complete...")

                response = operation.result()

                # Handle the response
                print(response)

        Args:
            request (Union[google.cloud.network_services_v1.types.CreateEndpointPolicyRequest, dict]):
                The request object. Request used with the
                CreateEndpointPolicy method.
            parent (:class:`str`):
                Required. The parent resource of the EndpointPolicy.
                Must be in the format ``projects/*/locations/global``.

                This corresponds to the ``parent`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            endpoint_policy (:class:`google.cloud.network_services_v1.types.EndpointPolicy`):
                Required. EndpointPolicy resource to
                be created.

                This corresponds to the ``endpoint_policy`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            endpoint_policy_id (:class:`str`):
                Required. Short name of the
                EndpointPolicy resource to be created.
                E.g. "CustomECS".

                This corresponds to the ``endpoint_policy_id`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry.Retry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`google.cloud.network_services_v1.types.EndpointPolicy` EndpointPolicy is a resource that helps apply desired configuration
                   on the endpoints that match specific criteria. For
                   example, this resource can be used to apply
                   "authentication config" an all endpoints that serve
                   on port 8080.

        """
        # Create or coerce a protobuf request object.
        # Quick check: If we got a request object, we should *not* have
        # gotten any keyword arguments that map to the request.
        has_flattened_params = any([parent, endpoint_policy, endpoint_policy_id])
        if request is not None and has_flattened_params:
            raise ValueError(
                "If the `request` argument is set, then none of "
                "the individual field arguments should be set."
            )

        request = gcn_endpoint_policy.CreateEndpointPolicyRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if parent is not None:
            request.parent = parent
        if endpoint_policy is not None:
            request.endpoint_policy = endpoint_policy
        if endpoint_policy_id is not None:
            request.endpoint_policy_id = endpoint_policy_id

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = gapic_v1.method_async.wrap_method(
            self._client._transport.create_endpoint_policy,
            default_timeout=None,
            client_info=DEFAULT_CLIENT_INFO,
        )

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", request.parent),)),
        )

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            gcn_endpoint_policy.EndpointPolicy,
            metadata_type=common.OperationMetadata,
        )

        # Done; return the response.
        return response

    async def update_endpoint_policy(
        self,
        request: Union[gcn_endpoint_policy.UpdateEndpointPolicyRequest, dict] = None,
        *,
        endpoint_policy: gcn_endpoint_policy.EndpointPolicy = None,
        update_mask: field_mask_pb2.FieldMask = None,
        retry: OptionalRetry = gapic_v1.method.DEFAULT,
        timeout: float = None,
        metadata: Sequence[Tuple[str, str]] = (),
    ) -> operation_async.AsyncOperation:
        r"""Updates the parameters of a single EndpointPolicy.

        .. code-block:: python

            from google.cloud import network_services_v1

            def sample_update_endpoint_policy():
                # Create a client
                client = network_services_v1.NetworkServicesClient()

                # Initialize request argument(s)
                endpoint_policy = network_services_v1.EndpointPolicy()
                endpoint_policy.name = "name_value"
                endpoint_policy.type_ = "GRPC_SERVER"

                request = network_services_v1.UpdateEndpointPolicyRequest(
                    endpoint_policy=endpoint_policy,
                )

                # Make the request
                operation = client.update_endpoint_policy(request=request)

                print("Waiting for operation to complete...")

                response = operation.result()

                # Handle the response
                print(response)

        Args:
            request (Union[google.cloud.network_services_v1.types.UpdateEndpointPolicyRequest, dict]):
                The request object. Request used with the
                UpdateEndpointPolicy method.
            endpoint_policy (:class:`google.cloud.network_services_v1.types.EndpointPolicy`):
                Required. Updated EndpointPolicy
                resource.

                This corresponds to the ``endpoint_policy`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            update_mask (:class:`google.protobuf.field_mask_pb2.FieldMask`):
                Optional. Field mask is used to specify the fields to be
                overwritten in the EndpointPolicy resource by the
                update. The fields specified in the update_mask are
                relative to the resource, not the full request. A field
                will be overwritten if it is in the mask. If the user
                does not provide a mask then all fields will be
                overwritten.

                This corresponds to the ``update_mask`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry.Retry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`google.cloud.network_services_v1.types.EndpointPolicy` EndpointPolicy is a resource that helps apply desired configuration
                   on the endpoints that match specific criteria. For
                   example, this resource can be used to apply
                   "authentication config" an all endpoints that serve
                   on port 8080.

        """
        # Create or coerce a protobuf request object.
        # Quick check: If we got a request object, we should *not* have
        # gotten any keyword arguments that map to the request.
        has_flattened_params = any([endpoint_policy, update_mask])
        if request is not None and has_flattened_params:
            raise ValueError(
                "If the `request` argument is set, then none of "
                "the individual field arguments should be set."
            )

        request = gcn_endpoint_policy.UpdateEndpointPolicyRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if endpoint_policy is not None:
            request.endpoint_policy = endpoint_policy
        if update_mask is not None:
            request.update_mask = update_mask

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = gapic_v1.method_async.wrap_method(
            self._client._transport.update_endpoint_policy,
            default_timeout=None,
            client_info=DEFAULT_CLIENT_INFO,
        )

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata(
                (("endpoint_policy.name", request.endpoint_policy.name),)
            ),
        )

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            gcn_endpoint_policy.EndpointPolicy,
            metadata_type=common.OperationMetadata,
        )

        # Done; return the response.
        return response

    async def delete_endpoint_policy(
        self,
        request: Union[endpoint_policy.DeleteEndpointPolicyRequest, dict] = None,
        *,
        name: str = None,
        retry: OptionalRetry = gapic_v1.method.DEFAULT,
        timeout: float = None,
        metadata: Sequence[Tuple[str, str]] = (),
    ) -> operation_async.AsyncOperation:
        r"""Deletes a single EndpointPolicy.

        .. code-block:: python

            from google.cloud import network_services_v1

            def sample_delete_endpoint_policy():
                # Create a client
                client = network_services_v1.NetworkServicesClient()

                # Initialize request argument(s)
                request = network_services_v1.DeleteEndpointPolicyRequest(
                    name="name_value",
                )

                # Make the request
                operation = client.delete_endpoint_policy(request=request)

                print("Waiting for operation to complete...")

                response = operation.result()

                # Handle the response
                print(response)

        Args:
            request (Union[google.cloud.network_services_v1.types.DeleteEndpointPolicyRequest, dict]):
                The request object. Request used with the
                DeleteEndpointPolicy method.
            name (:class:`str`):
                Required. A name of the EndpointPolicy to delete. Must
                be in the format
                ``projects/*/locations/global/endpointPolicies/*``.

                This corresponds to the ``name`` field
                on the ``request`` instance; if ``request`` is provided, this
                should not be set.
            retry (google.api_core.retry.Retry): Designation of what errors, if any,
                should be retried.
            timeout (float): The timeout for this request.
            metadata (Sequence[Tuple[str, str]]): Strings which should be
                sent along with the request as metadata.

        Returns:
            google.api_core.operation_async.AsyncOperation:
                An object representing a long-running operation.

                The result type for the operation will be :class:`google.protobuf.empty_pb2.Empty` A generic empty message that you can re-use to avoid defining duplicated
                   empty messages in your APIs. A typical example is to
                   use it as the request or the response type of an API
                   method. For instance:

                      service Foo {
                         rpc Bar(google.protobuf.Empty) returns
                         (google.protobuf.Empty);

                      }

                   The JSON representation for Empty is empty JSON
                   object {}.

        """
        # Create or coerce a protobuf request object.
        # Quick check: If we got a request object, we should *not* have
        # gotten any keyword arguments that map to the request.
        has_flattened_params = any([name])
        if request is not None and has_flattened_params:
            raise ValueError(
                "If the `request` argument is set, then none of "
                "the individual field arguments should be set."
            )

        request = endpoint_policy.DeleteEndpointPolicyRequest(request)

        # If we have keyword arguments corresponding to fields on the
        # request, apply these.
        if name is not None:
            request.name = name

        # Wrap the RPC method; this adds retry and timeout information,
        # and friendly error handling.
        rpc = gapic_v1.method_async.wrap_method(
            self._client._transport.delete_endpoint_policy,
            default_timeout=None,
            client_info=DEFAULT_CLIENT_INFO,
        )

        # Certain fields should be provided within the metadata header;
        # add these here.
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("name", request.name),)),
        )

        # Send the request.
        response = await rpc(
            request,
            retry=retry,
            timeout=timeout,
            metadata=metadata,
        )

        # Wrap the response in an operation future.
        response = operation_async.from_gapic(
            response,
            self._client._transport.operations_client,
            empty_pb2.Empty,
            metadata_type=common.OperationMetadata,
        )

        # Done; return the response.
        return response

    async def __aenter__(self):
        return self

    async def __aexit__(self, exc_type, exc, tb):
        await self.transport.close()


try:
    DEFAULT_CLIENT_INFO = gapic_v1.client_info.ClientInfo(
        gapic_version=pkg_resources.get_distribution(
            "google-cloud-network-services",
        ).version,
    )
except pkg_resources.DistributionNotFound:
    DEFAULT_CLIENT_INFO = gapic_v1.client_info.ClientInfo()


__all__ = ("NetworkServicesAsyncClient",)
