import * as cdk from '@aws-cdk/core';
/**
 * This resource allows to create, read, update and delete a network peering.
 *
 * @schema CfnNetworkpeeringProps
 */
export interface CfnNetworkpeeringProps {
    /**
     * The unique identifier of the project.
     *
     * @schema CfnNetworkpeeringProps#ProjectId
     */
    readonly projectId: string;
    /**
     * Unique identifier of the Atlas VPC container for the AWS region.
     *
     * @schema CfnNetworkpeeringProps#ContainerId
     */
    readonly containerId?: string;
    /**
     * AWS region where the peer VPC resides.
     *
     * Returns null if the region is the same region in which the Atlas VPC resides.
     *
     * @schema CfnNetworkpeeringProps#AccepterRegionName
     */
    readonly accepterRegionName?: string;
    /**
     * AWS account ID of the owner of the peer VPC.
     *
     * @schema CfnNetworkpeeringProps#AwsAccountId
     */
    readonly awsAccountId?: string;
    /**
     * The name of the provider.
     *
     * @schema CfnNetworkpeeringProps#ProviderName
     */
    readonly providerName?: string;
    /**
     * Peer VPC CIDR block or subnet.
     *
     * @schema CfnNetworkpeeringProps#RouteTableCIDRBlock
     */
    readonly routeTableCidrBlock?: string;
    /**
     * Unique identifier of the peer VPC.
     *
     * @schema CfnNetworkpeeringProps#VpcId
     */
    readonly vpcId: string;
    /**
     * Unique identifier for the peering connection.
     *
     * @schema CfnNetworkpeeringProps#ConnectionId
     */
    readonly connectionId?: string;
    /**
     * @schema CfnNetworkpeeringProps#ApiKeys
     */
    readonly apiKeys: ApiKeyDefinition;
}
/**
 * Converts an object of type 'CfnNetworkpeeringProps' to JSON representation.
 */
export declare function toJson_CfnNetworkpeeringProps(obj: CfnNetworkpeeringProps | undefined): Record<string, any> | undefined;
/**
 * @schema apiKeyDefinition
 */
export interface ApiKeyDefinition {
    /**
     * @schema apiKeyDefinition#PublicKey
     */
    readonly publicKey?: string;
    /**
     * @schema apiKeyDefinition#PrivateKey
     */
    readonly privateKey?: string;
}
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
export declare function toJson_ApiKeyDefinition(obj: ApiKeyDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `MongoDB::Atlas::NetworkPeering`.
 *
 * @external
 * @cloudformationResource MongoDB::Atlas::NetworkPeering
 * @link http://unknown-url
 */
export declare class CfnNetworkpeering extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::NetworkPeering";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnNetworkpeeringProps;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.Id`.
     *
     * @external
     * @link http://unknown-url
     */
    readonly attrId: string;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.StatusName`.
     *
     * @external
     * @link http://unknown-url
     */
    readonly attrStatusName: string;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.ErrorStateName`.
     *
     * @external
     * @link http://unknown-url
     */
    readonly attrErrorStateName: string;
    /**
     * Create a new `MongoDB::Atlas::NetworkPeering`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkpeeringProps);
}
