# coding: utf-8

"""
    IGVF Project API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 81.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from igvf_async_client.models.attachment import Attachment
from igvf_async_client.models.rna_seq_kb_info import RNASeqKBInfo
from typing import Optional, Set
from typing_extensions import Self

class SingleCellRnaSeqQualityMetric(BaseModel):
    """
    Schema for submission of a scRNA-seq uniform pipeline quality metric.
    """ # noqa: E501
    preview_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was previewed.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the metadata object.")
    release_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was released.")
    attachment: Optional[Attachment] = None
    lab: Optional[StrictStr] = Field(default=None, description="Lab associated with the submission.")
    award: Optional[StrictStr] = Field(default=None, description="Grant associated with the submission.")
    schema_version: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The version of the JSON schema that the server uses to validate the object.")
    uuid: Optional[StrictStr] = Field(default=None, description="The unique identifier associated with every object.")
    notes: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DACC internal notes.")
    aliases: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Lab specific identifiers to reference an object.")
    creation_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was created.")
    submitted_by: Optional[StrictStr] = Field(default=None, description="The user who submitted the object.")
    submitter_comment: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Additional information specified by the submitter to be displayed as a comment on the portal.")
    description: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A plain text description of the object.")
    quality_metric_of: Optional[List[StrictStr]] = Field(default=None, description="The file(s) to which this quality metric applies.")
    analysis_step_version: Optional[StrictStr] = Field(default=None, description="The analysis step version of the quality metric.")
    n_records: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of records in BUS file.")
    n_reads: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of input reads.")
    n_barcodes: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of valid cell barcodes detected.")
    total_umis: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of UMIs detected.")
    n_barcode_umis: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of UMIs associated with cell barcodes.")
    median_reads_per_barcode: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Median number of reads per cell barcode.")
    mean_reads_per_barcode: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Mean number of reads per cell barcode.")
    median_umis_per_barcode: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Median number of UMIs per cell barcode.")
    mean_umis_per_barcode: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Mean number of UMIs per cell barcode.")
    gt_records: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of BUS records for Good-Toulmin estimation.")
    num_barcodes_on_onlist: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of cell barcodes matching an expected list of barcodes (onlist).")
    percentage_barcodes_on_onlist: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of cell barcodes matching an expected list of barcodes (onlist).")
    num_reads_on_onlist: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of reads associated with barcodes on the onlist.")
    percentage_reads_on_onlist: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of reads associated with barcodes on the onlist.")
    rnaseq_kb_info: Optional[RNASeqKBInfo] = None
    n_targets: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of target sequences (e.g., transcripts) in the index.")
    n_bootstraps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of bootstrap iterations used to estimate expression uncertainty.")
    n_processed: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of valid reads processed by Kallisto.")
    n_pseudoaligned: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of reads that could be pseudoaligned to the transcriptome index.")
    n_unique: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of reads that could be pseudoaligned to a unique target sequence.")
    p_pseudoaligned: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of reads that could be pseudoaligned to the transcriptome index.")
    p_unique: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of reads that could be pseudoaligned to a unique target sequence.")
    index_version: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Version of Kallisto index command used for building the transcriptome index.")
    kmer_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Length of k-mers used for building the transcriptome index.")
    id: Optional[StrictStr] = Field(default=None, alias="@id")
    type: Optional[List[StrictStr]] = Field(default=None, alias="@type")
    summary: Optional[StrictStr] = Field(default=None, description="A summary of the quality metric.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["preview_timestamp", "status", "release_timestamp", "attachment", "lab", "award", "schema_version", "uuid", "notes", "aliases", "creation_timestamp", "submitted_by", "submitter_comment", "description", "quality_metric_of", "analysis_step_version", "n_records", "n_reads", "n_barcodes", "total_umis", "n_barcode_umis", "median_reads_per_barcode", "mean_reads_per_barcode", "median_umis_per_barcode", "mean_umis_per_barcode", "gt_records", "num_barcodes_on_onlist", "percentage_barcodes_on_onlist", "num_reads_on_onlist", "percentage_reads_on_onlist", "rnaseq_kb_info", "n_targets", "n_bootstraps", "n_processed", "n_pseudoaligned", "n_unique", "p_pseudoaligned", "p_unique", "index_version", "kmer_length", "@id", "@type", "summary"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['archived', 'deleted', 'in progress', 'preview', 'released']):
            raise ValueError("must be one of enum values ('archived', 'deleted', 'in progress', 'preview', 'released')")
        return value

    @field_validator('schema_version')
    def schema_version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d+(\.\d+)*$", value):
            raise ValueError(r"must validate the regular expression /^\d+(\.\d+)*$/")
        return value

    @field_validator('notes')
    def notes_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('submitter_comment')
    def submitter_comment_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SingleCellRnaSeqQualityMetric from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rnaseq_kb_info
        if self.rnaseq_kb_info:
            _dict['rnaseq_kb_info'] = self.rnaseq_kb_info.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SingleCellRnaSeqQualityMetric from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "preview_timestamp": obj.get("preview_timestamp"),
            "status": obj.get("status"),
            "release_timestamp": obj.get("release_timestamp"),
            "attachment": Attachment.from_dict(obj["attachment"]) if obj.get("attachment") is not None else None,
            "lab": obj.get("lab"),
            "award": obj.get("award"),
            "schema_version": obj.get("schema_version"),
            "uuid": obj.get("uuid"),
            "notes": obj.get("notes"),
            "aliases": obj.get("aliases"),
            "creation_timestamp": obj.get("creation_timestamp"),
            "submitted_by": obj.get("submitted_by"),
            "submitter_comment": obj.get("submitter_comment"),
            "description": obj.get("description"),
            "quality_metric_of": obj.get("quality_metric_of"),
            "analysis_step_version": obj.get("analysis_step_version"),
            "n_records": obj.get("n_records"),
            "n_reads": obj.get("n_reads"),
            "n_barcodes": obj.get("n_barcodes"),
            "total_umis": obj.get("total_umis"),
            "n_barcode_umis": obj.get("n_barcode_umis"),
            "median_reads_per_barcode": obj.get("median_reads_per_barcode"),
            "mean_reads_per_barcode": obj.get("mean_reads_per_barcode"),
            "median_umis_per_barcode": obj.get("median_umis_per_barcode"),
            "mean_umis_per_barcode": obj.get("mean_umis_per_barcode"),
            "gt_records": obj.get("gt_records"),
            "num_barcodes_on_onlist": obj.get("num_barcodes_on_onlist"),
            "percentage_barcodes_on_onlist": obj.get("percentage_barcodes_on_onlist"),
            "num_reads_on_onlist": obj.get("num_reads_on_onlist"),
            "percentage_reads_on_onlist": obj.get("percentage_reads_on_onlist"),
            "rnaseq_kb_info": RNASeqKBInfo.from_dict(obj["rnaseq_kb_info"]) if obj.get("rnaseq_kb_info") is not None else None,
            "n_targets": obj.get("n_targets"),
            "n_bootstraps": obj.get("n_bootstraps"),
            "n_processed": obj.get("n_processed"),
            "n_pseudoaligned": obj.get("n_pseudoaligned"),
            "n_unique": obj.get("n_unique"),
            "p_pseudoaligned": obj.get("p_pseudoaligned"),
            "p_unique": obj.get("p_unique"),
            "index_version": obj.get("index_version"),
            "kmer_length": obj.get("kmer_length"),
            "@id": obj.get("@id"),
            "@type": obj.get("@type"),
            "summary": obj.get("summary")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


