import random

CLASSIC_LEVELS = {
    # fmt: off
    # row description: (points, x2, x3, x0)
    "1": [
        (24, 3, 1, 6),
        (27, 0, 3, 6),
        (32, 5, 0, 6),
        (36, 2, 2, 6),
        (48, 4, 1, 6)
    ],
    "2": [
        (54, 1, 3, 7),
        (64, 6, 0, 7),
        (72, 3, 2, 7),
        (81, 0, 4, 7),
        (96, 5, 1, 7)],
    "3": [
        (108, 2, 3, 8),
        (128, 7, 0, 8),
        (144, 4, 2, 8),
        (162, 1, 4, 8),
        (192, 6, 1, 8),
    ],
    "4": [
        (216, 3, 3, 8),
        (243, 0, 5, 8),
        (256, 8, 0, 10),
        (288, 5, 2, 10),
        (324, 2, 4, 10),
    ],
    "5": [
        (384, 7, 1, 10),
        (432, 4, 3, 10),
        (486, 1, 5, 10),
        (512, 9, 0, 10),
        (576, 6, 2, 10),
    ],
    "6": [
        (648, 3, 4, 10),
        (729, 0, 6, 10),
        (768, 8, 1, 10),
        (864, 5, 3, 10),
        (972, 2, 5, 10),
    ],
    "7": [
        (1152, 7, 2, 10),
        (1296, 4, 4, 10),
        (1458, 1, 6, 13),
        (1536, 9, 1, 13),
        (1728, 6, 3, 10),
    ],
    "8": [
        (2187, 0, 7, 10),
        (2304, 8, 2, 10),
        (2592, 5, 4, 10),
        (2916, 2, 6, 10),
        (3456, 7, 3, 10),
    ],
    # fmt: on
}


def _chunk(original, size):
    for i in range(0, len(original), size):
        yield original[i : i + size]


def generate_board(level):
    _, x_2, x_3, x_0 = random.choice(CLASSIC_LEVELS[str(level)])  # nosec
    x_1 = 25 - x_3 - x_0 - x_2
    cells = [0] * x_0 + [1] * x_1 + [2] * x_2 + [3] * x_3
    random.shuffle(cells)
    board_width = 5
    return [cells[i : i + board_width] for i in range(0, len(cells), board_width)]
