"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicKey = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Public Key Configuration
 *
 * @resource AWS::CloudFront::PublicKey
 */
class PublicKey extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_PublicKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!core_1.Token.isUnresolved(props.encodedKey) && !/^-----BEGIN PUBLIC KEY-----/.test(props.encodedKey)) {
            throw new Error(`Public key must be in PEM format (with the BEGIN/END PUBLIC KEY lines); got ${props.encodedKey}`);
        }
        const resource = new cloudfront_generated_1.CfnPublicKey(this, 'Resource', {
            publicKeyConfig: {
                name: (_b = props.publicKeyName) !== null && _b !== void 0 ? _b : this.generateName(),
                callerReference: this.node.addr,
                encodedKey: props.encodedKey,
                comment: props.comment,
            },
        });
        this.publicKeyId = resource.ref;
    }
    /** Imports a Public Key from its id. */
    static fromPublicKeyId(scope, id, publicKeyId) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.publicKeyId = publicKeyId;
            }
        }(scope, id);
    }
    generateName() {
        const name = core_1.Names.uniqueId(this);
        if (name.length > 80) {
            return name.substring(0, 40) + name.substring(name.length - 40);
        }
        return name;
    }
}
exports.PublicKey = PublicKey;
_a = JSII_RTTI_SYMBOL_1;
PublicKey[_a] = { fqn: "@aws-cdk/aws-cloudfront.PublicKey", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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