/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Structure;
import ucar.nc2.constants.CDM;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamReader {
    private static final boolean debug = false;

    public NetcdfFile readStream(InputStream is, NetcdfFile ncfile) throws IOException {
        byte[] b = new byte[4];
        NcStream.readFully(is, b);
        if (this.test(b, NcStream.MAGIC_START) ? !this.readAndTest(is, NcStream.MAGIC_HEADER) : !this.test(b, NcStream.MAGIC_HEADER)) {
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        int msize = NcStream.readVInt(is);
        byte[] m3 = new byte[msize];
        NcStream.readFully(is, m3);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m3);
        ncfile = this.proto2nc(proto, ncfile);
        while (is.available() > 0) {
            this.readData(is, ncfile);
        }
        return ncfile;
    }

    public DataResult readData(InputStream is, NetcdfFile ncfile) throws IOException {
        Section section;
        if (!this.readAndTest(is, NcStream.MAGIC_DATA)) {
            throw new IOException("Data transfer corrupted on " + ncfile.getLocation());
        }
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
        DataType dataType = NcStream.decodeDataType(dproto.getDataType());
        Section section2 = section = dataType == DataType.SEQUENCE ? new Section() : NcStream.decodeSection(dproto.getSection());
        if (dataType == DataType.STRING) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(new String(sb, CDM.utf8Charset));
            }
            return new DataResult(dproto.getVarName(), data);
        }
        if (dataType == DataType.OPAQUE) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(ByteBuffer.wrap(sb));
            }
            return new DataResult(dproto.getVarName(), data);
        }
        int dsize = NcStream.readVInt(is);
        byte[] datab = new byte[dsize];
        NcStream.readFully(is, datab);
        if (dataType == DataType.STRUCTURE) {
            Structure s2 = (Structure)ncfile.findVariable(dproto.getVarName());
            StructureMembers members = s2.makeStructureMembers();
            if (dproto.getVersion() == 0) {
                ArrayStructureBB.setOffsets(members);
                ArrayStructureBB data = new ArrayStructureBB(members, section.getShape(), ByteBuffer.wrap(datab), 0);
                return new DataResult(dproto.getVarName(), data);
            }
            ArrayStructureBB data = NcStream.decodeArrayStructure(members, section.getShape(), datab);
            return new DataResult(dproto.getVarName(), data);
        }
        Array data = Array.factory(dataType, section.getShape(), ByteBuffer.wrap(datab));
        return new DataResult(dproto.getVarName(), data);
    }

    public StructureDataIterator getStructureIterator(InputStream is, NetcdfFile ncfile) throws IOException {
        if (!this.readAndTest(is, NcStream.MAGIC_DATA)) {
            throw new IOException("Data transfer corrupted on " + ncfile.getLocation());
        }
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
        Structure s2 = (Structure)ncfile.findVariable(dproto.getVarName());
        StructureMembers members = s2.makeStructureMembers();
        ArrayStructureBB.setOffsets(members);
        return new StreamDataIterator(is, members, dproto.getBigend() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    private boolean readAndTest(InputStream is, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        NcStream.readFully(is, b);
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    private boolean test(byte[] b, byte[] test) throws IOException {
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public NetcdfFile proto2nc(NcStreamProto.Header proto, NetcdfFile ncfile) throws InvalidProtocolBufferException {
        if (ncfile == null) {
            ncfile = new NetcdfFileSubclass();
        }
        ncfile.setLocation(proto.getLocation());
        if (proto.hasId()) {
            ncfile.setId(proto.getId());
        }
        if (proto.hasTitle()) {
            ncfile.setTitle(proto.getTitle());
        }
        NcStreamProto.Group root = proto.getRoot();
        NcStream.readGroup(root, ncfile, ncfile.getRootGroup());
        ncfile.finish();
        return ncfile;
    }

    private class StreamDataIterator
    implements StructureDataIterator {
        private InputStream is;
        private StructureMembers members;
        private StructureData curr = null;
        private ByteOrder bo;
        private int count = 0;

        StreamDataIterator(InputStream is, StructureMembers members, ByteOrder bo) {
            this.is = is;
            this.members = members;
            this.bo = bo;
        }

        @Override
        public boolean hasNext() throws IOException {
            this.readNext();
            return this.curr != null;
        }

        @Override
        public StructureData next() throws IOException {
            ++this.count;
            return this.curr;
        }

        private void readNext() throws IOException {
            byte[] b = new byte[4];
            NcStream.readFully(this.is, b);
            if (NcStreamReader.this.test(b, NcStream.MAGIC_VDATA)) {
                int dsize = NcStream.readVInt(this.is);
                byte[] datab = new byte[dsize];
                NcStream.readFully(this.is, datab);
                this.curr = NcStream.decodeStructureData(this.members, this.bo, datab);
            } else if (NcStreamReader.this.test(b, NcStream.MAGIC_VEND)) {
                this.curr = null;
            } else {
                throw new IllegalStateException("bad stream");
            }
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public StructureDataIterator reset() {
            return this.count == 0 && this.is != null ? this : null;
        }

        @Override
        public int getCurrentRecno() {
            return this.count;
        }

        @Override
        public void finish() {
            if (this.is != null) {
                try {
                    this.is.close();
                    this.is = null;
                }
                catch (IOException ioe) {
                    System.out.printf("NcStreamReader: Error closing input stream.", new Object[0]);
                }
            }
        }
    }

    static class DataResult {
        String varNameFullEsc;
        Array data;

        DataResult(String varName, Array data) {
            this.varNameFullEsc = varName;
            this.data = data;
        }
    }
}

