/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StageLabel
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(StageLabel.class);
    private String name;
    private Length y;
    private Length x;
    private Length z;

    public StageLabel() {
    }

    public StageLabel(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public StageLabel(StageLabel orig) {
        this.name = orig.name;
        this.y = orig.y;
        this.x = orig.x;
        this.z = orig.z;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        Double baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("Y")) {
            unitSymbol = element.getAttribute("YUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = StageLabel.getYUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("Y"));
            if (baseValue != null) {
                this.setY(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("X")) {
            unitSymbol = element.getAttribute("XUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = StageLabel.getXUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("X"));
            if (baseValue != null) {
                this.setX(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Z")) {
            unitSymbol = element.getAttribute("ZUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = StageLabel.getZUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("Z"));
            if (baseValue != null) {
                this.setZ(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getZUnitXsdDefault() {
        return "reference frame";
    }

    public static String getYUnitXsdDefault() {
        return "reference frame";
    }

    public static String getXUnitXsdDefault() {
        return "reference frame";
    }

    public Length getY() {
        return this.y;
    }

    public void setY(Length y) {
        this.y = y;
    }

    public Length getX() {
        return this.x;
    }

    public void setX(Length x) {
        this.x = x;
    }

    public Length getZ() {
        return this.z;
    }

    public void setZ(Length z) {
        this.z = z;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element StageLabel_element) {
        UnitsLength enumUnits;
        if (StageLabel_element == null) {
            StageLabel_element = document.createElementNS(NAMESPACE, "StageLabel");
        }
        super.asXMLElement(document, StageLabel_element);
        if (this.name != null) {
            StageLabel_element.setAttribute("Name", this.name.toString());
        }
        if (this.y != null) {
            if (this.y.value() != null) {
                StageLabel_element.setAttribute("Y", this.y.value().toString());
            }
            if (this.y.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.y.unit().getSymbol());
                    StageLabel_element.setAttribute("YUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for StageLabel:YUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.x != null) {
            if (this.x.value() != null) {
                StageLabel_element.setAttribute("X", this.x.value().toString());
            }
            if (this.x.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.x.unit().getSymbol());
                    StageLabel_element.setAttribute("XUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for StageLabel:XUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.z != null) {
            if (this.z.value() != null) {
                StageLabel_element.setAttribute("Z", this.z.value().toString());
            }
            if (this.z.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.z.unit().getSymbol());
                    StageLabel_element.setAttribute("ZUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for StageLabel:ZUnit: {}", (Object)e.toString());
                }
            }
        }
        return StageLabel_element;
    }
}

