/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class INRReader
extends FormatReader {
    private static final String INR_MAGIC = "#INRIMAGE";
    private static final int HEADER_SIZE = 256;

    public INRReader() {
        super("INR", "inr");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = INR_MAGIC.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).indexOf(INR_MAGIC) == 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        long planeSize = FormatTools.getPlaneSize(this);
        this.in.seek(256L + (long)no * planeSize);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading header");
        String header = this.in.readString(256);
        String[] lines = header.split("\n");
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        Double physicalSizeZ = null;
        boolean isSigned = false;
        int nBits = 0;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        for (String line : lines) {
            int index = line.indexOf(61);
            if (index < 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            this.addGlobalMeta(key, value);
            if (key.equals("XDIM")) {
                m3.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YDIM")) {
                m3.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ZDIM")) {
                m3.sizeZ = Integer.parseInt(value);
                continue;
            }
            if (key.equals("VDIM")) {
                m3.sizeT = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TYPE")) {
                isSigned = value.toLowerCase().startsWith("signed");
                continue;
            }
            if (key.equals("PIXSIZE")) {
                String bits = value.substring(0, value.indexOf(32));
                nBits = Integer.parseInt(bits);
                continue;
            }
            if (key.equals("VX")) {
                physicalSizeX = new Double(value);
                continue;
            }
            if (key.equals("VY")) {
                physicalSizeY = new Double(value);
                continue;
            }
            if (!key.equals("VZ")) continue;
            physicalSizeZ = new Double(value);
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeZ() == 0) {
            m3.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m3.sizeT = 1;
        }
        m3.sizeC = 1;
        m3.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m3.pixelType = FormatTools.pixelTypeFromBytes(nBits / 8, isSigned, false);
        m3.dimensionOrder = "XYZTC";
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(physicalSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(physicalSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(physicalSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }
}

