# Copyright 2008 Canonical Ltd.  All rights reserved.

"""Test harness for LAZR doctests."""

from __future__ import absolute_import, print_function

__metaclass__ = type
__all__ = []

import os
import doctest
from pkg_resources import resource_filename

from van.testing.layer import zcml_layer, wsgi_intercept_layer

from lazr.restful.example.base.root import CookbookServiceRootResource
from lazr.restful.testing.webservice import (
    WebServiceTestPublication, WebServiceApplication)


class CookbookWebServiceTestPublication(WebServiceTestPublication):
    def getApplication(self, request):
        return CookbookServiceRootResource()


DOCTEST_FLAGS = (
    doctest.ELLIPSIS |
    doctest.NORMALIZE_WHITESPACE |
    doctest.REPORT_NDIFF)

class FunctionalLayer:
    allow_teardown = False
    zcml = os.path.abspath(resource_filename('lazr.restful', 'ftesting.zcml'))
zcml_layer(FunctionalLayer)


class WSGILayer(FunctionalLayer):
    @classmethod
    def make_application(self):
        return WebServiceApplication({}, CookbookWebServiceTestPublication)
wsgi_intercept_layer(WSGILayer)


def load_tests(loader, tests, pattern):
    """See `zope.testing.testrunner`."""
    doctest_files = sorted(
        [name
         for name in os.listdir(os.path.dirname(__file__))
         if name.endswith('.txt')])
    globs = {
        'absolute_import': absolute_import,
        'print_function': print_function,
        }
    suite = doctest.DocFileSuite(
        *doctest_files, optionflags=DOCTEST_FLAGS, globs=globs)
    suite.layer = WSGILayer
    tests.addTest(suite)
    return tests
