# coding: utf-8

"""
    Engines API

    Allow clients to fetch Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: v2:[pa,spar,vault,pub],v1:[fiab,fi,axp,afi,npo,bpm,fpo]
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class SPARIdentifier(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'returntype': 'str',
        'prefix': 'str'
    }

    attribute_map = {
        'id': 'id',
        'returntype': 'returntype',
        'prefix': 'prefix'
    }

    def __init__(self, id=None, returntype=None, prefix=None, local_vars_configuration=None):  # noqa: E501
        """SPARIdentifier - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._returntype = None
        self._prefix = None
        self.discriminator = None

        self.id = id
        if returntype is not None:
            self.returntype = returntype
        if prefix is not None:
            self.prefix = prefix

    @property
    def id(self):
        """Gets the id of this SPARIdentifier.  # noqa: E501

        User's FactSet account OR benchmark id.  # noqa: E501

        :return: The id of this SPARIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SPARIdentifier.

        User's FactSet account OR benchmark id.  # noqa: E501

        :param id: The id of this SPARIdentifier.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def returntype(self):
        """Gets the returntype of this SPARIdentifier.  # noqa: E501

        Benchmark return type.  # noqa: E501

        :return: The returntype of this SPARIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._returntype

    @returntype.setter
    def returntype(self, returntype):
        """Sets the returntype of this SPARIdentifier.

        Benchmark return type.  # noqa: E501

        :param returntype: The returntype of this SPARIdentifier.  # noqa: E501
        :type: str
        """

        self._returntype = returntype

    @property
    def prefix(self):
        """Gets the prefix of this SPARIdentifier.  # noqa: E501

        Benchmark prefix.  # noqa: E501

        :return: The prefix of this SPARIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this SPARIdentifier.

        Benchmark prefix.  # noqa: E501

        :param prefix: The prefix of this SPARIdentifier.  # noqa: E501
        :type: str
        """

        self._prefix = prefix

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SPARIdentifier):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SPARIdentifier):
            return True

        return self.to_dict() != other.to_dict()
