# coding: utf-8

"""
    Engines API

    Allow clients to fetch Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: v2:[pa,spar,vault,pub],v1:[fiab,fi,axp,afi,npo,bpm,fpo]
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class PACalculationParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'componentid': 'str',
        'accounts': 'list[PAIdentifier]',
        'benchmarks': 'list[PAIdentifier]',
        'dates': 'PADateParameters',
        'groups': 'list[PACalculationGroup]',
        'currencyisocode': 'str',
        'columns': 'list[PACalculationColumn]',
        'componentdetail': 'str'
    }

    attribute_map = {
        'componentid': 'componentid',
        'accounts': 'accounts',
        'benchmarks': 'benchmarks',
        'dates': 'dates',
        'groups': 'groups',
        'currencyisocode': 'currencyisocode',
        'columns': 'columns',
        'componentdetail': 'componentdetail'
    }

    def __init__(self, componentid=None, accounts=None, benchmarks=None, dates=None, groups=None, currencyisocode=None, columns=None, componentdetail=None, local_vars_configuration=None):  # noqa: E501
        """PACalculationParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._componentid = None
        self._accounts = None
        self._benchmarks = None
        self._dates = None
        self._groups = None
        self._currencyisocode = None
        self._columns = None
        self._componentdetail = None
        self.discriminator = None

        self.componentid = componentid
        if accounts is not None:
            self.accounts = accounts
        if benchmarks is not None:
            self.benchmarks = benchmarks
        if dates is not None:
            self.dates = dates
        if groups is not None:
            self.groups = groups
        if currencyisocode is not None:
            self.currencyisocode = currencyisocode
        if columns is not None:
            self.columns = columns
        if componentdetail is not None:
            self.componentdetail = componentdetail

    @property
    def componentid(self):
        """Gets the componentid of this PACalculationParameters.  # noqa: E501

        The PA Engine component identifier to analyze.  # noqa: E501

        :return: The componentid of this PACalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._componentid

    @componentid.setter
    def componentid(self, componentid):
        """Sets the componentid of this PACalculationParameters.

        The PA Engine component identifier to analyze.  # noqa: E501

        :param componentid: The componentid of this PACalculationParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and componentid is None:  # noqa: E501
            raise ValueError("Invalid value for `componentid`, must not be `None`")  # noqa: E501

        self._componentid = componentid

    @property
    def accounts(self):
        """Gets the accounts of this PACalculationParameters.  # noqa: E501

        List of accounts.  # noqa: E501

        :return: The accounts of this PACalculationParameters.  # noqa: E501
        :rtype: list[PAIdentifier]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """Sets the accounts of this PACalculationParameters.

        List of accounts.  # noqa: E501

        :param accounts: The accounts of this PACalculationParameters.  # noqa: E501
        :type: list[PAIdentifier]
        """

        self._accounts = accounts

    @property
    def benchmarks(self):
        """Gets the benchmarks of this PACalculationParameters.  # noqa: E501

        List of benchmarks.  # noqa: E501

        :return: The benchmarks of this PACalculationParameters.  # noqa: E501
        :rtype: list[PAIdentifier]
        """
        return self._benchmarks

    @benchmarks.setter
    def benchmarks(self, benchmarks):
        """Sets the benchmarks of this PACalculationParameters.

        List of benchmarks.  # noqa: E501

        :param benchmarks: The benchmarks of this PACalculationParameters.  # noqa: E501
        :type: list[PAIdentifier]
        """

        self._benchmarks = benchmarks

    @property
    def dates(self):
        """Gets the dates of this PACalculationParameters.  # noqa: E501


        :return: The dates of this PACalculationParameters.  # noqa: E501
        :rtype: PADateParameters
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this PACalculationParameters.


        :param dates: The dates of this PACalculationParameters.  # noqa: E501
        :type: PADateParameters
        """

        self._dates = dates

    @property
    def groups(self):
        """Gets the groups of this PACalculationParameters.  # noqa: E501

        List of groupings for the PA calculation. This will take precedence over the groupings saved in the PA document.  # noqa: E501

        :return: The groups of this PACalculationParameters.  # noqa: E501
        :rtype: list[PACalculationGroup]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this PACalculationParameters.

        List of groupings for the PA calculation. This will take precedence over the groupings saved in the PA document.  # noqa: E501

        :param groups: The groups of this PACalculationParameters.  # noqa: E501
        :type: list[PACalculationGroup]
        """

        self._groups = groups

    @property
    def currencyisocode(self):
        """Gets the currencyisocode of this PACalculationParameters.  # noqa: E501

        Currency ISO code for calculation.  # noqa: E501

        :return: The currencyisocode of this PACalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._currencyisocode

    @currencyisocode.setter
    def currencyisocode(self, currencyisocode):
        """Sets the currencyisocode of this PACalculationParameters.

        Currency ISO code for calculation.  # noqa: E501

        :param currencyisocode: The currencyisocode of this PACalculationParameters.  # noqa: E501
        :type: str
        """

        self._currencyisocode = currencyisocode

    @property
    def columns(self):
        """Gets the columns of this PACalculationParameters.  # noqa: E501

        List of columns for the PA calculation. This will take precedence over the columns saved in the PA document.  # noqa: E501

        :return: The columns of this PACalculationParameters.  # noqa: E501
        :rtype: list[PACalculationColumn]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this PACalculationParameters.

        List of columns for the PA calculation. This will take precedence over the columns saved in the PA document.  # noqa: E501

        :param columns: The columns of this PACalculationParameters.  # noqa: E501
        :type: list[PACalculationColumn]
        """

        self._columns = columns

    @property
    def componentdetail(self):
        """Gets the componentdetail of this PACalculationParameters.  # noqa: E501

        Component detail type for the PA component. It can be GROUPS or TOTALS.  # noqa: E501

        :return: The componentdetail of this PACalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._componentdetail

    @componentdetail.setter
    def componentdetail(self, componentdetail):
        """Sets the componentdetail of this PACalculationParameters.

        Component detail type for the PA component. It can be GROUPS or TOTALS.  # noqa: E501

        :param componentdetail: The componentdetail of this PACalculationParameters.  # noqa: E501
        :type: str
        """

        self._componentdetail = componentdetail

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PACalculationParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PACalculationParameters):
            return True

        return self.to_dict() != other.to_dict()
