# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['changelogger',
 'changelogger.app',
 'changelogger.app.manage',
 'changelogger.app.manage.commands',
 'changelogger.app.unreleased',
 'changelogger.app.unreleased.commands',
 'changelogger.conf',
 'changelogger.models']

package_data = \
{'': ['*']}

install_requires = \
['coverage>=7.1.0,<8.0.0',
 'freezegun>=1.2.2,<2.0.0',
 'gitpython==3.1.30',
 'jinja2==3.1.2',
 'mypy>=0.991,<0.992',
 'pydantic==1.10.2',
 'pytest>=7.2.1,<8.0.0',
 'pyyaml==6.0',
 'rich==12.6.0',
 'semver==2.13.0',
 'typer==0.7.0']

entry_points = \
{'console_scripts': ['changelogger = changelogger.__main__:app']}

setup_kwargs = {
    'name': 'changelogged',
    'version': '0.3.0',
    'description': '',
    'long_description': '# Changelogger\nAutomated management of your CHANGELOG.md and other versioned files, following\nthe principles of [Keep a Changelog](https://keepachangelog.com) and\n[Semantic Versioning](https://semver.org).\n\n\nThis project uses [Jinja](https://jinja.palletsprojects.com/) for simple yet\npowerful templating and regular expressions for pattern matching. To learn more\nabout this, checkout the [`.changelogger.yml` Syntax](#changelogger-syntax)\nsection. The next section will go over how this works, and you can use\nchangelogger to help manage your versioned files.\n\n## Installation\n\n```\nTODO\n```\n\n## Usage\n\n```\nTODO\n```\n\n## Motivation\n\nWith any software that is versioned, it is typically necessary to include the\nversion number in more than one file. In addition to the version changes, there\nis also a need for certain projects to include their changelog contents in\nmultiple locations. **Maintaining these files by hand is tedious and error prone.**\n\nBy automating the upgrade of each of these files, we can reduce the risk of\nout-of-sync files, validate these changes in our CI/CD pipelines, and save\nourselves some time.\n\n## Introduction\n\nThe `.changelogger.yml` configuration file allows you to customize what files\nare versioned and maintained by Changelogger. Let\'s say you have a `pyproject.toml`\nfile which is versioned in addition to you `CHANGELOG.md` file. You would add the\n`.changelogger.yml` file to the root of your project, with the following configuration.\n\n```yml\nversioned_files:\n  - rel_path: "pyproject.toml"\n    pattern: \'version = "{{ old_version }}"\'\n    jinja: \'version = "{{ new_version }}"\'\n```\n\nIn fact, that\'s the exact yaml used by this project! Let\'s breakdown what each\nline means.\n\n##### `versioned_files:`\nThis line let\'s Changelogger know that you have a list of files you would like\nChangelogger to maintain. This list can be one or more, but if it doesn\'t exist,\nChangelogger will only manage the `CHANGELOG.md` file.\n\n##### `- rel_path: "pyproject.toml"`\nThe `-` is the start of a new versioned file section; it\'s unimportant that this\nis on the `rel_path` field, but is important that this section is separated from\nother versioned files and that all other related fields are below the `-`\'d field.\n\nThe `rel_path` lets Changelogger know that there is a file in the path, relative\nto the `.changelogger.yml` file, that you would like Changelogger to maintain the\nversion in said file. In this case, the `pyproject.toml` file is at the root of\nthis project, so all we need is that name.\n\n**Note** that you can list a file multiple times within the configuration file;\nthis can reduce the complexity of pattern matching while keeping all versioned\nsections of a file in-sync.\n\n##### `pattern: \'version = "{{ old_version }}"\'`\nThe `pattern` field lets Changelogger know how to find the versioned segment in\nthis file. The `pattern` field supports Python\'s flavor of regular expressions,\nas well as the use of Jinja with pre-determined variables. More on these can be\nfound [below](#jinja-variables). The combination of these two allow for a strong\nyet simple pattern matching interface.\n\n##### `jinja: \'version = "{{ new_version }}"\'`\nThe `jinja` field is used as a jinja template to replace the matched pattern.\nThe same rendered variables which are available for the `pattern` field can\nbe utilized by this field.\n\nFurther, using standard yaml, you can create a multiline jinja to replace the\nmatched pattern. For instance, if our release also came with a release date,\nwe could use the following `.changelogger.yml` file to manage the required\nchanges.\n\n```yml\nversioned_files:\n  - rel_path: "pyproject.toml"\n    pattern: \'version = "{{ old_version }}"\\nrelease_date = "\\d+-\\d+-\\d+"\'\n    jinja: |\n      version = "{{ new_version }}"\n      release_date = "{{ today }}"\n```\n\nWhile this approach is great for a simple use case like the one above, it\nfalls short for more complex jinja templates. To help deal with this\nlimitation, the `jinja_rel_path` field can be used. This allows us to move\nour code to a jinja file and reference said file relative to the\n`.changelogger.yml` file.\n\n*.changelogger.yml*\n```yml\nversioned_files:\n  - rel_path: "pyproject.toml"\n    pattern: \'version = "{{ old_version }}"\\nrelease_date = "\\d+-\\d+-\\d+"\'\n    jinja: |\n      version = "{{ new_version }}"\n      release_date = "{{ today }}"\n```\n\n*.pyproject.toml.jinja2*\n```jinja\nversion = "{{ new_version }}"\nrelease_date = "{{ today }}"\n```\n\nNow we have our multiline Jinja outside of our configuration file and, with\nthe right IDE support, we can get Jinja syntax highlighting. Examples of Jinja\ntemplates used by this project can be found in the [`./assets`](../assets)\ndirectory.\n\n---\n\nWith that, we now understand how the Changelogger configuration file works.\nNow all you need to do is let Changelogger do the heavy lifting for any\nupgrade with the `manage upgrade`. Make sure to explore what commands are\navailable by using the `changelogger --help` command!\n\n## `.changelogger.yml` Syntax\n\nThis section reviews all available configuration sections of the Changelogger\nconfiguration file. For a more streamlined introduction, review the\n[introduction](#introduction) section. The\n[JSON Schema Core](https://json-schema.org/latest/json-schema-core.html)\ncompliant schema can be found in the\n[config.schema.json](../config.schema.json) file.\n\n\nThe `changelog` field is used for managing and updating the `CHANGELOG.md`.\nIf your project doesn\'t follow the standard changelog file format prescribed\nby Changelogger, you will need to upate this section. **Note** that the changelog\nsection requires both the overview and links sub sections be provided. However,\nif there are other versioned changes you would like to require Changelogger manage\non your behalf, you can add those to the `versioned_files` section.\n\n*Example File with All Required Fields*\n```yml\nchangelog:\n  rel_path: "CHANGELOG.md"\n  overview:\n    pattern: \'### \\[Unreleased\\]([\\s\\S]*)### \\[{{ old_version }}]\'\n    jinja_rel_path: ./assets/.cl.overview.jinja2\n  links:\n    pattern: \'\\[Unreleased\\]:.*\\n\'\n    jinja_rel_path: ./assets/.cl.links.jinja2\n\nversioned_files:\n  - rel_path: "pyproject.toml"\n    pattern: \'version = "{{ old_version }}"\'\n    jinja: \'version = "{{ new_version }}"\'\n```\n\n\n# Jinja Variables\nThe following is an overview of the jinja variables available in the `pattern`\nfield and the `jinja` templating for managed replacement.\n\n## `new_version`: string\n\nThe new version after the requested semantic version bump type has been applied.\n\n### Example\n\n*.some.jinja2*\n```jinja\nNew Version: {{ new_version }}\n```\n\n## `old_version`: string\n\nThe current version of the project, which the requested semantic version bump type\nwill be applied on.\n\n### Example\n\n*.some.jinja2*\n```jinja\nOld Version: {{ old_version }}\n```\n\n## `today`: datetime.date\n\nA [datetime.date](https://docs.python.org/3/library/datetime.html#date-objects)\nobject with today\'s date.\n\n### Example\n\n*.some.jinja2*\n```jinja\nTodays Date: {{ today }}\n```\n\n## `sections`: dict[str, list[str]]\n\nA map from each section of the Keep a Changelog standard to the notes included for\nthat section.\n\n### Example\n\n*.some.jinja2*\n```jinja\n{% for name, notes in sections.items() -%}\n{% if notes -%}\n#### {{ name.title() }}\n{% for note in notes -%}\n- {{ note }}\n{% endfor %}\n{% endif %}\n\n{%- endfor -%}\n```\n## `context`: dict[str, Any]\n\nUser specified context in the `.changelogger.yml` configuration file, available in\nboth the pattern and jinja through dot notation.\n\n### Example\n\n*.changelogger.yml*\n```yml\nversioned_files:\n  - rel_path: "pyproject.toml"\n    pattern: \'version = "{{ old_version }}"\'\n    jinja_rel_path: \'.pyproject.toml.jinja2\'\n    context:\n      git:\n        org: award28\n        repo: changelogger\n```\n\n*.pyproject.toml.jinja2*\n```jinja\norg: {{ context.git.org }}\nrepo: {{ context.git.repo }}\n```\n',
    'author': 'award28',
    'author_email': 'austin.ward@klaviyo.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
