"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('minimal', () => {
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    new __1.NodePackage(project);
    // THEN
    expect(packageJson(project)).toStrictEqual({
        'name': 'my-project',
        'version': '0.0.0',
        'license': 'Apache-2.0',
        'main': 'lib/index.js',
        'bundledDependencies': [],
        'dependencies': {},
        'devDependencies': {},
        'peerDependencies': {},
        'scripts': {},
        '//': '~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".',
    });
});
test('packageName overrides project name', () => {
    const p = new util_1.TestProject();
    new __1.NodePackage(p, { packageName: 'hoooray' });
    expect(packageJson(p).name).toStrictEqual('hoooray');
});
function packageJson(p) {
    return util_1.synthSnapshot(p)['package.json'];
}
//# sourceMappingURL=data:application/json;base64,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