"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApprovalAction = void 0;
const path = require("path");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_sns_subscriptions_1 = require("@aws-cdk/aws-sns-subscriptions");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class SlackApprovalAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
        this.props = props;
    }
    bound(scope, stage, options) {
        const environment = {
            SLACK_BOT_TOKEN: this.props.slackBotToken,
            SLACK_SIGNING_SECRET: this.props.slackSigningSecret,
            SLACK_CHANNEL: this.props.slackChannel,
            SLACK_CHANNEL_ID: this.props.slackChannelId,
            SLACK_BOT_NAME: this.props.slackBotName || 'buildbot',
            SLACK_BOT_ICON: this.props.slackBotIcon || ':robot_face:',
        };
        const approvalRequester = new aws_lambda_1.Function(scope, 'SlackApprovalRequesterFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.asset(path.join(__dirname, 'lambdas', 'approval-requester')),
            environment,
        });
        const topic = new aws_sns_1.Topic(scope, 'SlackApprovalTopic');
        topic.grantPublish(options.role);
        topic.addSubscription(new aws_sns_subscriptions_1.LambdaSubscription(approvalRequester));
        const approvalHandler = new aws_lambda_1.Function(scope, 'SlackApprovalHandlerFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-handler')),
            environment,
        });
        const api = new aws_apigateway_1.RestApi(scope, 'SlackApprovalApi');
        api.root.addProxy({
            defaultIntegration: new aws_apigateway_1.LambdaIntegration(approvalHandler),
        });
        approvalHandler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [
                `${stage.pipeline.pipelineArn}/${stage.stageName}/${this.props.actionName}`,
            ],
        }));
        return {
            configuration: {
                NotificationArn: topic.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            },
        };
    }
}
exports.SlackApprovalAction = SlackApprovalAction;
//# sourceMappingURL=data:application/json;base64,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