# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTransitCloudnConnArgs', 'AviatrixTransitCloudnConn']

@pulumi.input_type
class AviatrixTransitCloudnConnArgs:
    def __init__(__self__, *,
                 bgp_local_as_num: pulumi.Input[str],
                 cloudn_as_num: pulumi.Input[str],
                 cloudn_neighbor_as_num: pulumi.Input[str],
                 cloudn_neighbor_ip: pulumi.Input[str],
                 cloudn_remote_ip: pulumi.Input[str],
                 connection_name: pulumi.Input[str],
                 gw_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_ip: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_insane_mode: Optional[pulumi.Input[bool]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_load_balancing: Optional[pulumi.Input[bool]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixTransitCloudnConn resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP AS Number of the Transit Gateway. Type: String.
        :param pulumi.Input[str] cloudn_as_num: BGP AS Number of the Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_as_num: BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_ip: IP Address of Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_remote_ip: IP Address of Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] connection_name: Name of the Transit Gateway to CloudN Connection. Type: String.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway. Type: String.
        :param pulumi.Input[str] vpc_id: VPC ID of the Aviatrix Transit Gateway. Type: String.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        :param pulumi.Input[str] backup_cloudn_as_num: BGP AS Number of HA CloudN. Type: String.
        :param pulumi.Input[str] backup_cloudn_ip: IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_as_num: BGP AS Number of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_ip: IP Address of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[bool] backup_direct_connect: Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] backup_insane_mode: Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] direct_connect: Enable direct connect over private network. Type: Boolean. Default: true.
        :param pulumi.Input[bool] enable_ha: Enable connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable encrypted transit approval for connection. Type: Boolean.
        :param pulumi.Input[bool] enable_load_balancing: Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] insane_mode: Enable insane mode connection. Type: Boolean.
        """
        pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        pulumi.set(__self__, "cloudn_as_num", cloudn_as_num)
        pulumi.set(__self__, "cloudn_neighbor_as_num", cloudn_neighbor_as_num)
        pulumi.set(__self__, "cloudn_neighbor_ip", cloudn_neighbor_ip)
        pulumi.set(__self__, "cloudn_remote_ip", cloudn_remote_ip)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if approved_cidrs is not None:
            pulumi.set(__self__, "approved_cidrs", approved_cidrs)
        if backup_cloudn_as_num is not None:
            pulumi.set(__self__, "backup_cloudn_as_num", backup_cloudn_as_num)
        if backup_cloudn_ip is not None:
            pulumi.set(__self__, "backup_cloudn_ip", backup_cloudn_ip)
        if backup_cloudn_neighbor_as_num is not None:
            pulumi.set(__self__, "backup_cloudn_neighbor_as_num", backup_cloudn_neighbor_as_num)
        if backup_cloudn_neighbor_ip is not None:
            pulumi.set(__self__, "backup_cloudn_neighbor_ip", backup_cloudn_neighbor_ip)
        if backup_direct_connect is not None:
            pulumi.set(__self__, "backup_direct_connect", backup_direct_connect)
        if backup_insane_mode is not None:
            pulumi.set(__self__, "backup_insane_mode", backup_insane_mode)
        if direct_connect is not None:
            pulumi.set(__self__, "direct_connect", direct_connect)
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_load_balancing is not None:
            pulumi.set(__self__, "enable_load_balancing", enable_load_balancing)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Input[str]:
        """
        BGP AS Number of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="cloudnAsNum")
    def cloudn_as_num(self) -> pulumi.Input[str]:
        """
        BGP AS Number of the Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_as_num")

    @cloudn_as_num.setter
    def cloudn_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_as_num", value)

    @property
    @pulumi.getter(name="cloudnNeighborAsNum")
    def cloudn_neighbor_as_num(self) -> pulumi.Input[str]:
        """
        BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_as_num")

    @cloudn_neighbor_as_num.setter
    def cloudn_neighbor_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_neighbor_as_num", value)

    @property
    @pulumi.getter(name="cloudnNeighborIp")
    def cloudn_neighbor_ip(self) -> pulumi.Input[str]:
        """
        IP Address of Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_ip")

    @cloudn_neighbor_ip.setter
    def cloudn_neighbor_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_neighbor_ip", value)

    @property
    @pulumi.getter(name="cloudnRemoteIp")
    def cloudn_remote_ip(self) -> pulumi.Input[str]:
        """
        IP Address of Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_remote_ip")

    @cloudn_remote_ip.setter
    def cloudn_remote_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_remote_ip", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit Gateway to CloudN Connection. Type: String.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @approved_cidrs.setter
    def approved_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_cidrs", value)

    @property
    @pulumi.getter(name="backupCloudnAsNum")
    def backup_cloudn_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of HA CloudN. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_as_num")

    @backup_cloudn_as_num.setter
    def backup_cloudn_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_as_num", value)

    @property
    @pulumi.getter(name="backupCloudnIp")
    def backup_cloudn_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_ip")

    @backup_cloudn_ip.setter
    def backup_cloudn_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_ip", value)

    @property
    @pulumi.getter(name="backupCloudnNeighborAsNum")
    def backup_cloudn_neighbor_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_as_num")

    @backup_cloudn_neighbor_as_num.setter
    def backup_cloudn_neighbor_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_neighbor_as_num", value)

    @property
    @pulumi.getter(name="backupCloudnNeighborIp")
    def backup_cloudn_neighbor_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_ip")

    @backup_cloudn_neighbor_ip.setter
    def backup_cloudn_neighbor_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_neighbor_ip", value)

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_direct_connect")

    @backup_direct_connect.setter
    def backup_direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_direct_connect", value)

    @property
    @pulumi.getter(name="backupInsaneMode")
    def backup_insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_insane_mode")

    @backup_insane_mode.setter
    def backup_insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_insane_mode", value)

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable direct connect over private network. Type: Boolean. Default: true.
        """
        return pulumi.get(self, "direct_connect")

    @direct_connect.setter
    def direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "direct_connect", value)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypted transit approval for connection. Type: Boolean.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableLoadBalancing")
    def enable_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_load_balancing")

    @enable_load_balancing.setter
    def enable_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_load_balancing", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable insane mode connection. Type: Boolean.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)


@pulumi.input_type
class _AviatrixTransitCloudnConnState:
    def __init__(__self__, *,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_ip: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_insane_mode: Optional[pulumi.Input[bool]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 cloudn_remote_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_load_balancing: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixTransitCloudnConn resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        :param pulumi.Input[str] backup_cloudn_as_num: BGP AS Number of HA CloudN. Type: String.
        :param pulumi.Input[str] backup_cloudn_ip: IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_as_num: BGP AS Number of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_ip: IP Address of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[bool] backup_direct_connect: Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] backup_insane_mode: Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[str] bgp_local_as_num: BGP AS Number of the Transit Gateway. Type: String.
        :param pulumi.Input[str] cloudn_as_num: BGP AS Number of the Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_as_num: BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_ip: IP Address of Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_remote_ip: IP Address of Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] connection_name: Name of the Transit Gateway to CloudN Connection. Type: String.
        :param pulumi.Input[bool] direct_connect: Enable direct connect over private network. Type: Boolean. Default: true.
        :param pulumi.Input[bool] enable_ha: Enable connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable encrypted transit approval for connection. Type: Boolean.
        :param pulumi.Input[bool] enable_load_balancing: Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway. Type: String.
        :param pulumi.Input[bool] insane_mode: Enable insane mode connection. Type: Boolean.
        :param pulumi.Input[str] vpc_id: VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        if approved_cidrs is not None:
            pulumi.set(__self__, "approved_cidrs", approved_cidrs)
        if backup_cloudn_as_num is not None:
            pulumi.set(__self__, "backup_cloudn_as_num", backup_cloudn_as_num)
        if backup_cloudn_ip is not None:
            pulumi.set(__self__, "backup_cloudn_ip", backup_cloudn_ip)
        if backup_cloudn_neighbor_as_num is not None:
            pulumi.set(__self__, "backup_cloudn_neighbor_as_num", backup_cloudn_neighbor_as_num)
        if backup_cloudn_neighbor_ip is not None:
            pulumi.set(__self__, "backup_cloudn_neighbor_ip", backup_cloudn_neighbor_ip)
        if backup_direct_connect is not None:
            pulumi.set(__self__, "backup_direct_connect", backup_direct_connect)
        if backup_insane_mode is not None:
            pulumi.set(__self__, "backup_insane_mode", backup_insane_mode)
        if bgp_local_as_num is not None:
            pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        if cloudn_as_num is not None:
            pulumi.set(__self__, "cloudn_as_num", cloudn_as_num)
        if cloudn_neighbor_as_num is not None:
            pulumi.set(__self__, "cloudn_neighbor_as_num", cloudn_neighbor_as_num)
        if cloudn_neighbor_ip is not None:
            pulumi.set(__self__, "cloudn_neighbor_ip", cloudn_neighbor_ip)
        if cloudn_remote_ip is not None:
            pulumi.set(__self__, "cloudn_remote_ip", cloudn_remote_ip)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if direct_connect is not None:
            pulumi.set(__self__, "direct_connect", direct_connect)
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_load_balancing is not None:
            pulumi.set(__self__, "enable_load_balancing", enable_load_balancing)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @approved_cidrs.setter
    def approved_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_cidrs", value)

    @property
    @pulumi.getter(name="backupCloudnAsNum")
    def backup_cloudn_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of HA CloudN. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_as_num")

    @backup_cloudn_as_num.setter
    def backup_cloudn_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_as_num", value)

    @property
    @pulumi.getter(name="backupCloudnIp")
    def backup_cloudn_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_ip")

    @backup_cloudn_ip.setter
    def backup_cloudn_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_ip", value)

    @property
    @pulumi.getter(name="backupCloudnNeighborAsNum")
    def backup_cloudn_neighbor_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_as_num")

    @backup_cloudn_neighbor_as_num.setter
    def backup_cloudn_neighbor_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_neighbor_as_num", value)

    @property
    @pulumi.getter(name="backupCloudnNeighborIp")
    def backup_cloudn_neighbor_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_ip")

    @backup_cloudn_neighbor_ip.setter
    def backup_cloudn_neighbor_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_cloudn_neighbor_ip", value)

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_direct_connect")

    @backup_direct_connect.setter
    def backup_direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_direct_connect", value)

    @property
    @pulumi.getter(name="backupInsaneMode")
    def backup_insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_insane_mode")

    @backup_insane_mode.setter
    def backup_insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_insane_mode", value)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="cloudnAsNum")
    def cloudn_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of the Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_as_num")

    @cloudn_as_num.setter
    def cloudn_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_as_num", value)

    @property
    @pulumi.getter(name="cloudnNeighborAsNum")
    def cloudn_neighbor_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_as_num")

    @cloudn_neighbor_as_num.setter
    def cloudn_neighbor_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_neighbor_as_num", value)

    @property
    @pulumi.getter(name="cloudnNeighborIp")
    def cloudn_neighbor_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_ip")

    @cloudn_neighbor_ip.setter
    def cloudn_neighbor_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_neighbor_ip", value)

    @property
    @pulumi.getter(name="cloudnRemoteIp")
    def cloudn_remote_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_remote_ip")

    @cloudn_remote_ip.setter
    def cloudn_remote_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_remote_ip", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit Gateway to CloudN Connection. Type: String.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable direct connect over private network. Type: Boolean. Default: true.
        """
        return pulumi.get(self, "direct_connect")

    @direct_connect.setter
    def direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "direct_connect", value)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypted transit approval for connection. Type: Boolean.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableLoadBalancing")
    def enable_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_load_balancing")

    @enable_load_balancing.setter
    def enable_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_load_balancing", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable insane mode connection. Type: Boolean.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixTransitCloudnConn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_ip: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_insane_mode: Optional[pulumi.Input[bool]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 cloudn_remote_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_load_balancing: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_transit_cloudn_conn** resource creates and manages the connection between an Aviatrix Transit Gateway and an Aviatrix CloudN device. Available as of provider version R2.21.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit Gateway to CloudN Connection
        test = aviatrix.AviatrixTransitCloudnConn("test",
            bgp_local_as_num="123",
            cloudn_as_num="345",
            cloudn_neighbor_as_num="65005",
            cloudn_neighbor_ip="182.1.2.3",
            cloudn_remote_ip="172.12.13.14",
            connection_name="my_conn",
            gw_name="transitGw",
            vpc_id="vpc-abcd1234")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit Gateway to CloudN Connection with HA
        test = aviatrix.AviatrixTransitCloudnConn("test",
            backup_cloudn_as_num="123",
            backup_cloudn_ip="1.2.3.6",
            backup_cloudn_neighbor_as_num="345",
            backup_cloudn_neighbor_ip="1.2.3.7",
            bgp_local_as_num="123",
            cloudn_as_num="345",
            cloudn_neighbor_as_num="65005",
            cloudn_neighbor_ip="1.2.3.5",
            cloudn_remote_ip="1.2.3.4",
            connection_name="my_conn",
            enable_ha=True,
            gw_name="transitGw",
            vpc_id="vpc-abcd1234")
        ```

        ## Import

        **transit_cloudn_conn** can be imported using the `connection_name` and `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixTransitCloudnConn:AviatrixTransitCloudnConn test connection_name~vpc_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        :param pulumi.Input[str] backup_cloudn_as_num: BGP AS Number of HA CloudN. Type: String.
        :param pulumi.Input[str] backup_cloudn_ip: IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_as_num: BGP AS Number of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_ip: IP Address of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[bool] backup_direct_connect: Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] backup_insane_mode: Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[str] bgp_local_as_num: BGP AS Number of the Transit Gateway. Type: String.
        :param pulumi.Input[str] cloudn_as_num: BGP AS Number of the Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_as_num: BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_ip: IP Address of Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_remote_ip: IP Address of Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] connection_name: Name of the Transit Gateway to CloudN Connection. Type: String.
        :param pulumi.Input[bool] direct_connect: Enable direct connect over private network. Type: Boolean. Default: true.
        :param pulumi.Input[bool] enable_ha: Enable connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable encrypted transit approval for connection. Type: Boolean.
        :param pulumi.Input[bool] enable_load_balancing: Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway. Type: String.
        :param pulumi.Input[bool] insane_mode: Enable insane mode connection. Type: Boolean.
        :param pulumi.Input[str] vpc_id: VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTransitCloudnConnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_transit_cloudn_conn** resource creates and manages the connection between an Aviatrix Transit Gateway and an Aviatrix CloudN device. Available as of provider version R2.21.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit Gateway to CloudN Connection
        test = aviatrix.AviatrixTransitCloudnConn("test",
            bgp_local_as_num="123",
            cloudn_as_num="345",
            cloudn_neighbor_as_num="65005",
            cloudn_neighbor_ip="182.1.2.3",
            cloudn_remote_ip="172.12.13.14",
            connection_name="my_conn",
            gw_name="transitGw",
            vpc_id="vpc-abcd1234")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit Gateway to CloudN Connection with HA
        test = aviatrix.AviatrixTransitCloudnConn("test",
            backup_cloudn_as_num="123",
            backup_cloudn_ip="1.2.3.6",
            backup_cloudn_neighbor_as_num="345",
            backup_cloudn_neighbor_ip="1.2.3.7",
            bgp_local_as_num="123",
            cloudn_as_num="345",
            cloudn_neighbor_as_num="65005",
            cloudn_neighbor_ip="1.2.3.5",
            cloudn_remote_ip="1.2.3.4",
            connection_name="my_conn",
            enable_ha=True,
            gw_name="transitGw",
            vpc_id="vpc-abcd1234")
        ```

        ## Import

        **transit_cloudn_conn** can be imported using the `connection_name` and `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixTransitCloudnConn:AviatrixTransitCloudnConn test connection_name~vpc_id
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixTransitCloudnConnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTransitCloudnConnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_ip: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 backup_cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_insane_mode: Optional[pulumi.Input[bool]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
                 cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 cloudn_remote_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_load_balancing: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTransitCloudnConnArgs.__new__(AviatrixTransitCloudnConnArgs)

            __props__.__dict__["approved_cidrs"] = approved_cidrs
            __props__.__dict__["backup_cloudn_as_num"] = backup_cloudn_as_num
            __props__.__dict__["backup_cloudn_ip"] = backup_cloudn_ip
            __props__.__dict__["backup_cloudn_neighbor_as_num"] = backup_cloudn_neighbor_as_num
            __props__.__dict__["backup_cloudn_neighbor_ip"] = backup_cloudn_neighbor_ip
            __props__.__dict__["backup_direct_connect"] = backup_direct_connect
            __props__.__dict__["backup_insane_mode"] = backup_insane_mode
            if bgp_local_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_local_as_num'")
            __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
            if cloudn_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_as_num'")
            __props__.__dict__["cloudn_as_num"] = cloudn_as_num
            if cloudn_neighbor_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_neighbor_as_num'")
            __props__.__dict__["cloudn_neighbor_as_num"] = cloudn_neighbor_as_num
            if cloudn_neighbor_ip is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_neighbor_ip'")
            __props__.__dict__["cloudn_neighbor_ip"] = cloudn_neighbor_ip
            if cloudn_remote_ip is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_remote_ip'")
            __props__.__dict__["cloudn_remote_ip"] = cloudn_remote_ip
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["direct_connect"] = direct_connect
            __props__.__dict__["enable_ha"] = enable_ha
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            __props__.__dict__["enable_load_balancing"] = enable_load_balancing
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["insane_mode"] = insane_mode
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixTransitCloudnConn, __self__).__init__(
            'aviatrix:index/aviatrixTransitCloudnConn:AviatrixTransitCloudnConn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_cloudn_as_num: Optional[pulumi.Input[str]] = None,
            backup_cloudn_ip: Optional[pulumi.Input[str]] = None,
            backup_cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
            backup_cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
            backup_direct_connect: Optional[pulumi.Input[bool]] = None,
            backup_insane_mode: Optional[pulumi.Input[bool]] = None,
            bgp_local_as_num: Optional[pulumi.Input[str]] = None,
            cloudn_as_num: Optional[pulumi.Input[str]] = None,
            cloudn_neighbor_as_num: Optional[pulumi.Input[str]] = None,
            cloudn_neighbor_ip: Optional[pulumi.Input[str]] = None,
            cloudn_remote_ip: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            direct_connect: Optional[pulumi.Input[bool]] = None,
            enable_ha: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            enable_load_balancing: Optional[pulumi.Input[bool]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            insane_mode: Optional[pulumi.Input[bool]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixTransitCloudnConn':
        """
        Get an existing AviatrixTransitCloudnConn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        :param pulumi.Input[str] backup_cloudn_as_num: BGP AS Number of HA CloudN. Type: String.
        :param pulumi.Input[str] backup_cloudn_ip: IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_as_num: BGP AS Number of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[str] backup_cloudn_neighbor_ip: IP Address of HA CloudN Neighbor. Type: String.
        :param pulumi.Input[bool] backup_direct_connect: Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] backup_insane_mode: Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[str] bgp_local_as_num: BGP AS Number of the Transit Gateway. Type: String.
        :param pulumi.Input[str] cloudn_as_num: BGP AS Number of the Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_as_num: BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_neighbor_ip: IP Address of Aviatrix CloudN neighbor. Type: String.
        :param pulumi.Input[str] cloudn_remote_ip: IP Address of Aviatrix CloudN. Type: String.
        :param pulumi.Input[str] connection_name: Name of the Transit Gateway to CloudN Connection. Type: String.
        :param pulumi.Input[bool] direct_connect: Enable direct connect over private network. Type: Boolean. Default: true.
        :param pulumi.Input[bool] enable_ha: Enable connection to HA CloudN. Type: Boolean.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable encrypted transit approval for connection. Type: Boolean.
        :param pulumi.Input[bool] enable_load_balancing: Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway. Type: String.
        :param pulumi.Input[bool] insane_mode: Enable insane mode connection. Type: Boolean.
        :param pulumi.Input[str] vpc_id: VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTransitCloudnConnState.__new__(_AviatrixTransitCloudnConnState)

        __props__.__dict__["approved_cidrs"] = approved_cidrs
        __props__.__dict__["backup_cloudn_as_num"] = backup_cloudn_as_num
        __props__.__dict__["backup_cloudn_ip"] = backup_cloudn_ip
        __props__.__dict__["backup_cloudn_neighbor_as_num"] = backup_cloudn_neighbor_as_num
        __props__.__dict__["backup_cloudn_neighbor_ip"] = backup_cloudn_neighbor_ip
        __props__.__dict__["backup_direct_connect"] = backup_direct_connect
        __props__.__dict__["backup_insane_mode"] = backup_insane_mode
        __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
        __props__.__dict__["cloudn_as_num"] = cloudn_as_num
        __props__.__dict__["cloudn_neighbor_as_num"] = cloudn_neighbor_as_num
        __props__.__dict__["cloudn_neighbor_ip"] = cloudn_neighbor_ip
        __props__.__dict__["cloudn_remote_ip"] = cloudn_remote_ip
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["direct_connect"] = direct_connect
        __props__.__dict__["enable_ha"] = enable_ha
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["enable_load_balancing"] = enable_load_balancing
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["insane_mode"] = insane_mode
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixTransitCloudnConn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of approved CIDRs. Requires `enable_learned_cidrs_approval` to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @property
    @pulumi.getter(name="backupCloudnAsNum")
    def backup_cloudn_as_num(self) -> pulumi.Output[Optional[str]]:
        """
        BGP AS Number of HA CloudN. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_as_num")

    @property
    @pulumi.getter(name="backupCloudnIp")
    def backup_cloudn_ip(self) -> pulumi.Output[Optional[str]]:
        """
        IP Address of HA CloudN. Required when `enable_ha` is true. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_ip")

    @property
    @pulumi.getter(name="backupCloudnNeighborAsNum")
    def backup_cloudn_neighbor_as_num(self) -> pulumi.Output[Optional[str]]:
        """
        BGP AS Number of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_as_num")

    @property
    @pulumi.getter(name="backupCloudnNeighborIp")
    def backup_cloudn_neighbor_ip(self) -> pulumi.Output[Optional[str]]:
        """
        IP Address of HA CloudN Neighbor. Type: String.
        """
        return pulumi.get(self, "backup_cloudn_neighbor_ip")

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to enable direct connect over private network to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_direct_connect")

    @property
    @pulumi.getter(name="backupInsaneMode")
    def backup_insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to enable insane mode connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "backup_insane_mode")

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Output[str]:
        """
        BGP AS Number of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @property
    @pulumi.getter(name="cloudnAsNum")
    def cloudn_as_num(self) -> pulumi.Output[str]:
        """
        BGP AS Number of the Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_as_num")

    @property
    @pulumi.getter(name="cloudnNeighborAsNum")
    def cloudn_neighbor_as_num(self) -> pulumi.Output[str]:
        """
        BGP AS Number of the Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_as_num")

    @property
    @pulumi.getter(name="cloudnNeighborIp")
    def cloudn_neighbor_ip(self) -> pulumi.Output[str]:
        """
        IP Address of Aviatrix CloudN neighbor. Type: String.
        """
        return pulumi.get(self, "cloudn_neighbor_ip")

    @property
    @pulumi.getter(name="cloudnRemoteIp")
    def cloudn_remote_ip(self) -> pulumi.Output[str]:
        """
        IP Address of Aviatrix CloudN. Type: String.
        """
        return pulumi.get(self, "cloudn_remote_ip")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit Gateway to CloudN Connection. Type: String.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable direct connect over private network. Type: Boolean. Default: true.
        """
        return pulumi.get(self, "direct_connect")

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable connection to HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_ha")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable encrypted transit approval for connection. Type: Boolean.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="enableLoadBalancing")
    def enable_load_balancing(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to enable load balancing between CloudN and HA CloudN. Type: Boolean.
        """
        return pulumi.get(self, "enable_load_balancing")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit Gateway. Type: String.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable insane mode connection. Type: Boolean.
        """
        return pulumi.get(self, "insane_mode")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID of the Aviatrix Transit Gateway. Type: String.
        """
        return pulumi.get(self, "vpc_id")

