# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSegmentationNetworkDomainArgs', 'AviatrixSegmentationNetworkDomain']

@pulumi.input_type
class AviatrixSegmentationNetworkDomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixSegmentationNetworkDomain resource.
        :param pulumi.Input[str] domain_name: Name of the Network Domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Name of the Network Domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)


@pulumi.input_type
class _AviatrixSegmentationNetworkDomainState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSegmentationNetworkDomain resources.
        :param pulumi.Input[str] domain_name: Name of the Network Domain.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Network Domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)


class AviatrixSegmentationNetworkDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_segmentation_network_domain** resource handles creation of [Transit Segmentation](https://docs.aviatrix.com/HowTos/transit_segmentation_faq.html) Network Domains.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Segmentation Network Domain
        test_segmentation_network_domain = aviatrix.AviatrixSegmentationNetworkDomain("testSegmentationNetworkDomain", domain_name="domain-a")
        ```

        ## Import

        **aviatrix_segmentation_network_domain** can be imported using the `domain_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSegmentationNetworkDomain:AviatrixSegmentationNetworkDomain test domain_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: Name of the Network Domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSegmentationNetworkDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_segmentation_network_domain** resource handles creation of [Transit Segmentation](https://docs.aviatrix.com/HowTos/transit_segmentation_faq.html) Network Domains.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Segmentation Network Domain
        test_segmentation_network_domain = aviatrix.AviatrixSegmentationNetworkDomain("testSegmentationNetworkDomain", domain_name="domain-a")
        ```

        ## Import

        **aviatrix_segmentation_network_domain** can be imported using the `domain_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSegmentationNetworkDomain:AviatrixSegmentationNetworkDomain test domain_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixSegmentationNetworkDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSegmentationNetworkDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSegmentationNetworkDomainArgs.__new__(AviatrixSegmentationNetworkDomainArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
        super(AviatrixSegmentationNetworkDomain, __self__).__init__(
            'aviatrix:index/aviatrixSegmentationNetworkDomain:AviatrixSegmentationNetworkDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixSegmentationNetworkDomain':
        """
        Get an existing AviatrixSegmentationNetworkDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: Name of the Network Domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSegmentationNetworkDomainState.__new__(_AviatrixSegmentationNetworkDomainState)

        __props__.__dict__["domain_name"] = domain_name
        return AviatrixSegmentationNetworkDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Name of the Network Domain.
        """
        return pulumi.get(self, "domain_name")

