# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwTransitGatewayAttachmentArgs', 'AviatrixAwsTgwTransitGatewayAttachment']

@pulumi.input_type
class AviatrixAwsTgwTransitGatewayAttachmentArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 transit_gateway_name: pulumi.Input[str],
                 vpc_account_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixAwsTgwTransitGatewayAttachment resource.
        :param pulumi.Input[str] region: AWS Region of the TGW.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] transit_gateway_name: Name of the transit gateway to be attached to the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the VPC, where transit gateway is launched.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "tgw_name", tgw_name)
        pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)
        pulumi.set(__self__, "vpc_account_name", vpc_account_name)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        AWS Region of the TGW.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Input[str]:
        """
        Name of the transit gateway to be attached to the AWS TGW.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name", value)

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> pulumi.Input[str]:
        """
        The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        """
        return pulumi.get(self, "vpc_account_name")

    @vpc_account_name.setter
    def vpc_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_account_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the VPC, where transit gateway is launched.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _AviatrixAwsTgwTransitGatewayAttachmentState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwTransitGatewayAttachment resources.
        :param pulumi.Input[str] region: AWS Region of the TGW.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] transit_gateway_name: Name of the transit gateway to be attached to the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the VPC, where transit gateway is launched.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)
        if transit_gateway_name is not None:
            pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)
        if vpc_account_name is not None:
            pulumi.set(__self__, "vpc_account_name", vpc_account_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Region of the TGW.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the transit gateway to be attached to the AWS TGW.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name", value)

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        """
        return pulumi.get(self, "vpc_account_name")

    @vpc_account_name.setter
    def vpc_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_account_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID of the VPC, where transit gateway is launched.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixAwsTgwTransitGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_aws_tgw_transit_gateway_attachment** resource manages the attachment of the Aviatrix transit gateway to the AWS TGW.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS TGW Transit Gateway Attachment
        test_transit_gateway_attachment = aviatrix.AviatrixAwsTgwTransitGatewayAttachment("testTransitGatewayAttachment",
            region="us-east-1",
            tgw_name="test-tgw",
            transit_gateway_name="transit-gw-1",
            vpc_account_name="test-account",
            vpc_id="vpc-0e2fac2b91c6697b3")
        ```

        ## Import

        **aws_tgw_transit_gateway_attachment** can be imported using the `tgw_name` and `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwTransitGatewayAttachment:AviatrixAwsTgwTransitGatewayAttachment test tgw_name~vpc_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] region: AWS Region of the TGW.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] transit_gateway_name: Name of the transit gateway to be attached to the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the VPC, where transit gateway is launched.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwTransitGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_aws_tgw_transit_gateway_attachment** resource manages the attachment of the Aviatrix transit gateway to the AWS TGW.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS TGW Transit Gateway Attachment
        test_transit_gateway_attachment = aviatrix.AviatrixAwsTgwTransitGatewayAttachment("testTransitGatewayAttachment",
            region="us-east-1",
            tgw_name="test-tgw",
            transit_gateway_name="transit-gw-1",
            vpc_account_name="test-account",
            vpc_id="vpc-0e2fac2b91c6697b3")
        ```

        ## Import

        **aws_tgw_transit_gateway_attachment** can be imported using the `tgw_name` and `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwTransitGatewayAttachment:AviatrixAwsTgwTransitGatewayAttachment test tgw_name~vpc_id
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwTransitGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwTransitGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwTransitGatewayAttachmentArgs.__new__(AviatrixAwsTgwTransitGatewayAttachmentArgs)

            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
            if transit_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name'")
            __props__.__dict__["transit_gateway_name"] = transit_gateway_name
            if vpc_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_account_name'")
            __props__.__dict__["vpc_account_name"] = vpc_account_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixAwsTgwTransitGatewayAttachment, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwTransitGatewayAttachment:AviatrixAwsTgwTransitGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None,
            transit_gateway_name: Optional[pulumi.Input[str]] = None,
            vpc_account_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwTransitGatewayAttachment':
        """
        Get an existing AviatrixAwsTgwTransitGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] region: AWS Region of the TGW.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] transit_gateway_name: Name of the transit gateway to be attached to the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the VPC, where transit gateway is launched.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwTransitGatewayAttachmentState.__new__(_AviatrixAwsTgwTransitGatewayAttachmentState)

        __props__.__dict__["region"] = region
        __props__.__dict__["tgw_name"] = tgw_name
        __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        __props__.__dict__["vpc_account_name"] = vpc_account_name
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixAwsTgwTransitGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        AWS Region of the TGW.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Output[str]:
        """
        Name of the transit gateway to be attached to the AWS TGW.
        """
        return pulumi.get(self, "transit_gateway_name")

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> pulumi.Output[str]:
        """
        The name of the cloud account in the Aviatrix controller, which is associated with the VPC.
        """
        return pulumi.get(self, "vpc_account_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID of the VPC, where transit gateway is launched.
        """
        return pulumi.get(self, "vpc_id")

