# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwSecurityDomainInitArgs', 'AviatrixAwsTgwSecurityDomain']

@pulumi.input_type
class AviatrixAwsTgwSecurityDomainInitArgs:
    def __init__(__self__, *,
                 tgw_name: pulumi.Input[str],
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwSecurityDomain resource.
        :param pulumi.Input[str] tgw_name: The AWS TGW name of the security domain.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] name: The name of the security domain.
        :param pulumi.Input[bool] native_egress: Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] native_firewall: Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        pulumi.set(__self__, "tgw_name", tgw_name)
        if aviatrix_firewall is not None:
            pulumi.set(__self__, "aviatrix_firewall", aviatrix_firewall)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_egress is not None:
            pulumi.set(__self__, "native_egress", native_egress)
        if native_firewall is not None:
            pulumi.set(__self__, "native_firewall", native_firewall)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        The AWS TGW name of the security domain.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @aviatrix_firewall.setter
    def aviatrix_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firewall", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_egress")

    @native_egress.setter
    def native_egress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_egress", value)

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_firewall")

    @native_firewall.setter
    def native_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_firewall", value)


@pulumi.input_type
class _AviatrixAwsTgwSecurityDomainState:
    def __init__(__self__, *,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwSecurityDomain resources.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] name: The name of the security domain.
        :param pulumi.Input[bool] native_egress: Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] native_firewall: Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        :param pulumi.Input[str] tgw_name: The AWS TGW name of the security domain.
        """
        if aviatrix_firewall is not None:
            pulumi.set(__self__, "aviatrix_firewall", aviatrix_firewall)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_egress is not None:
            pulumi.set(__self__, "native_egress", native_egress)
        if native_firewall is not None:
            pulumi.set(__self__, "native_firewall", native_firewall)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @aviatrix_firewall.setter
    def aviatrix_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firewall", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_egress")

    @native_egress.setter
    def native_egress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_egress", value)

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_firewall")

    @native_firewall.setter
    def native_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_firewall", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS TGW name of the security domain.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgwSecurityDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        !> **WARNING:** Resource **aviatrix_aws_tgw_security_domain** will be deprecated in future releases. Please use resource **aviatrix_aws_tgw_network_domain** instead.

        The **aviatrix_aws_tgw_security_domain** resource allows the creation and management of Aviatrix security domains.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS TGW security domain
        test_aws_tgw = aviatrix.AviatrixAwsTgw("testAwsTgw",
            account_name="devops",
            aws_side_as_number="64512",
            region="us-east-1",
            tgw_name="test-AWS-TGW",
            manage_security_domain=False,
            manage_vpc_attachment=False,
            manage_transit_gateway_attachment=False)
        default_domain = aviatrix.AviatrixAwsTgwSecurityDomain("defaultDomain", tgw_name=test_aws_tgw.tgw_name)
        shared_service_domain = aviatrix.AviatrixAwsTgwSecurityDomain("sharedServiceDomain", tgw_name=test_aws_tgw.tgw_name)
        aviatrix_edge_domain = aviatrix.AviatrixAwsTgwSecurityDomain("aviatrixEdgeDomain", tgw_name=test_aws_tgw.tgw_name)
        default_sd_conn1 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn1",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=aviatrix_edge_domain.name,
            domain_name2=default_domain.name)
        default_sd_conn2 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn2",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=aviatrix_edge_domain.name,
            domain_name2=shared_service_domain.name)
        default_sd_conn3 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn3",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=default_domain.name,
            domain_name2=shared_service_domain.name)
        test = aviatrix.AviatrixAwsTgwSecurityDomain("test", tgw_name=test_aws_tgw.tgw_name,
        opts=pulumi.ResourceOptions(depends_on=[
                default_domain,
                shared_service_domain,
                aviatrix_edge_domain,
            ]))
        ```

        ## Import

        **aws_tgw_security_domain** can be imported using the `name` and `tgw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwSecurityDomain:AviatrixAwsTgwSecurityDomain test tgw_name~name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] name: The name of the security domain.
        :param pulumi.Input[bool] native_egress: Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] native_firewall: Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        :param pulumi.Input[str] tgw_name: The AWS TGW name of the security domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwSecurityDomainInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **WARNING:** Resource **aviatrix_aws_tgw_security_domain** will be deprecated in future releases. Please use resource **aviatrix_aws_tgw_network_domain** instead.

        The **aviatrix_aws_tgw_security_domain** resource allows the creation and management of Aviatrix security domains.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS TGW security domain
        test_aws_tgw = aviatrix.AviatrixAwsTgw("testAwsTgw",
            account_name="devops",
            aws_side_as_number="64512",
            region="us-east-1",
            tgw_name="test-AWS-TGW",
            manage_security_domain=False,
            manage_vpc_attachment=False,
            manage_transit_gateway_attachment=False)
        default_domain = aviatrix.AviatrixAwsTgwSecurityDomain("defaultDomain", tgw_name=test_aws_tgw.tgw_name)
        shared_service_domain = aviatrix.AviatrixAwsTgwSecurityDomain("sharedServiceDomain", tgw_name=test_aws_tgw.tgw_name)
        aviatrix_edge_domain = aviatrix.AviatrixAwsTgwSecurityDomain("aviatrixEdgeDomain", tgw_name=test_aws_tgw.tgw_name)
        default_sd_conn1 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn1",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=aviatrix_edge_domain.name,
            domain_name2=default_domain.name)
        default_sd_conn2 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn2",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=aviatrix_edge_domain.name,
            domain_name2=shared_service_domain.name)
        default_sd_conn3 = aviatrix.AviatrixAwsTgwSecurityDomainConn("defaultSdConn3",
            tgw_name=test_aws_tgw.tgw_name,
            domain_name1=default_domain.name,
            domain_name2=shared_service_domain.name)
        test = aviatrix.AviatrixAwsTgwSecurityDomain("test", tgw_name=test_aws_tgw.tgw_name,
        opts=pulumi.ResourceOptions(depends_on=[
                default_domain,
                shared_service_domain,
                aviatrix_edge_domain,
            ]))
        ```

        ## Import

        **aws_tgw_security_domain** can be imported using the `name` and `tgw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwSecurityDomain:AviatrixAwsTgwSecurityDomain test tgw_name~name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwSecurityDomainInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwSecurityDomainInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwSecurityDomainInitArgs.__new__(AviatrixAwsTgwSecurityDomainInitArgs)

            __props__.__dict__["aviatrix_firewall"] = aviatrix_firewall
            __props__.__dict__["name"] = name
            __props__.__dict__["native_egress"] = native_egress
            __props__.__dict__["native_firewall"] = native_firewall
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
        super(AviatrixAwsTgwSecurityDomain, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwSecurityDomain:AviatrixAwsTgwSecurityDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            native_egress: Optional[pulumi.Input[bool]] = None,
            native_firewall: Optional[pulumi.Input[bool]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwSecurityDomain':
        """
        Get an existing AviatrixAwsTgwSecurityDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] name: The name of the security domain.
        :param pulumi.Input[bool] native_egress: Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] native_firewall: Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        :param pulumi.Input[str] tgw_name: The AWS TGW name of the security domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwSecurityDomainState.__new__(_AviatrixAwsTgwSecurityDomainState)

        __props__.__dict__["aviatrix_firewall"] = aviatrix_firewall
        __props__.__dict__["name"] = name
        __props__.__dict__["native_egress"] = native_egress
        __props__.__dict__["native_firewall"] = native_firewall
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgwSecurityDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_egress")

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_firewall")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        The AWS TGW name of the security domain.
        """
        return pulumi.get(self, "tgw_name")

