// -*- coding: utf-8 -*-
// -*- mode: c++ -*-
// automatically generated by spyks, version $spyks_version
// model: $name
// version: $version
// description: $descr
#include <array>
#include <cmath>
#include <pybind11/pybind11.h>
#include <pybind11/numpy.h>
#include <pybind11/stl.h>
#include <boost/numeric/odeint.hpp>

namespace py = pybind11;
using namespace pybind11::literals;
namespace ode = boost::numeric::odeint;

template <class T>
inline constexpr T pow(T x, std::size_t n){
    return n>0 ? x * pow(x, n - 1):1;
}

namespace spyks {
	
// Nearest neighbor interpolator. Given a discretely sampled time series over
// [0, T) with a sampling interval of dt, returns the value closest to any input
// time t. Returns zero for all t < 0 and the last value in the time series for
// t >= T
template <typename value_t, typename time_t>
struct nn_interpolator {
        typedef value_t value_type;
        typedef time_t time_type;
        typedef typename py::array_t<value_type> array_type;

        nn_interpolator(array_type data, time_type dt)
                : data(data), dt(dt), N(data.shape(0)) {
		py::buffer_info buf = data.request();
		if (buf.ndim == 1) {
			data.resize({buf.shape[0], 1L});
		} else if (buf.ndim > 2) {
			throw std::runtime_error("array must have 2 dimensions or fewer");
		}
	}

        template<typename... Ix> value_type operator()(time_type t, Ix... idx) const {
                // TODO avoid numpy bounds check. There is an unchecked proxy
                // but I'm not sure how to hold a reference to it in the struct
                return data.at(index_at(t), idx...);
        }
        size_t index_at(time_type t) const {
                if (t < 0) return 0;
                size_t i = std::round(t / dt);
                return std::min(i, N - 1);
        }
	time_type get_max_time() const {
		return data.shape(0) * dt;
	}

        array_type data;
        time_type dt;
        size_t N;
};

template <typename Model>
struct pyarray_dense {
        typedef typename Model::state_type state_type;
        pyarray_dense(size_t nsteps)
                : nsteps(nsteps), step(0),
                  X(py::dtype::of<double>(), {nsteps, Model::N_STATE}) {}
        void operator()(state_type const & x, double time) {
                if (step < nsteps) {
                        double * dptr = static_cast<double *>(X.mutable_data(step));
                        std::copy_n(x.begin(), Model::N_STATE, dptr);
                }
                ++step;
        }
        const size_t nsteps;
        size_t step;
        py::array X;
};

}
