# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import mundiapi.models.credit_card_1
import mundiapi.models.debit_card_1
import mundiapi.models.boleto_1
import mundiapi.models.voucher
import mundiapi.models.create_split_request
import mundiapi.models.bank_transfer_1
import mundiapi.models.checkout
import mundiapi.models.customer_8
import mundiapi.models.create_cash_payment_request
import mundiapi.models.private_label
import mundiapi.models.pix

class Payment(object):

    """Implementation of the 'Payment' model.

    TODO: type model description here.

    Attributes:
        payment_method (string): Payment method
        credit_card (CreditCard1): TODO: type description here.
        debit_card (DebitCard1): TODO: type description here.
        boleto (Boleto1): TODO: type description here.
        currency (string): Currency. Must be informed using 3 characters
        voucher (Voucher): TODO: type description here.
        split (list of CreateSplitRequest): Splits
        bank_transfer (BankTransfer1): TODO: type description here.
        gateway_affiliation_id (string): Gateway affiliation code
        amount (int): The amount of the payment, in cents
        checkout (Checkout): TODO: type description here.
        customer_id (string): Customer Id
        customer (Customer8): TODO: type description here.
        metadata (dict<object, string>): Metadata
        cash (CreateCashPaymentRequest): TODO: type description here.
        private_label (PrivateLabel): TODO: type description here.
        pix (Pix): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_method":'payment_method',
        "private_label":'private_label',
        "credit_card":'credit_card',
        "debit_card":'debit_card',
        "boleto":'boleto',
        "currency":'currency',
        "voucher":'voucher',
        "split":'split',
        "bank_transfer":'bank_transfer',
        "gateway_affiliation_id":'gateway_affiliation_id',
        "amount":'amount',
        "checkout":'checkout',
        "customer_id":'customer_id',
        "customer":'customer',
        "metadata":'metadata',
        "cash":'cash',
        "pix":'pix'
    }

    def __init__(self,
                 payment_method=None,
                 private_label=None,
                 credit_card=None,
                 debit_card=None,
                 boleto=None,
                 currency=None,
                 voucher=None,
                 split=None,
                 bank_transfer=None,
                 gateway_affiliation_id=None,
                 amount=None,
                 checkout=None,
                 customer_id=None,
                 customer=None,
                 metadata=None,
                 cash=None,
                 pix=None):
        """Constructor for the Payment class"""

        # Initialize members of the class
        self.payment_method = payment_method
        self.credit_card = credit_card
        self.debit_card = debit_card
        self.boleto = boleto
        self.currency = currency
        self.voucher = voucher
        self.split = split
        self.bank_transfer = bank_transfer
        self.gateway_affiliation_id = gateway_affiliation_id
        self.amount = amount
        self.checkout = checkout
        self.customer_id = customer_id
        self.customer = customer
        self.metadata = metadata
        self.cash = cash
        self.private_label = private_label
        self.pix = pix


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_method = dictionary.get('payment_method')
        private_label = mundiapi.models.private_label.PrivateLabel.from_dictionary(dictionary.get('private_label')) if dictionary.get('private_label') else None
        credit_card = mundiapi.models.credit_card_1.CreditCard1.from_dictionary(dictionary.get('credit_card')) if dictionary.get('credit_card') else None
        debit_card = mundiapi.models.debit_card_1.DebitCard1.from_dictionary(dictionary.get('debit_card')) if dictionary.get('debit_card') else None
        boleto = mundiapi.models.boleto_1.Boleto1.from_dictionary(dictionary.get('boleto')) if dictionary.get('boleto') else None
        currency = dictionary.get('currency')
        voucher = mundiapi.models.voucher.Voucher.from_dictionary(dictionary.get('voucher')) if dictionary.get('voucher') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.create_split_request.CreateSplitRequest.from_dictionary(structure))
        bank_transfer = mundiapi.models.bank_transfer_1.BankTransfer1.from_dictionary(dictionary.get('bank_transfer')) if dictionary.get('bank_transfer') else None
        gateway_affiliation_id = dictionary.get('gateway_affiliation_id')
        amount = dictionary.get('amount')
        checkout = mundiapi.models.checkout.Checkout.from_dictionary(dictionary.get('checkout')) if dictionary.get('checkout') else None
        customer_id = dictionary.get('customer_id')
        customer = mundiapi.models.customer_8.Customer8.from_dictionary(dictionary.get('customer')) if dictionary.get('customer') else None
        metadata = dictionary.get('metadata')
        cash = mundiapi.models.create_cash_payment_request.CreateCashPaymentRequest.from_dictionary(dictionary.get('cash')) if dictionary.get('cash') else None
        pix = mundiapi.models.pix.Pix.from_dictionary(dictionary.get('pix')) if dictionary.get('pix') else None

        # Return an object of this model
        return cls(payment_method,
                   private_label,
                   credit_card,
                   debit_card,
                   boleto,
                   currency,
                   voucher,
                   split,
                   bank_transfer,
                   gateway_affiliation_id,
                   amount,
                   checkout,
                   customer_id,
                   customer,
                   metadata,
                   cash,
                   pix)


