# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from mundiapi.api_helper import APIHelper
import mundiapi.models.get_invoice_item_response
import mundiapi.models.customer
import mundiapi.models.charge
import mundiapi.models.billing_address
import mundiapi.models.get_subscription_response
import mundiapi.models.cycle
import mundiapi.models.shipping

class InvoicesMetadataResponse(object):

    """Implementation of the 'Invoices Metadata Response' model.

    TODO: type model description here.

    Attributes:
        id (string): TODO: type description here.
        code (string): TODO: type description here.
        url (string): TODO: type description here.
        amount (int): TODO: type description here.
        status (string): TODO: type description here.
        payment_method (string): TODO: type description here.
        created_at (datetime): TODO: type description here.
        items (list of GetInvoiceItemResponse): TODO: type description here.
        customer (Customer): TODO: type description here.
        charge (Charge): TODO: type description here.
        installments (int): TODO: type description here.
        billing_address (BillingAddress): TODO: type description here.
        subscription (GetSubscriptionResponse): TODO: type description here.
        cycle (Cycle): TODO: type description here.
        shipping (Shipping): TODO: type description here.
        metadata (dict<object, string>): TODO: type description here.
        due_at (datetime): TODO: type description here.
        canceled_at (datetime): TODO: type description here.
        billing_at (datetime): TODO: type description here.
        seen_at (datetime): TODO: type description here.
        total_discount (int): Total discounted value
        total_increment (int): Total discounted value
        subscription_id (string): Subscription Id

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id":'id',
        "code":'code',
        "url":'url',
        "amount":'amount',
        "status":'status',
        "payment_method":'payment_method',
        "created_at":'created_at',
        "items":'items',
        "charge":'charge',
        "installments":'installments',
        "billing_address":'billing_address',
        "subscription":'subscription',
        "shipping":'shipping',
        "metadata":'metadata',
        "subscription_id":'subscription_id',
        "customer":'customer',
        "cycle":'cycle',
        "due_at":'due_at',
        "canceled_at":'canceled_at',
        "billing_at":'billing_at',
        "seen_at":'seen_at',
        "total_discount":'total_discount',
        "total_increment":'total_increment'
    }

    def __init__(self,
                 id=None,
                 code=None,
                 url=None,
                 amount=None,
                 status=None,
                 payment_method=None,
                 created_at=None,
                 items=None,
                 charge=None,
                 installments=None,
                 billing_address=None,
                 subscription=None,
                 shipping=None,
                 metadata=None,
                 subscription_id=None,
                 customer=None,
                 cycle=None,
                 due_at=None,
                 canceled_at=None,
                 billing_at=None,
                 seen_at=None,
                 total_discount=None,
                 total_increment=None):
        """Constructor for the InvoicesMetadataResponse class"""

        # Initialize members of the class
        self.id = id
        self.code = code
        self.url = url
        self.amount = amount
        self.status = status
        self.payment_method = payment_method
        self.created_at = APIHelper.RFC3339DateTime(created_at) if created_at else None
        self.items = items
        self.customer = customer
        self.charge = charge
        self.installments = installments
        self.billing_address = billing_address
        self.subscription = subscription
        self.cycle = cycle
        self.shipping = shipping
        self.metadata = metadata
        self.due_at = APIHelper.RFC3339DateTime(due_at) if due_at else None
        self.canceled_at = APIHelper.RFC3339DateTime(canceled_at) if canceled_at else None
        self.billing_at = APIHelper.RFC3339DateTime(billing_at) if billing_at else None
        self.seen_at = APIHelper.RFC3339DateTime(seen_at) if seen_at else None
        self.total_discount = total_discount
        self.total_increment = total_increment
        self.subscription_id = subscription_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get('id')
        code = dictionary.get('code')
        url = dictionary.get('url')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        payment_method = dictionary.get('payment_method')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        items = None
        if dictionary.get('items') != None:
            items = list()
            for structure in dictionary.get('items'):
                items.append(mundiapi.models.get_invoice_item_response.GetInvoiceItemResponse.from_dictionary(structure))
        charge = mundiapi.models.charge.Charge.from_dictionary(dictionary.get('charge')) if dictionary.get('charge') else None
        installments = dictionary.get('installments')
        billing_address = mundiapi.models.billing_address.BillingAddress.from_dictionary(dictionary.get('billing_address')) if dictionary.get('billing_address') else None
        subscription = mundiapi.models.get_subscription_response.GetSubscriptionResponse.from_dictionary(dictionary.get('subscription')) if dictionary.get('subscription') else None
        shipping = mundiapi.models.shipping.Shipping.from_dictionary(dictionary.get('shipping')) if dictionary.get('shipping') else None
        metadata = dictionary.get('metadata')
        subscription_id = dictionary.get('subscription_id')
        customer = mundiapi.models.customer.Customer.from_dictionary(dictionary.get('customer')) if dictionary.get('customer') else None
        cycle = mundiapi.models.cycle.Cycle.from_dictionary(dictionary.get('cycle')) if dictionary.get('cycle') else None
        due_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("due_at")).datetime if dictionary.get("due_at") else None
        canceled_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("canceled_at")).datetime if dictionary.get("canceled_at") else None
        billing_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("billing_at")).datetime if dictionary.get("billing_at") else None
        seen_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("seen_at")).datetime if dictionary.get("seen_at") else None
        total_discount = dictionary.get('total_discount')
        total_increment = dictionary.get('total_increment')

        # Return an object of this model
        return cls(id,
                   code,
                   url,
                   amount,
                   status,
                   payment_method,
                   created_at,
                   items,
                   charge,
                   installments,
                   billing_address,
                   subscription,
                   shipping,
                   metadata,
                   subscription_id,
                   customer,
                   cycle,
                   due_at,
                   canceled_at,
                   billing_at,
                   seen_at,
                   total_discount,
                   total_increment)


