/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String escape(String code) {
        if (code == null) {
            return null;
        }
        String escapedCode = code.replaceAll("\"", "'");
        escapedCode = escapedCode.replaceAll("\n", " ");
        escapedCode = escapedCode.replaceAll("\r", " ");
        escapedCode = escapedCode.replaceAll("\\\\", "\\\\\\\\");
        return StringUtils.removeConsecutiveSpaces(escapedCode);
    }

    public static String removeConsecutiveSpaces(String str) {
        String before;
        while (!(before = str).equals(str = str.replace("   ", " "))) {
        }
        return str;
    }

    public static String escapeDoubleQuotes(String code) {
        return code == null ? null : code.replace("\"", "\\\"");
    }

    public static String toJsonArray(String[] strArray) {
        if (strArray == null) {
            return "null";
        }
        int max = strArray.length - 1;
        if (max == -1) {
            return "[]";
        }
        StringBuilder json = new StringBuilder();
        json.append('[');
        int i = 0;
        while (true) {
            json.append('\"').append(strArray[i]).append('\"');
            if (i == max) {
                return json.append(']').toString();
            }
            json.append(", ");
            ++i;
        }
    }

    public static String toGmlArray(String[] strArray, String name) {
        if (strArray == null) {
            return "null";
        }
        int max = strArray.length - 1;
        if (max == -1) {
            return "[]";
        }
        StringBuilder gml = new StringBuilder();
        gml.append('[');
        int i = 0;
        while (true) {
            gml.append(name).append(" \"").append(strArray[i]).append('\"');
            if (i == max) {
                return gml.append(']').toString();
            }
            gml.append(' ');
            ++i;
        }
    }
}

