/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis;

import codeintelligence.codeanalysis.Execution;
import codeintelligence.codeanalysis.utils.Logger;
import java.io.File;
import java.io.IOException;

public class Main {
    public static Execution parse(String[] args) {
        Execution exec = new Execution();
        block30: for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].length() > 3) {
                    String opt = args[i].substring(1).toLowerCase();
                    if (args[i].startsWith("--")) {
                        opt = args[i].substring(2).toLowerCase();
                    }
                    block11 : switch (opt) {
                        case "ast": {
                            exec.addAnalysisOption(Execution.Analysis.AST);
                            break;
                        }
                        case "cfg": {
                            exec.addAnalysisOption(Execution.Analysis.CFG);
                            break;
                        }
                        case "pdg": {
                            exec.addAnalysisOption(Execution.Analysis.PDG);
                            break;
                        }
                        case "info": {
                            exec.addAnalysisOption(Execution.Analysis.SRC_INFO);
                            break;
                        }
                        case "help": {
                            Main.printHelp(null);
                            break;
                        }
                        case "outdir": {
                            if (i < args.length - 1) {
                                if (exec.setOutputDirectory(args[++i])) continue block30;
                                Main.printHelp("Output directory is not valid!");
                                System.exit(1);
                                break;
                            }
                            Main.printHelp("Output directory not specified!");
                            System.exit(1);
                            break;
                        }
                        case "format": {
                            if (i < args.length - 1) {
                                switch (args[++i].toLowerCase()) {
                                    case "dot": {
                                        exec.setOutputFormat(Execution.Formats.DOT);
                                        break block11;
                                    }
                                    case "json": {
                                        exec.setOutputFormat(Execution.Formats.JSON);
                                        break block11;
                                    }
                                }
                                Main.printHelp("Unknown output format: " + args[i]);
                                System.exit(1);
                                break;
                            }
                            Main.printHelp("Format not specified!");
                            System.exit(1);
                            break;
                        }
                        case "debug": {
                            exec.setDebugMode(true);
                            Logger.setActiveLevel(Logger.Level.DEBUG);
                            break;
                        }
                        case "timetags": {
                            Logger.setTimeTagEnabled(true);
                            break;
                        }
                        default: {
                            Main.printHelp("Unknown Option: " + args[i]);
                            System.exit(1);
                        }
                    }
                    continue;
                }
                Main.printHelp("Invalid Option: " + args[i]);
                System.exit(1);
                continue;
            }
            File input = new File(args[i]);
            if (input.exists()) {
                exec.addInputPath(args[i]);
                continue;
            }
            Logger.warn("WARNING -- Ignoring non-existant input path: " + args[i]);
        }
        return exec;
    }

    public static Execution parse() {
        Execution exec = new Execution();
        exec.setOutputFormat(Execution.Formats.JSON);
        return exec;
    }

    public static void printHelp(String errMsg) {
        String[] help;
        if (errMsg != null && !errMsg.isEmpty()) {
            Logger.error("ERROR -- " + errMsg + "\n");
        }
        for (String line : help = new String[]{"USAGE:\n\n   java -jar PROGEX.jar [-OPTIONS...] /path/to/program/src\n", "OPTIONS:\n", "   -help      Print this help message", "   -outdir    Specify path of output directory", "   -format    Specify output format; either 'DOT', or 'JSON'", "   -ast       Perform AST (Abstract Syntax Tree) analysis", "   -cfg       Perfomt CFG (Control Flow Graph) analysis", "   -info      Analyze and extract detailed information about program source code", "   -pdg       Perform PDG (Program Dependence Graph) analysis\n", "   -debug     Enable more detailed logs (only for debugging)", "   -timetags  Enable time-tags and labels for logs (only for debugging)\n", "DEFAULTS:\n", "   - If not specified, the default output directory is the current working directory.", "   - If not specified, the default output format is DOT.", "   - There is no default value for analysis type.", "   - There is no default value for input directory path.\n", "NOTES:\n", "   - The important pre-assumption for analyzing any source code is that the ", "     program is valid according to the grammar of that language. Analyzing ", "     invalid programs has undefined results; most probably the program will ", "     crash!\n", "   - Analyzing large programs requires high volumes of system memory, so ", "     it is necessary to increase the maximum available memory to PROGEX.\n", "     In the example below, the -Xmx option of the JVM is used to provide PROGEX ", "     with 5 giga-bytes of system memory; which is required for the PDG analysis ", "     of very large programs (i.e. about one million LoC). Needless to say, this ", "     is possible on a computer with at least 8 giga-bytes of RAM:\n", "        java -Xmx5G -jar PROGEX.jar -pdg ...\n"}) {
            Logger.info(line);
        }
    }

    public static String getPDGJson(String code) throws IOException {
        Execution parse = Main.parse();
        if (code.length() == 0) {
            return "";
        }
        return parse.parsePdgToJson(code);
    }

    public static void main(String[] args) throws IOException {
        args = new String[]{"-ast", "-cfg", "-pdg", "-format", "json", "-outdir", "test_pdg", "-timetags", "test_pdg"};
        Logger.init();
        Logger.setEchoToStdOut(true);
        Logger.setTimeTagEnabled(false);
        Logger.setActiveLevel(Logger.Level.INFO);
        Main.parse(args).execute();
    }
}

