"""Константы"""

# Порт по умолчанию для сетевого взаимодействия
"""Константы"""

import logging

# Порт по умолчанию для сетевого ваимодействия
DEFAULT_PORT = 7777
# IP адрес по умолчанию для подключения клиента
DEFAULT_IP_ADDRESS = '127.0.0.1'
# Максимальная очередь подключений
MAX_CONNECTIONS = 5
# Максимальная длина сообщения в байтах
MAX_PACKAGE_LENGTH = 1024
# Кодировка проекта
ENCODING = 'utf-8'
# Текущий уровень логирования
LOGGING_LEVEL = logging.DEBUG
DATA = 'bin'
RESPONSE = 'response'
ERROR = 'error'
# Протокол JIM основные ключи:
ACTION = 'action'
TIME = 'time'
USER = 'user'
ACCOUNT_NAME = 'account_name'
SENDER = 'from'
DESTINATION = 'to'

# Прочие ключи, используемые в протоколе
PRESENCE = 'presence'
RESPONSE = 'response'
ERROR = 'error'
MESSAGE = 'message'
MESSAGE_TEXT = 'mess_text'
EXIT = 'exit'
LIST_INFO = 'data_list'


# Словари - ответы:
# 200
RESPONSE_200 = {RESPONSE: 200,
                'data' : None}
# 400
RESPONSE_400 = {
    RESPONSE: 400,
    ERROR: None
}
# Словари - ответы:
# 200

# 202
RESPONSE_202 = {RESPONSE: 202,
                LIST_INFO: None
                }

# 205
RESPONSE_215 = {
    RESPONSE: 215
}

# 511
RESPONSE_511 = {
    RESPONSE: 511,
    DATA: None
}

SERVER_DATABASE = 'sqlite3://server_base.db3'
