# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['avmp', 'avmp.core', 'avmp.tools', 'avmp.utils']

package_data = \
{'': ['*']}

install_requires = \
['click==7.1.2',
 'docopt>=0.6.2,<0.7.0',
 'jira==2.0.0',
 'pyTenable==1.2.6',
 'requests==2.25.1']

entry_points = \
{'console_scripts': ['avmp = avmp.core.cli: main']}

setup_kwargs = {
    'name': 'avmp',
    'version': '0.1.0',
    'description': 'Command line vulnerability program manager.',
    'long_description': '![Alt text](logo.png?raw=true "logo")\n\n# Automated Vulnerability Management Program (AVMP)\n\nA collection of tools for managing and automating vulnerability management.\n\nStreamline the way vulnerability management programs are created and run. This project is made to be modular so automation can be put into place at any program level.\n\n---\n\n## Table of Contents\n\n- [Things to Note](#things-to-note)\n- [Intallation](#installation)\n- [Running the tests](#running-the-tests)\n- [Deployment](#deployment)\n- [How to use](#how-to-use)\n  - [Folder Structure](#folder-structure-vulnmanager)\n  - [Main configuration file "config.json"](#main-configuration-file-configjson)\n  - [Dynamic process config "dynamic_process_config.json](#dynamic-process-config-dynamicprocessconfigjson)\n  - [Static process config "static_process_config.json"](#static-process-config-staticprocessconfigjson)\n- [TO-DO](#to-do)\n- [Authors](#authors)\n- [License](#license)\n\n---\n\n## Things to Note\n\n1. **API keys for both Tenable IO and Jira are required.**\n\n2. I developed this tool using Jira on-prem and assume it would work for the cloud version as well however am unable to verify that.\n\n3. There is a bit of setup to use the tool as it is in development, I am planning on creating a quick start script but until then please see [How to use](#how-to-use).\n\n## Installation\n\n```\npip install git+https://github.com/RackReaver/AVMP\n```\n\n## Running the tests\n\nCheck code coverage\n\n```\n>>> coverage run -m pytest\n>>>\n>>> coverage report\n```\n\n## Deployment\n\nAt this time the tool can only be deployed locally.\n\n## How to use\n\n```\n$ avmp --help\n      __      ____  __ _____\n     /\\ \\    / /  \\/  |  __ \\\n    /  \\ \\  / /| \\  / | |__) |\n   / /\\ \\ \\/ / | |\\/| |  ___/\n  / ____ \\  /  | |  | | |\n /_/    \\_\\/   |_|  |_|_|\n\nA collection of tools for managing and automating vulnerability management.\n\nUsage:\n    avmp run [--config filepath] <process_config>\n    avmp update [--config filepath] <ticket_db_filepath>\n    avmp -h | --help\n    avmp --version\n\nOptions:\n    -h --help           Show this screen.\n    --version           Show version.\n    --config=filepath   AVMP configuration file [default: config.json]\n```\n\n#### Folder Structure `vuln_manager`:\n\n```\nvuln_manager\n|\n+-- process_configs\n|  |\n|  +-- dynamic/     # Configurations for generating vulnerability tickets\n|  +-- static/      # Configurations for generating repetitive project/task tickets\n|\n+-- config.json\n+-- tickets.db      # This is generated automatically and is mapped to in the process_configs\n```\n\n#### Main configuration file `config.json`:\n\n```json\n{\n    "creds": {\n        "tenable": {\n            "access_key": "",\n            "secret_key": ""\n        },\n        "jira": {\n            "server": "",\n            "username": "",\n            "password": ""\n        }\n    },\n    "types": {\n        "JIRA_PROJECT_ID": ["JIRA_FIELD_1", "JIRA_FIELD_2", "JIRA_FIELD_3"]\n    },\n    "due_dates": {\n        "Critical": "DAYS_TO_PATCH",\n        "High": "DAYS_TO_PATCH",\n        "Medium": "DAYS_TO_PATCH",\n        "Low": "DAYS_TO_PATCH",\n    },\n    "priorities": {\n        "Critical": "JIRA_ID",\n        "High": "JIRA_ID",\n        "Medium": "JIRA_ID",\n        "Low": "JIRA_ID"\n}\n```\n\n| Field      | Required | Description                                                                                                                                                          |\n| ---------- | -------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| creds      | yes      | Data required from APIs to run package                                                                                                                               |\n| types      | no       | List of required fields for a given Jira project (not required, but a good idea to ensure process_configs contain all required fields before making an API request). |\n| due_dates  | yes      | Used to set Jira due date based on Tenable\'s severity rating.                                                                                                        |\n| priorities | yes      | Mapping Tenable severity rating to Jira priorities (defaults to `Low` if others are unavailable).                                                                    |\n\n#### Dynamic process config `dynamic_process_config.json`:\n\nSee [examples](examples/dynamic_process_configs) for context on use cases.\n\n```json\n{\n  "process_type": "dynamic",\n  "allow_ticket_duplication": "False",\n  "scan_name": "TENABLE_SCAN_NAME",\n  "max_tickets": 10,\n  "assignee": "",\n  "min_cvss_score": 6.0,\n  "ticket_db_filepath": "tickets.db",\n  "default_ticket_status": "Open",\n  "time_saved_per_ticket": "10m",\n  "root_ticket": "",\n  "comments": [],\n  "data": {\n    "project": { "key": "JIRA_PROJECT_KEY" },\n    "summary": "Vuln: ",\n    "description": "",\n    "issuetype": { "id": "JIRA_ISSUE_TYPE_ID" },\n    "priority": { "id": "" },\n    "duedate": ""\n  }\n}\n```\n\n| Field                    | Required | Description                                                                                                                        |\n| ------------------------ | -------- | ---------------------------------------------------------------------------------------------------------------------------------- |\n| process_type             | yes      | Must be `dynamic`                                                                                                                  |\n| allow_ticket_duplication | no       | [default: false] Prevent multiple tickets for same plugin_id to be generated (This is based on the `ticket_db_filepath` provided). |\n| scan_name                | yes      | Name of scan inside of Tenable IO                                                                                                  |\n| max_tickets              | no       | Number of tickets to be created each time this configuration is used (optional - will create all if value is blank).               |\n| assignee                 | no       | Username to assign all created tickets to (optional).                                                                              |\n| min_cvss_score           | yes      | This is based on the CVSS Base Score provided by Tenable IO, allows for configurations based on severity.                          |\n| ticket_db_filepath       | yes      | Location of SQLite database file for tracking tickets (DB will be created if ones doesn\'t already exist on the path provided).     |\n| default_ticket_status    | yes      | First status for database entry, this will change when the auto updater is run.                                                    |\n| time_saved_per_ticket    | yes      | Jira time value to log work for calculating time saved.                                                                            |\n| root_ticket              | no       | If unable to log work against newly created ticket this value will provide a ticket that allows work to be logged against it.      |\n| comments                 | no       | A list of strings that will generate comments.                                                                                     |\n| data                     | yes      | API values required to generate a Jira ticket (issue).                                                                             |\n\n#### Static process config `static_process_config.json`:\n\nSee [examples](examples/static_process_configs) for context on use cases.\n\n```json\n{\n  "process_type": "static",\n  "time_saved_per_ticket": "5m",\n  "time_saved_comment": "Time saved through automation",\n  "parent_ticket": {\n    "project": { "key": "JIRA_PROJECT_KEY" },\n    "summary": "SUMMARY",\n    "description": "DESCRIPTION",\n    "issuetype": { "name": "ISSUE_TYPE_NAME" },\n    "assignee": { "name": "" },\n    "priority": { "id": "PRIORITY_ID" }\n  },\n  "sub_tasks": {\n    "sub_task_1": {\n      "project": { "key": "JIRA_PROJECT_KEY" },\n      "summary": "SUMMARY",\n      "description": "DESCRIPTION",\n      "issuetype": { "name": "Sub-task" },\n      "assignee": { "name": "" }\n    },\n    "sub_task_2": {\n      "project": { "key": "JIRA_PROJECT_KEY" },\n      "summary": "SUMMARY",\n      "description": "DESCRIPTION",\n      "issuetype": { "name": "Sub-task" },\n      "assignee": { "name": "" }\n    }\n  }\n}\n```\n\n| Field Name            | Required | Description                                                                  |\n| --------------------- | -------- | ---------------------------------------------------------------------------- |\n| process_name          | yes      | Must be `static`                                                             |\n| time_saved_per_ticket | no       | Jira time value to log work for calculating time saved.                      |\n| time_saved_comment    | no       | Comment for Jira work log for time saved.                                    |\n| parent_ticket         | yes      | API values required to generate a Jira ticket (issue).                       |\n| sub_tasks             | no       | JSON container for any sub tasks that should be created under parent ticket. |\n\n## TO-DO\n\n- Add persistent logging to wrapper.main() as a return value\n- Add ticket reference table to database\n  - Track project and process ticket numbers for automated linking\n- Add support for [SecurityScorecard](https://securityscorecard.com/)\n- Build tests for code base\n- [x]Add example dynamic and static process configs\n- Add database tracking of static_process tickets\n\n## Authors\n\n- **Matt Ferreira** - _Developer_ - [RackReaver](https://github.com/RackReaver)\n\n## License\n\nThis project is licensed under the Apache License - see the [LICENSE](LICENSE) file for details\n',
    'author': 'RackReaver',
    'author_email': 'rackreaver@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/RackReaver/AVMP',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
