# Generated by Django 2.2.11 on 2020-03-23 16:33

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('pulp_2to3_migration', '0003_pulp2lazycatalog_indices'),
    ]

    operations = [
        migrations.AddField(
            model_name='pulp2content',
            name='pulp2_repo',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='pulp_2to3_migration.Pulp2Repository'),
        ),
        migrations.AlterUniqueTogether(
            name='pulp2content',
            unique_together={('pulp2_id', 'pulp2_content_type_id', 'pulp2_repo')},
        ),
        migrations.CreateModel(
            name='Pulp2YumRepoMetadataFile',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('data_type', models.CharField(max_length=20)),
                ('checksum', models.CharField(max_length=128)),
                ('checksum_type', models.CharField(max_length=6)),
                ('repo_id', models.TextField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='yum_repo_metadata_file_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'yum_repo_metadata_file_detail_model',
                'unique_together': {('data_type', 'repo_id', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2Rpm',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.TextField()),
                ('epoch', models.TextField()),
                ('version', models.TextField()),
                ('release', models.TextField()),
                ('arch', models.TextField()),
                ('checksum', models.TextField()),
                ('checksumtype', models.TextField()),
                ('repodata', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('is_modular', models.BooleanField(default=False)),
                ('size', models.PositiveIntegerField()),
                ('filename', models.TextField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='rpm_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'rpm_detail_model',
                'unique_together': {('name', 'epoch', 'version', 'release', 'arch', 'checksumtype', 'checksum', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2ModulemdDefaults',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('module', models.TextField()),
                ('stream', models.TextField()),
                ('profiles', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('digest', models.TextField()),
                ('repo_id', models.TextField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='modulemd_defaults_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'modulemd_defaults_detail_model',
                'unique_together': {('digest', 'repo_id', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2Modulemd',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.TextField()),
                ('stream', models.TextField()),
                ('version', models.BigIntegerField()),
                ('context', models.TextField()),
                ('arch', models.TextField()),
                ('artifacts', django.contrib.postgres.fields.jsonb.JSONField()),
                ('checksum', models.TextField()),
                ('dependencies', django.contrib.postgres.fields.jsonb.JSONField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='modulemd_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'modulemd_detail_model',
                'unique_together': {('name', 'stream', 'version', 'context', 'arch', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2Erratum',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('errata_id', models.TextField()),
                ('updated', models.TextField()),
                ('repo_id', models.TextField()),
                ('issued', models.TextField()),
                ('status', models.TextField()),
                ('description', models.TextField()),
                ('pushcount', models.TextField()),
                ('references', django.contrib.postgres.fields.jsonb.JSONField()),
                ('reboot_suggested', models.BooleanField()),
                ('relogin_suggested', models.BooleanField()),
                ('restart_suggested', models.BooleanField()),
                ('errata_from', models.TextField()),
                ('severity', models.TextField()),
                ('rights', models.TextField()),
                ('version', models.TextField()),
                ('release', models.TextField()),
                ('errata_type', models.TextField()),
                ('pkglist', django.contrib.postgres.fields.jsonb.JSONField()),
                ('title', models.TextField()),
                ('solution', models.TextField()),
                ('summary', models.TextField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='erratum_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'erratum_detail_model',
                'unique_together': {('errata_id', 'repo_id')},
            },
        ),
    ]
