# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.45.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class HaikuDeliveryOrder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'delivery_order_code': 'str',
        'delivery_order_id': 'str',
        'warehouse_code': 'str',
        'order_type': 'str',
        'status': 'str',
        'out_biz_code': 'str',
        'confirm_type': 'str',
        'order_confirm_time': 'str',
        'operator_code': 'str',
        'operator_name': 'str',
        'operate_time': 'str',
        'storage_fee': 'str',
        'logistics_code': 'str',
        'logistics_name': 'str',
        'express_code': 'str'
    }

    attribute_map = {
        'delivery_order_code': 'deliveryOrderCode',
        'delivery_order_id': 'deliveryOrderId',
        'warehouse_code': 'warehouseCode',
        'order_type': 'orderType',
        'status': 'status',
        'out_biz_code': 'outBizCode',
        'confirm_type': 'confirmType',
        'order_confirm_time': 'orderConfirmTime',
        'operator_code': 'operatorCode',
        'operator_name': 'operatorName',
        'operate_time': 'operateTime',
        'storage_fee': 'storageFee',
        'logistics_code': 'logisticsCode',
        'logistics_name': 'logisticsName',
        'express_code': 'expressCode'
    }

    def __init__(self, delivery_order_code=None, delivery_order_id=None, warehouse_code=None, order_type=None, status=None, out_biz_code=None, confirm_type=None, order_confirm_time=None, operator_code=None, operator_name=None, operate_time=None, storage_fee=None, logistics_code=None, logistics_name=None, express_code=None, local_vars_configuration=None):  # noqa: E501
        """HaikuDeliveryOrder - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._delivery_order_code = None
        self._delivery_order_id = None
        self._warehouse_code = None
        self._order_type = None
        self._status = None
        self._out_biz_code = None
        self._confirm_type = None
        self._order_confirm_time = None
        self._operator_code = None
        self._operator_name = None
        self._operate_time = None
        self._storage_fee = None
        self._logistics_code = None
        self._logistics_name = None
        self._express_code = None
        self.discriminator = None

        if delivery_order_code is not None:
            self.delivery_order_code = delivery_order_code
        if delivery_order_id is not None:
            self.delivery_order_id = delivery_order_id
        if warehouse_code is not None:
            self.warehouse_code = warehouse_code
        if order_type is not None:
            self.order_type = order_type
        if status is not None:
            self.status = status
        if out_biz_code is not None:
            self.out_biz_code = out_biz_code
        if confirm_type is not None:
            self.confirm_type = confirm_type
        if order_confirm_time is not None:
            self.order_confirm_time = order_confirm_time
        if operator_code is not None:
            self.operator_code = operator_code
        if operator_name is not None:
            self.operator_name = operator_name
        if operate_time is not None:
            self.operate_time = operate_time
        if storage_fee is not None:
            self.storage_fee = storage_fee
        if logistics_code is not None:
            self.logistics_code = logistics_code
        if logistics_name is not None:
            self.logistics_name = logistics_name
        if express_code is not None:
            self.express_code = express_code

    @property
    def delivery_order_code(self):
        """Gets the delivery_order_code of this HaikuDeliveryOrder.  # noqa: E501

        ERP order no  # noqa: E501

        :return: The delivery_order_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._delivery_order_code

    @delivery_order_code.setter
    def delivery_order_code(self, delivery_order_code):
        """Sets the delivery_order_code of this HaikuDeliveryOrder.

        ERP order no  # noqa: E501

        :param delivery_order_code: The delivery_order_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._delivery_order_code = delivery_order_code

    @property
    def delivery_order_id(self):
        """Gets the delivery_order_id of this HaikuDeliveryOrder.  # noqa: E501

        Warehouse delivery order no  # noqa: E501

        :return: The delivery_order_id of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._delivery_order_id

    @delivery_order_id.setter
    def delivery_order_id(self, delivery_order_id):
        """Sets the delivery_order_id of this HaikuDeliveryOrder.

        Warehouse delivery order no  # noqa: E501

        :param delivery_order_id: The delivery_order_id of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._delivery_order_id = delivery_order_id

    @property
    def warehouse_code(self):
        """Gets the warehouse_code of this HaikuDeliveryOrder.  # noqa: E501

        warehouse code  # noqa: E501

        :return: The warehouse_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_code

    @warehouse_code.setter
    def warehouse_code(self, warehouse_code):
        """Sets the warehouse_code of this HaikuDeliveryOrder.

        warehouse code  # noqa: E501

        :param warehouse_code: The warehouse_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._warehouse_code = warehouse_code

    @property
    def order_type(self):
        """Gets the order_type of this HaikuDeliveryOrder.  # noqa: E501

        order type  # noqa: E501

        :return: The order_type of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this HaikuDeliveryOrder.

        order type  # noqa: E501

        :param order_type: The order_type of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._order_type = order_type

    @property
    def status(self):
        """Gets the status of this HaikuDeliveryOrder.  # noqa: E501


        :return: The status of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this HaikuDeliveryOrder.


        :param status: The status of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def out_biz_code(self):
        """Gets the out_biz_code of this HaikuDeliveryOrder.  # noqa: E501


        :return: The out_biz_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._out_biz_code

    @out_biz_code.setter
    def out_biz_code(self, out_biz_code):
        """Sets the out_biz_code of this HaikuDeliveryOrder.


        :param out_biz_code: The out_biz_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._out_biz_code = out_biz_code

    @property
    def confirm_type(self):
        """Gets the confirm_type of this HaikuDeliveryOrder.  # noqa: E501


        :return: The confirm_type of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._confirm_type

    @confirm_type.setter
    def confirm_type(self, confirm_type):
        """Sets the confirm_type of this HaikuDeliveryOrder.


        :param confirm_type: The confirm_type of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._confirm_type = confirm_type

    @property
    def order_confirm_time(self):
        """Gets the order_confirm_time of this HaikuDeliveryOrder.  # noqa: E501


        :return: The order_confirm_time of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._order_confirm_time

    @order_confirm_time.setter
    def order_confirm_time(self, order_confirm_time):
        """Sets the order_confirm_time of this HaikuDeliveryOrder.


        :param order_confirm_time: The order_confirm_time of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._order_confirm_time = order_confirm_time

    @property
    def operator_code(self):
        """Gets the operator_code of this HaikuDeliveryOrder.  # noqa: E501


        :return: The operator_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._operator_code

    @operator_code.setter
    def operator_code(self, operator_code):
        """Sets the operator_code of this HaikuDeliveryOrder.


        :param operator_code: The operator_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._operator_code = operator_code

    @property
    def operator_name(self):
        """Gets the operator_name of this HaikuDeliveryOrder.  # noqa: E501


        :return: The operator_name of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._operator_name

    @operator_name.setter
    def operator_name(self, operator_name):
        """Sets the operator_name of this HaikuDeliveryOrder.


        :param operator_name: The operator_name of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._operator_name = operator_name

    @property
    def operate_time(self):
        """Gets the operate_time of this HaikuDeliveryOrder.  # noqa: E501


        :return: The operate_time of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._operate_time

    @operate_time.setter
    def operate_time(self, operate_time):
        """Sets the operate_time of this HaikuDeliveryOrder.


        :param operate_time: The operate_time of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._operate_time = operate_time

    @property
    def storage_fee(self):
        """Gets the storage_fee of this HaikuDeliveryOrder.  # noqa: E501


        :return: The storage_fee of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._storage_fee

    @storage_fee.setter
    def storage_fee(self, storage_fee):
        """Sets the storage_fee of this HaikuDeliveryOrder.


        :param storage_fee: The storage_fee of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._storage_fee = storage_fee

    @property
    def logistics_code(self):
        """Gets the logistics_code of this HaikuDeliveryOrder.  # noqa: E501


        :return: The logistics_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._logistics_code

    @logistics_code.setter
    def logistics_code(self, logistics_code):
        """Sets the logistics_code of this HaikuDeliveryOrder.


        :param logistics_code: The logistics_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._logistics_code = logistics_code

    @property
    def logistics_name(self):
        """Gets the logistics_name of this HaikuDeliveryOrder.  # noqa: E501


        :return: The logistics_name of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._logistics_name

    @logistics_name.setter
    def logistics_name(self, logistics_name):
        """Sets the logistics_name of this HaikuDeliveryOrder.


        :param logistics_name: The logistics_name of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._logistics_name = logistics_name

    @property
    def express_code(self):
        """Gets the express_code of this HaikuDeliveryOrder.  # noqa: E501


        :return: The express_code of this HaikuDeliveryOrder.  # noqa: E501
        :rtype: str
        """
        return self._express_code

    @express_code.setter
    def express_code(self, express_code):
        """Sets the express_code of this HaikuDeliveryOrder.


        :param express_code: The express_code of this HaikuDeliveryOrder.  # noqa: E501
        :type: str
        """

        self._express_code = express_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HaikuDeliveryOrder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HaikuDeliveryOrder):
            return True

        return self.to_dict() != other.to_dict()
