# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyfinra', 'pyfinra.financials', 'pyfinra.tools']

package_data = \
{'': ['*']}

install_requires = \
['finsymbols>=1.3.0,<2.0.0',
 'pandas>=1.2.3,<2.0.0',
 'requests>=2.25.1,<3.0.0',
 'selenium>=3.141.0,<4.0.0']

setup_kwargs = {
    'name': 'pyfinra',
    'version': '0.1.10',
    'description': 'Unoffical Python Finra Wrapper',
    'long_description': '# Unoffical Python Finra Wrapper\n\n**warning this repository is still in alpha stage**\n\n## Requirements\n\n- Chromium\n- Chromedriver\n\n## Installation\n\n### PIP\n\n```Bash\npip install pyfinra\n```\n\n### Build your self with Python-Poetry\n\n```Bash\npoetry install\npoetry build\n```\n\n## Example\n\n```Python\n\nfrom pyfinra import Ticker\n\n\ngme = Ticker("Gme")\nprint(gme.quote())\nprint(gme.financials_balancesheet())\nprint(gme.financials_inc_statement())\nprint(gme.financials_cash_flow())\nprint(gme.financials_balancesheet(True))\nprint(gme.financials_inc_statement(True))\nprint(gme.financials_cash_flow(True))\n\n# {\'P/E\': \'-103.0928\', \'market_cap\': \'11286683155\', \'shares\': \'70771778\', \'short_interest\': \'27.2334\', \'currency\': \'USD\', \'P/S\': \'2.036662\', \'P/B\': \'25.845393\', \'P/CF\': \'83.801132\', \'exchange\': \'XNYS\'}\n#                                                     2017-01  2018-01  2019-01  2020-01  2021-01\n# Fiscal year ends in January. USD in millions ex...\n# Assets                                                  NaN      NaN      NaN      NaN      NaN\n# Current assets                                          NaN      NaN      NaN      NaN      NaN\n# Cash                                                    NaN      NaN      NaN      NaN      NaN\n# Cash and cash equivalents                             669.0    864.0   1624.0    499.0    508.0\n# Total cash                                            669.0    864.0   1624.0    499.0    508.0\n# Receivables                                            80.0     94.0     45.0     35.0     30.0\n# Inventories                                          1122.0   1367.0   1250.0    860.0    602.0\n# Prepaid expenses                                      129.0    125.0    119.0    121.0    225.0\n# Other current assets                                  140.0     89.0     90.0    119.0    185.0\n# Total current assets                                 2141.0   2539.0   3128.0   1634.0   1551.0\n# Non-current assets                                      NaN      NaN      NaN      NaN      NaN\n# Property, plant and equipment                           NaN      NaN      NaN      NaN      NaN\n# Gross property, plant and equipment                  1674.0   1763.0   1557.0   2233.0   1981.0\n# Accumulated Depreciation                            -1204.0  -1330.0  -1236.0  -1190.0  -1118.0\n# Net property, plant and equipment                     471.0    433.0    321.0   1043.0    863.0\n# Goodwill                                             1725.0   1667.0    364.0      NaN      NaN\n# Intangible assets                                     507.0    170.0     34.0     23.0     18.0\n# Deferred income taxes                                  59.0    158.0    147.0     83.0      NaN\n# Other long-term assets                                 73.0     75.0     51.0     37.0     40.0\n# Total non-current assets                             2835.0   2503.0    917.0   1186.0    921.0\n# Total assets                                         4976.0   5042.0   4044.0   2820.0   2473.0\n# Liabilities and stockholders\' equity                    NaN      NaN      NaN      NaN      NaN\n# Liabilities                                             NaN      NaN      NaN      NaN      NaN\n# Current liabilities                                     NaN      NaN      NaN      NaN      NaN\n# Short-term debt                                         NaN      NaN    349.0      NaN    147.0\n# Capital leases                                          NaN      NaN      NaN    239.0    227.0\n# Accounts payable                                      617.0    902.0   1052.0    381.0    342.0\n# Taxes payable                                         106.0    101.0     73.0     35.0     47.0\n# Accrued liabilities                                   417.0    302.0    174.0    128.0    104.0\n# Deferred revenues                                     474.0    442.0    393.0    350.0    372.0\n# Other current liabilities                             148.0    168.0    141.0    105.0    104.0\n# Total current liabilities                            1762.0   1916.0   2181.0   1238.0   1343.0\n# Non-current liabilities                                 NaN      NaN      NaN      NaN      NaN\n# Long-term debt                                        815.0    818.0    472.0    420.0    216.0\n# Capital leases                                          NaN      NaN      NaN    529.0    457.0\n# Deferred taxes liabilities                             23.0      5.0      0.0      NaN      NaN\n# Other long-term liabilities                           122.0     89.0     55.0     21.0     20.0\n# Total non-current liabilities                         960.0    912.0    527.0    970.0    693.0\n# Total liabilities                                    2722.0   2827.0   2708.0   2208.0   2036.0\n# Stockholders\' equity                                    NaN      NaN      NaN      NaN      NaN\n# Common stock                                            0.0      0.0      0.0      0.0      0.0\n# Additional paid-in capital                              NaN     22.0     28.0      NaN     11.0\n# Retained earnings                                    2301.0   2180.0   1363.0    690.0    475.0\n# Accumulated other comprehensive income                -47.0     12.0    -54.0    -79.0    -49.0\n# Total stockholders\' equity                           2254.0   2214.0   1336.0    612.0    437.0\n# Total liabilities and stockholders\' equity           4976.0   5042.0   4044.0   2820.0   2473.0\n#                                                     2020-01  2020-04  2020-07  2020-10  2021-01      TTM\n# Fiscal year ends in January. USD in millions ex...\n# Revenue                                             2194.00  1021.00   942.00  1005.00  2122.00  5090.00\n# Cost of revenue                                     1597.00   739.00   690.00   728.00  1674.00  3830.00\n# Gross profit                                         597.00   282.00   252.00   276.00   449.00  1260.00\n# Operating expenses                                      NaN      NaN      NaN      NaN      NaN      NaN\n# Sales, General and administrative                    581.00   386.00   348.00   360.00   419.00  1514.00\n# Other operating expenses                             -69.00      NaN      NaN      NaN      NaN      NaN\n# Total operating expenses                             512.00   386.00   348.00   360.00   419.00  1514.00\n# Operating income                                      86.00  -104.00   -96.00   -84.00    30.00  -255.00\n# Interest Expense                                       8.00     8.00     8.00    10.00     8.00    34.00\n# Other income (expense)                                -9.00    -3.00    11.00    21.00   -10.00    19.00\n# Income before taxes                                   69.00  -115.00   -93.00   -73.00    11.00  -270.00\n# Provision for income taxes                            44.00    50.00    18.00   -54.00   -70.00   -55.00\n# Net income from continuing operations                 25.00  -165.00  -111.00   -19.00    80.00  -215.00\n# Net income from discontinuing ops                     -4.00    -1.00    -0.00      NaN     0.00    -1.00\n# Net income                                            21.00  -166.00  -111.00   -19.00    80.00  -215.00\n# Net income available to common shareholders           21.00  -166.00  -111.00   -19.00    80.00  -215.00\n# Earnings per share                                      NaN      NaN      NaN      NaN      NaN      NaN\n# Basic                                                  0.32    -2.57    -1.71    -0.29     1.23    -3.31\n# Diluted                                                0.32    -2.57    -1.71    -0.29     1.19    -3.31\n# Weighted average shares outstanding                     NaN      NaN      NaN      NaN      NaN      NaN\n# Basic                                                 66.00    64.00    65.00    65.00    65.00    65.00\n# Diluted                                               66.00    64.00    65.00    65.00    65.00    65.00\n# EBITDA                                               103.00   -86.00   -65.00   -43.00    39.00  -155.00\n#                                                     2020-01  2020-04  2020-07  2020-10  2021-01\n# Fiscal year ends in January. USD in millions ex...\n# Cash Flows From Operating Activities                    NaN      NaN      NaN      NaN      NaN\n# Net income                                             21.0   -166.0   -111.0    -19.0     80.0\n# Depreciation & amortization                            26.0     22.0     20.0     19.0     20.0\n# Investment/asset impairment charges                    10.0      4.0      1.0      NaN     11.0\n# Deferred income taxes                                  73.0     45.0      NaN      NaN     35.0\n# Stock based compensation                                1.0      2.0      2.0      2.0      2.0\n# Change in working capital                              84.0     43.0    292.0   -169.0     16.0\n# Inventory                                             423.0    196.0    198.0   -383.0    271.0\n# Prepaid expenses                                       14.0      6.0     -4.0     -5.0     11.0\n# Other working capital                                -353.0   -159.0     97.0    218.0   -266.0\n# Other non-cash items                                   25.0      1.0    -11.0    -18.0      2.0\n# Net cash provided by operating activities             240.0    -49.0    193.0   -185.0    165.0\n# Cash Flows From Investing Activities                    NaN      NaN      NaN      NaN      NaN\n# Investments in property, plant, and equipment         -17.0     -7.0    -11.0    -15.0    -27.0\n# Property, plant, and equipment reductions               NaN      NaN      NaN     44.0      NaN\n# Other investing activities                             13.0      0.0     53.0     -1.0      1.0\n# Net cash used for investing activities                 -4.0     -6.0     42.0     27.0    -26.0\n# Cash Flows From Financing Activities                    NaN      NaN      NaN      NaN      NaN\n# Debt issued                                             NaN    150.0     24.0     24.0      NaN\n# Debt repayment                                          NaN    -17.0   -103.0    -10.0   -125.0\n# Common stock repurchased                              -22.0      NaN      NaN      NaN      NaN\n# Dividend paid                                           NaN      0.0      NaN      NaN      NaN\n# Other financing activities                              0.0      0.0      0.0      NaN      4.0\n# Net cash provided by (used for) financing activ...    -22.0    132.0    -80.0     14.0   -121.0\n# Effect of exchange rate changes                        -5.0     -6.0     20.0    -12.0     15.0\n# Net change in cash                                    209.0     70.0    175.0   -156.0     32.0\n# Cash at beginning of period                           304.0    514.0    584.0    759.0    603.0\n# Cash at end of period                                 514.0    584.0    759.0    603.0    635.0\n# Free Cash Flow                                          NaN      NaN      NaN      NaN      NaN\n# Operating cash flow                                   240.0    -49.0    193.0   -185.0    165.0\n# Capital expenditure                                   -17.0     -7.0    -11.0    -15.0    -27.0\n# Free cash flow                                        223.0    -56.0    182.0   -200.0    137.0\n#                                                     2017-01  2018-01  2019-01  2020-01  2021-01\n# Fiscal year ends in January. USD in millions ex...\n# Assets                                                  NaN      NaN      NaN      NaN      NaN\n# Current assets                                          NaN      NaN      NaN      NaN      NaN\n# Cash                                                    NaN      NaN      NaN      NaN      NaN\n# Cash and cash equivalents                             669.0    864.0   1624.0    499.0    508.0\n# Total cash                                            669.0    864.0   1624.0    499.0    508.0\n# Receivables                                            80.0     94.0     45.0     35.0     30.0\n# Inventories                                          1122.0   1367.0   1250.0    860.0    602.0\n# Prepaid expenses                                      129.0    125.0    119.0    121.0    225.0\n# Other current assets                                  140.0     89.0     90.0    119.0    185.0\n# Total current assets                                 2141.0   2539.0   3128.0   1634.0   1551.0\n# Non-current assets                                      NaN      NaN      NaN      NaN      NaN\n# Property, plant and equipment                           NaN      NaN      NaN      NaN      NaN\n# Gross property, plant and equipment                  1674.0   1763.0   1557.0   2233.0   1981.0\n# Accumulated Depreciation                            -1204.0  -1330.0  -1236.0  -1190.0  -1118.0\n# Net property, plant and equipment                     471.0    433.0    321.0   1043.0    863.0\n# Goodwill                                             1725.0   1667.0    364.0      NaN      NaN\n# Intangible assets                                     507.0    170.0     34.0     23.0     18.0\n# Deferred income taxes                                  59.0    158.0    147.0     83.0      NaN\n# Other long-term assets                                 73.0     75.0     51.0     37.0     40.0\n# Total non-current assets                             2835.0   2503.0    917.0   1186.0    921.0\n# Total assets                                         4976.0   5042.0   4044.0   2820.0   2473.0\n# Liabilities and stockholders\' equity                    NaN      NaN      NaN      NaN      NaN\n# Liabilities                                             NaN      NaN      NaN      NaN      NaN\n# Current liabilities                                     NaN      NaN      NaN      NaN      NaN\n# Short-term debt                                         NaN      NaN    349.0      NaN    147.0\n# Capital leases                                          NaN      NaN      NaN    239.0    227.0\n# Accounts payable                                      617.0    902.0   1052.0    381.0    342.0\n# Taxes payable                                         106.0    101.0     73.0     35.0     47.0\n# Accrued liabilities                                   417.0    302.0    174.0    128.0    104.0\n# Deferred revenues                                     474.0    442.0    393.0    350.0    372.0\n# Other current liabilities                             148.0    168.0    141.0    105.0    104.0\n# Total current liabilities                            1762.0   1916.0   2181.0   1238.0   1343.0\n# Non-current liabilities                                 NaN      NaN      NaN      NaN      NaN\n# Long-term debt                                        815.0    818.0    472.0    420.0    216.0\n# Capital leases                                          NaN      NaN      NaN    529.0    457.0\n# Deferred taxes liabilities                             23.0      5.0      0.0      NaN      NaN\n# Other long-term liabilities                           122.0     89.0     55.0     21.0     20.0\n# Total non-current liabilities                         960.0    912.0    527.0    970.0    693.0\n# Total liabilities                                    2722.0   2827.0   2708.0   2208.0   2036.0\n# Stockholders\' equity                                    NaN      NaN      NaN      NaN      NaN\n# Common stock                                            0.0      0.0      0.0      0.0      0.0\n# Additional paid-in capital                              NaN     22.0     28.0      NaN     11.0\n# Retained earnings                                    2301.0   2180.0   1363.0    690.0    475.0\n# Accumulated other comprehensive income                -47.0     12.0    -54.0    -79.0    -49.0\n# Total stockholders\' equity                           2254.0   2214.0   1336.0    612.0    437.0\n# Total liabilities and stockholders\' equity           4976.0   5042.0   4044.0   2820.0   2473.0\n#                                                     2020-01  2020-04  2020-07  2020-10  2021-01      TTM\n# Fiscal year ends in January. USD in millions ex...\n# Revenue                                             2194.00  1021.00   942.00  1005.00  2122.00  5090.00\n# Cost of revenue                                     1597.00   739.00   690.00   728.00  1674.00  3830.00\n# Gross profit                                         597.00   282.00   252.00   276.00   449.00  1260.00\n# Operating expenses                                      NaN      NaN      NaN      NaN      NaN      NaN\n# Sales, General and administrative                    581.00   386.00   348.00   360.00   419.00  1514.00\n# Other operating expenses                             -69.00      NaN      NaN      NaN      NaN      NaN\n# Total operating expenses                             512.00   386.00   348.00   360.00   419.00  1514.00\n# Operating income                                      86.00  -104.00   -96.00   -84.00    30.00  -255.00\n# Interest Expense                                       8.00     8.00     8.00    10.00     8.00    34.00\n# Other income (expense)                                -9.00    -3.00    11.00    21.00   -10.00    19.00\n# Income before taxes                                   69.00  -115.00   -93.00   -73.00    11.00  -270.00\n# Provision for income taxes                            44.00    50.00    18.00   -54.00   -70.00   -55.00\n# Net income from continuing operations                 25.00  -165.00  -111.00   -19.00    80.00  -215.00\n# Net income from discontinuing ops                     -4.00    -1.00    -0.00      NaN     0.00    -1.00\n# Net income                                            21.00  -166.00  -111.00   -19.00    80.00  -215.00\n# Net income available to common shareholders           21.00  -166.00  -111.00   -19.00    80.00  -215.00\n# Earnings per share                                      NaN      NaN      NaN      NaN      NaN      NaN\n# Basic                                                  0.32    -2.57    -1.71    -0.29     1.23    -3.31\n# Diluted                                                0.32    -2.57    -1.71    -0.29     1.19    -3.31\n# Weighted average shares outstanding                     NaN      NaN      NaN      NaN      NaN      NaN\n# Basic                                                 66.00    64.00    65.00    65.00    65.00    65.00\n# Diluted                                               66.00    64.00    65.00    65.00    65.00    65.00\n# EBITDA                                               103.00   -86.00   -65.00   -43.00    39.00  -155.00\n#                                                     2020-01  2020-04  2020-07  2020-10  2021-01\n# Fiscal year ends in January. USD in millions ex...\n# Cash Flows From Operating Activities                    NaN      NaN      NaN      NaN      NaN\n# Net income                                             21.0   -166.0   -111.0    -19.0     80.0\n# Depreciation & amortization                            26.0     22.0     20.0     19.0     20.0\n# Investment/asset impairment charges                    10.0      4.0      1.0      NaN     11.0\n# Deferred income taxes                                  73.0     45.0      NaN      NaN     35.0\n# Stock based compensation                                1.0      2.0      2.0      2.0      2.0\n# Change in working capital                              84.0     43.0    292.0   -169.0     16.0\n# Inventory                                             423.0    196.0    198.0   -383.0    271.0\n# Prepaid expenses                                       14.0      6.0     -4.0     -5.0     11.0\n# Other working capital                                -353.0   -159.0     97.0    218.0   -266.0\n# Other non-cash items                                   25.0      1.0    -11.0    -18.0      2.0\n# Net cash provided by operating activities             240.0    -49.0    193.0   -185.0    165.0\n# Cash Flows From Investing Activities                    NaN      NaN      NaN      NaN      NaN\n# Investments in property, plant, and equipment         -17.0     -7.0    -11.0    -15.0    -27.0\n# Property, plant, and equipment reductions               NaN      NaN      NaN     44.0      NaN\n# Other investing activities                             13.0      0.0     53.0     -1.0      1.0\n# Net cash used for investing activities                 -4.0     -6.0     42.0     27.0    -26.0\n# Cash Flows From Financing Activities                    NaN      NaN      NaN      NaN      NaN\n# Debt issued                                             NaN    150.0     24.0     24.0      NaN\n# Debt repayment                                          NaN    -17.0   -103.0    -10.0   -125.0\n# Common stock repurchased                              -22.0      NaN      NaN      NaN      NaN\n# Dividend paid                                           NaN      0.0      NaN      NaN      NaN\n# Other financing activities                              0.0      0.0      0.0      NaN      4.0\n# Net cash provided by (used for) financing activ...    -22.0    132.0    -80.0     14.0   -121.0\n# Effect of exchange rate changes                        -5.0     -6.0     20.0    -12.0     15.0\n# Net change in cash                                    209.0     70.0    175.0   -156.0     32.0\n# Cash at beginning of period                           304.0    514.0    584.0    759.0    603.0\n# Cash at end of period                                 514.0    584.0    759.0    603.0    635.0\n# Free Cash Flow                                          NaN      NaN      NaN      NaN      NaN\n# Operating cash flow                                   240.0    -49.0    193.0   -185.0    165.0\n# Capital expenditure                                   -17.0     -7.0    -11.0    -15.0    -27.0\n# Free cash flow                                        223.0    -56.0    182.0   -200.0    137.0\n\n\n\n```\n\n## Testing\n\nNot implemented Yet!\n\n```Bash\npoetry run pytest\n```\n',
    'author': 'Sören Michaels',
    'author_email': 'soeren.michaels@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/msw-projects/pyfinra',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
