/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.jpeg2000.impl;

import com.github.jaiimageio.impl.common.ImageUtil;
import com.github.jaiimageio.jpeg2000.impl.ChannelDefinitionBox;
import com.github.jaiimageio.jpeg2000.impl.I18N;
import com.github.jaiimageio.jpeg2000.impl.IISRandomAccessIO;
import com.github.jaiimageio.jpeg2000.impl.J2KImageReadParamJava;
import com.github.jaiimageio.jpeg2000.impl.J2KImageReader;
import com.github.jaiimageio.jpeg2000.impl.J2KMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class J2KReadState {
    private ImageInputStream iis = null;
    private FileFormatReader ff;
    private HeaderInfo hi;
    private HeaderDecoder hd;
    private RandomAccessIO in;
    private BitstreamReaderAgent breader;
    private EntropyDecoder entdec;
    private ROIDeScaler roids;
    private Dequantizer deq;
    private InverseWT invWT;
    private InvCompTransf ictransf;
    private ImgDataConverter converter;
    private ImgDataConverter converter2;
    private DecoderSpecs decSpec = null;
    private J2KImageReadParamJava j2krparam = null;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int[] levelShift = null;
    private int[] minValues = null;
    private int[] maxValues = null;
    private int[] fracBits = null;
    private DataBlkInt[] dataBlocks = null;
    private int[] bandOffsets = null;
    private int maxDepth = 0;
    private boolean isSigned = false;
    private ColorModel colorModel = null;
    private SampleModel sampleModel = null;
    private int nComp = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private Rectangle destinationRegion = null;
    private Point sourceOrigin;
    private int tileXOffset;
    private int tileYOffset;
    private int width;
    private int height;
    private int[] pixbuf = null;
    private byte[] bytebuf = null;
    private int[] channelMap = null;
    private boolean noTransform = true;
    private int resolution;
    private int stepX;
    private int stepY;
    private int tileStepX;
    private int tileStepY;
    private J2KMetadata metadata;
    private BufferedImage destImage;
    private J2KImageReader reader;

    public J2KReadState(ImageInputStream iis, J2KImageReadParamJava param, J2KMetadata metadata, J2KImageReader reader) {
        if (iis == null || param == null || metadata == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = iis;
        this.j2krparam = param;
        this.metadata = metadata;
        this.reader = reader;
        this.initializeRead(0, param, metadata);
    }

    public J2KReadState(ImageInputStream iis, J2KImageReadParamJava param, J2KImageReader reader) {
        if (iis == null || param == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = iis;
        this.j2krparam = param;
        this.reader = reader;
        this.initializeRead(0, param, null);
    }

    public int getWidth() throws IOException {
        return this.width;
    }

    public int getHeight() throws IOException {
        return this.height;
    }

    public HeaderDecoder getHeader() {
        return this.hd;
    }

    public Raster getTile(int tileX, int tileY, WritableRaster raster) throws IOException {
        Point nT = this.ictransf.getNumTiles(null);
        if (this.noTransform) {
            int cTileHeight;
            int cTileWidth;
            int tOffy;
            int tOffx;
            if (tileX >= nT.x || tileY >= nT.y) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
            }
            this.ictransf.setTile(tileX * this.tileStepX, tileY * this.tileStepY);
            if (raster != null && this.resolution < this.hd.getDecoderSpecs().dls.getMin() || this.stepX != 1 || this.stepY != 1) {
                tOffx = raster.getMinX();
                tOffy = raster.getMinY();
                cTileWidth = Math.min(raster.getWidth(), this.ictransf.getTileWidth());
                cTileHeight = Math.min(raster.getHeight(), this.ictransf.getTileHeight());
            } else {
                tOffx = this.ictransf.getCompULX(0) - (this.ictransf.getImgULX() + this.ictransf.getCompSubsX(0) - 1) / this.ictransf.getCompSubsX(0) + this.destinationRegion.x;
                tOffy = this.ictransf.getCompULY(0) - (this.ictransf.getImgULY() + this.ictransf.getCompSubsY(0) - 1) / this.ictransf.getCompSubsY(0) + this.destinationRegion.y;
                cTileWidth = this.ictransf.getTileWidth();
                cTileHeight = this.ictransf.getTileHeight();
            }
            if (raster == null) {
                raster = Raster.createWritableRaster(this.sampleModel, new Point(tOffx, tOffy));
            }
            int numBands = this.sampleModel.getNumBands();
            if (tOffx + cTileWidth >= this.destinationRegion.width + this.destinationRegion.x) {
                cTileWidth = this.destinationRegion.width + this.destinationRegion.x - tOffx;
            }
            if (tOffy + cTileHeight >= this.destinationRegion.height + this.destinationRegion.y) {
                cTileHeight = this.destinationRegion.height + this.destinationRegion.y - tOffy;
            }
            if (this.pixbuf == null || this.pixbuf.length < cTileWidth * numBands) {
                this.pixbuf = new int[cTileWidth * numBands];
            }
            boolean prog = false;
            for (int l = 0; l < cTileHeight && !this.reader.getAbortRequest(); ++l) {
                for (int i = 0; i < numBands && !this.reader.getAbortRequest(); ++i) {
                    int tmp;
                    int j;
                    DataBlkInt db = this.dataBlocks[i];
                    db.ulx = 0;
                    db.uly = l;
                    db.w = cTileWidth;
                    db.h = 1;
                    this.ictransf.getInternCompData(db, this.channelMap[this.sourceBands[i]]);
                    prog = prog || db.progressive;
                    int[] data = db.data;
                    int k1 = db.offset + cTileWidth - 1;
                    int fracBit = this.fracBits[i];
                    int lS = this.levelShift[i];
                    int min = this.minValues[i];
                    int max = this.maxValues[i];
                    if (ImageUtil.isBinary(this.sampleModel)) {
                        min = 0;
                        max = 1;
                        if (this.bytebuf == null || this.bytebuf.length < cTileWidth * numBands) {
                            this.bytebuf = new byte[cTileWidth * numBands];
                        }
                        for (j = cTileWidth - 1; j >= 0; --j) {
                            this.bytebuf[j] = (byte)((tmp = (data[k1--] >> fracBit) + lS) < min ? min : (tmp > max ? max : tmp));
                        }
                        ImageUtil.setUnpackedBinaryData(this.bytebuf, raster, new Rectangle(tOffx, tOffy + l, cTileWidth, 1));
                        continue;
                    }
                    for (j = cTileWidth - 1; j >= 0; --j) {
                        this.pixbuf[j] = (tmp = (data[k1--] >> fracBit) + lS) < min ? min : (tmp > max ? max : tmp);
                    }
                    raster.setSamples(tOffx, tOffy + l, cTileWidth, 1, this.destinationBands[i], this.pixbuf);
                }
            }
        } else {
            this.readSubsampledRaster(raster);
        }
        return raster;
    }

    public Rectangle getDestinationRegion() {
        return this.destinationRegion;
    }

    public BufferedImage readBufferedImage() throws IOException {
        this.colorModel = this.getColorModel();
        this.sampleModel = this.getSampleModel();
        WritableRaster raster = null;
        BufferedImage image = this.j2krparam.getDestination();
        int x = this.destinationRegion.x;
        int y = this.destinationRegion.y;
        this.destinationRegion.setLocation(this.j2krparam.getDestinationOffset());
        if (image == null) {
            ImageTypeSpecifier type = this.j2krparam.getDestinationType();
            if (type != null) {
                this.colorModel = type.getColorModel();
            }
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
            image = new BufferedImage(this.colorModel, raster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            raster = image.getWritableTile(0, 0);
        }
        this.destImage = image;
        this.readSubsampledRaster(raster);
        this.destinationRegion.setLocation(x, y);
        this.destImage = null;
        return image;
    }

    public Raster readAsRaster() throws IOException {
        BufferedImage image = this.j2krparam.getDestination();
        WritableRaster raster = null;
        if (image == null) {
            this.sampleModel = this.getSampleModel();
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
        } else {
            raster = image.getWritableTile(0, 0);
        }
        this.readSubsampledRaster(raster);
        return raster;
    }

    private void initializeRead(int imageIndex, J2KImageReadParamJava param, J2KMetadata metadata) {
        try {
            this.iis.mark();
            this.in = new IISRandomAccessIO(this.iis);
            this.ff = new FileFormatReader(this.in, metadata);
            this.ff.readFileFormat();
            this.in.seek(this.ff.getFirstCodeStreamPos());
            this.hi = new HeaderInfo();
            try {
                this.hd = new HeaderDecoder(this.in, this.j2krparam, this.hi);
            }
            catch (EOFException e) {
                throw new RuntimeException(I18N.getString("J2KReadState2"));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.width = this.hd.getImgWidth();
            this.height = this.hd.getImgHeight();
            Rectangle sourceRegion = param.getSourceRegion();
            this.sourceOrigin = new Point();
            sourceRegion = new Rectangle(this.hd.getImgULX(), this.hd.getImgULY(), this.width, this.height);
            boolean compConsistent = true;
            this.stepX = this.hd.getCompSubsX(0);
            this.stepY = this.hd.getCompSubsY(0);
            for (int i = 1; i < this.nComp; ++i) {
                if (this.stepX == this.hd.getCompSubsX(i) && this.stepY == this.hd.getCompSubsY(i)) continue;
                throw new RuntimeException(I18N.getString("J2KReadState12"));
            }
            int minResLevels = this.hd.getDecoderSpecs().dls.getMin();
            int n = this.resolution = param != null ? param.getResolution() : minResLevels;
            if (this.resolution < 0 || this.resolution > minResLevels) {
                this.resolution = minResLevels;
            }
            if (this.resolution != minResLevels || this.stepX != 1 || this.stepY != 1) {
                sourceRegion = J2KImageReader.getReducedRect(sourceRegion, minResLevels, this.resolution, this.stepX, this.stepY);
            }
            this.destinationRegion = (Rectangle)sourceRegion.clone();
            J2KImageReader.computeRegionsWrapper(param, false, this.width, this.height, param.getDestination(), sourceRegion, this.destinationRegion);
            this.sourceOrigin = new Point(sourceRegion.x, sourceRegion.y);
            this.scaleX = param.getSourceXSubsampling();
            this.scaleY = param.getSourceYSubsampling();
            this.xOffset = param.getSubsamplingXOffset();
            this.yOffset = param.getSubsamplingYOffset();
            this.width = this.destinationRegion.width;
            this.height = this.destinationRegion.height;
            Point tileOffset = this.hd.getTilingOrigin(null);
            this.tileWidth = this.hd.getNomTileWidth();
            this.tileHeight = this.hd.getNomTileHeight();
            if (this.resolution != minResLevels || this.stepX != 1 || this.stepY != 1) {
                Rectangle tileRect = new Rectangle(tileOffset);
                tileRect.width = this.tileWidth;
                tileRect.height = this.tileHeight;
                tileRect = J2KImageReader.getReducedRect(tileRect, minResLevels, this.resolution, this.stepX, this.stepY);
                tileOffset = tileRect.getLocation();
                this.tileWidth = tileRect.width;
                this.tileHeight = tileRect.height;
            }
            this.tileXOffset = tileOffset.x;
            this.tileYOffset = tileOffset.y;
            this.tileStepX = this.tileWidth * (1 << minResLevels - this.resolution) * this.stepX > this.hd.getNomTileWidth() ? (this.tileWidth * (1 << minResLevels - this.resolution) * this.stepX + this.hd.getNomTileWidth() - 1) / this.hd.getNomTileWidth() : 1;
            this.tileStepY = this.tileHeight * (1 << minResLevels - this.resolution) * this.stepY > this.hd.getNomTileHeight() ? (this.tileHeight * (1 << minResLevels - this.resolution) * this.stepY + this.hd.getNomTileHeight() - 1) / this.hd.getNomTileHeight() : 1;
            if (!this.destinationRegion.equals(sourceRegion)) {
                this.noTransform = false;
            }
            this.decSpec = this.hd.getDecoderSpecs();
            this.nComp = this.hd.getNumComps();
            int[] depth = new int[this.nComp];
            for (int i = 0; i < this.nComp; ++i) {
                depth[i] = this.hd.getOriginalBitDepth(i);
            }
            ChannelDefinitionBox cdb = null;
            if (metadata != null) {
                cdb = (ChannelDefinitionBox)metadata.getElement("JPEG2000ChannelDefinitionBox");
            }
            this.channelMap = new int[this.nComp];
            if (cdb != null && metadata.getElement("JPEG2000PaletteBox") == null) {
                short[] assoc = cdb.getAssociation();
                short[] types = cdb.getTypes();
                short[] channels = cdb.getChannel();
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == 0) {
                        this.channelMap[channels[i]] = assoc[i] - 1;
                        continue;
                    }
                    if (types[i] != 1 && types[i] != 2) continue;
                    this.channelMap[channels[i]] = channels[i];
                }
            } else {
                for (int i = 0; i < this.nComp; ++i) {
                    this.channelMap[i] = i;
                }
            }
            try {
                boolean logJJ2000Messages = Boolean.getBoolean("jj2000.j2k.decoder.log");
                this.breader = BitstreamReaderAgent.createInstance(this.in, this.hd, this.j2krparam, this.decSpec, logJJ2000Messages, this.hi);
            }
            catch (IOException e) {
                throw new RuntimeException(I18N.getString("J2KReadState3") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState4") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.entdec = this.hd.createEntropyDecoder(this.breader, this.j2krparam);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState5") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.roids = this.hd.createROIDeScaler(this.entdec, this.j2krparam, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState6") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.deq = this.hd.createDequantizer(this.roids, depth, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState7") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.invWT = InverseWT.createInstance(this.deq, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState8") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            int res = this.breader.getImgRes();
            int mrl = this.decSpec.dls.getMin();
            this.invWT.setImgResLevel(res);
            this.converter = new ImgDataConverter(this.invWT, 0);
            this.ictransf = new InvCompTransf(this.converter, this.decSpec, depth);
            this.sourceBands = this.j2krparam.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.nComp];
                for (int i = 0; i < this.nComp; ++i) {
                    this.sourceBands[i] = i;
                }
            }
            this.nComp = this.sourceBands.length;
            this.destinationBands = this.j2krparam.getDestinationBands();
            if (this.destinationBands == null) {
                this.destinationBands = new int[this.nComp];
                for (int i = 0; i < this.nComp; ++i) {
                    this.destinationBands[i] = i;
                }
            }
            J2KImageReader.checkReadParamBandSettingsWrapper(param, this.hd.getNumComps(), this.destinationBands.length);
            this.levelShift = new int[this.nComp];
            this.minValues = new int[this.nComp];
            this.maxValues = new int[this.nComp];
            this.fracBits = new int[this.nComp];
            this.dataBlocks = new DataBlkInt[this.nComp];
            depth = new int[this.nComp];
            this.bandOffsets = new int[this.nComp];
            this.maxDepth = 0;
            this.isSigned = false;
            for (int i = 0; i < this.nComp; ++i) {
                depth[i] = this.hd.getOriginalBitDepth(this.sourceBands[i]);
                if (depth[i] > this.maxDepth) {
                    this.maxDepth = depth[i];
                }
                this.dataBlocks[i] = new DataBlkInt();
                this.bandOffsets[i] = i;
                if (this.hd.isOriginalSigned(this.sourceBands[i])) {
                    this.isSigned = true;
                } else {
                    this.levelShift[i] = 1 << this.ictransf.getNomRangeBits(this.sourceBands[i]) - 1;
                }
                int nomRangeBits = this.ictransf.getNomRangeBits(this.sourceBands[i]);
                this.maxValues[i] = (1 << (this.isSigned ? nomRangeBits - 1 : nomRangeBits)) - 1;
                this.minValues[i] = this.isSigned ? -(this.maxValues[i] + 1) : 0;
                this.fracBits[i] = this.ictransf.getFixedPoint(this.sourceBands[i]);
            }
            this.iis.reset();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Error e) {
            if (e.getMessage() != null) {
                throw new RuntimeException(e.getMessage(), e);
            }
            throw new RuntimeException(I18N.getString("J2KReadState9"), e);
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null) {
                throw new RuntimeException(I18N.getString("J2KReadState10") + " " + e.getMessage(), e);
            }
            throw new RuntimeException(I18N.getString("J2KReadState10"), e);
        }
        catch (Throwable e) {
            throw new RuntimeException(I18N.getString("J2KReadState10"), e);
        }
    }

    private Raster readSubsampledRaster(WritableRaster raster) throws IOException {
        if (raster == null) {
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int[] pixbuf = null;
        boolean prog = false;
        Point nT = this.ictransf.getNumTiles(null);
        int numBands = this.sourceBands.length;
        Rectangle destRect = raster.getBounds().intersection(this.destinationRegion);
        int offx = this.destinationRegion.x;
        int offy = this.destinationRegion.y;
        int sourceSX = (destRect.x - offx) * this.scaleX + this.sourceOrigin.x;
        int sourceSY = (destRect.y - offy) * this.scaleY + this.sourceOrigin.y;
        int sourceEX = (destRect.width - 1) * this.scaleX + sourceSX;
        int sourceEY = (destRect.height - 1) * this.scaleY + sourceSY;
        int startXTile = (sourceSX - this.tileXOffset) / this.tileWidth;
        int startYTile = (sourceSY - this.tileYOffset) / this.tileHeight;
        int endXTile = (sourceEX - this.tileXOffset) / this.tileWidth;
        int endYTile = (sourceEY - this.tileYOffset) / this.tileHeight;
        startXTile = this.clip(startXTile, 0, nT.x - 1);
        startYTile = this.clip(startYTile, 0, nT.y - 1);
        endXTile = this.clip(endXTile, 0, nT.x - 1);
        endYTile = this.clip(endYTile, 0, nT.y - 1);
        int totalXTiles = endXTile - startXTile + 1;
        int totalYTiles = endYTile - startYTile + 1;
        int totalTiles = totalXTiles * totalYTiles;
        for (int y = startYTile; y <= endYTile && !this.reader.getAbortRequest(); ++y) {
            for (int x = startXTile; x <= endXTile && !this.reader.getAbortRequest(); ++x) {
                float initialFraction = (x - startXTile + (y - startYTile) * totalXTiles) / totalTiles;
                this.ictransf.setTile(x * this.tileStepX, y * this.tileStepY);
                int sx = this.hd.getCompSubsX(0);
                int cTileWidth = (this.ictransf.getTileWidth() + sx - 1) / sx;
                int sy = this.hd.getCompSubsY(0);
                int cTileHeight = (this.ictransf.getTileHeight() + sy - 1) / sy;
                int tx = 0;
                int ty = 0;
                int startX = this.tileXOffset + x * this.tileWidth;
                int startY = this.tileYOffset + y * this.tileHeight;
                if (sourceSX > startX) {
                    if (startX >= this.hd.getImgULX()) {
                        tx = sourceSX - startX;
                        cTileWidth -= tx;
                    }
                    startX = sourceSX;
                }
                if (sourceSY > startY) {
                    if (startY >= this.hd.getImgULY()) {
                        ty = sourceSY - startY;
                        cTileHeight -= ty;
                    }
                    startY = sourceSY;
                }
                if (sourceEX < startX + cTileWidth - 1) {
                    cTileWidth += sourceEX - startX - cTileWidth + 1;
                }
                if (sourceEY < startY + cTileHeight - 1) {
                    cTileHeight += sourceEY - startY - cTileHeight + 1;
                }
                int x1 = (startX + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int x2 = (startX + this.scaleX - 1 + cTileWidth - this.sourceOrigin.x) / this.scaleX;
                int lineLength = x2 - x1;
                if (pixbuf == null || pixbuf.length < lineLength) {
                    pixbuf = new int[lineLength];
                }
                x2 = (x2 - 1) * this.scaleX + this.sourceOrigin.x - startX;
                int y1 = (startY + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                x1 += offx;
                y1 += offy;
                boolean ycbcr = false;
                for (int i = 0; i < numBands; ++i) {
                    DataBlkInt db = this.dataBlocks[i];
                    db.ulx = tx;
                    db.uly = ty + cTileHeight - 1;
                    db.w = cTileWidth;
                    db.h = 1;
                    try {
                        this.ictransf.getInternCompData(db, this.channelMap[this.sourceBands[i]]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        ycbcr = true;
                        break;
                    }
                }
                int l = ty;
                int m = y1;
                while (l < ty + cTileHeight && !this.reader.getAbortRequest()) {
                    if (ycbcr) {
                        DataBlkInt lum = this.dataBlocks[0];
                        DataBlkInt cb = this.dataBlocks[1];
                        DataBlkInt cr = this.dataBlocks[2];
                        lum.ulx = tx;
                        lum.uly = l;
                        lum.w = cTileWidth;
                        lum.h = 1;
                        this.ictransf.getInternCompData(lum, this.channelMap[this.sourceBands[0]]);
                        prog = prog || lum.progressive;
                        cb.ulx = tx;
                        cb.uly = l;
                        cb.w = cTileWidth / 2;
                        cb.h = 1;
                        this.ictransf.getInternCompData(cb, this.channelMap[this.sourceBands[1]]);
                        prog = prog || cb.progressive;
                        cr.ulx = tx;
                        cr.uly = l;
                        cr.w = cTileWidth / 2;
                        cr.h = 1;
                        this.ictransf.getInternCompData(cr, this.channelMap[this.sourceBands[2]]);
                        prog = prog || cr.progressive;
                        int[] lumdata = lum.data;
                        int[] cbdata = cb.data;
                        int[] crdata = cr.data;
                        int k1 = lum.offset + x2;
                        int fracBit = this.fracBits[0];
                        int lS = this.levelShift[0];
                        int min = this.minValues[0];
                        int max = this.maxValues[0];
                        int[][] pix = new int[3][lineLength];
                        int j = lineLength - 1;
                        while (j >= 0) {
                            int red = (lumdata[k1] >> fracBit) + lS;
                            red = red < min ? min : (red > max ? max : red);
                            int cIndex = k1 / 2;
                            int chrom1 = cbdata[cIndex];
                            int chrom2 = crdata[cIndex];
                            int lumval = red;
                            red = (int)((double)chrom2 * 1.542 + (double)lumval);
                            int blue = (int)((double)lumval + 1.772 * (double)chrom1 - 0.886);
                            int green = (int)((double)lumval - 0.34413 * (double)chrom1 - 0.71414 * (double)chrom2 - 0.1228785);
                            if (red > 255) {
                                red = 255;
                            }
                            if (green > 255) {
                                green = 255;
                            }
                            if (blue > 255) {
                                blue = 255;
                            }
                            if (red < 0) {
                                red = 0;
                            }
                            if (green < 0) {
                                green = 0;
                            }
                            if (blue < 0) {
                                blue = 0;
                            }
                            pix[0][j] = red;
                            pix[1][j] = green;
                            pix[2][j] = blue;
                            --j;
                            k1 -= this.scaleX;
                        }
                        raster.setSamples(x1, m, lineLength, 1, this.destinationBands[0], pix[0]);
                        raster.setSamples(x1, m, lineLength, 1, this.destinationBands[1], pix[1]);
                        raster.setSamples(x1, m, lineLength, 1, this.destinationBands[2], pix[2]);
                    } else {
                        for (int i = 0; i < numBands; ++i) {
                            int tmp;
                            int j;
                            DataBlkInt db = this.dataBlocks[i];
                            db.ulx = tx;
                            db.uly = l;
                            db.w = ycbcr && i > 0 ? cTileWidth / 2 : cTileWidth;
                            db.h = 1;
                            this.ictransf.getInternCompData(db, this.channelMap[this.sourceBands[i]]);
                            prog = prog || db.progressive;
                            int[] data = db.data;
                            int k1 = db.offset + x2;
                            int fracBit = this.fracBits[i];
                            int lS = this.levelShift[i];
                            int min = this.minValues[i];
                            int max = this.maxValues[i];
                            if (ImageUtil.isBinary(this.sampleModel)) {
                                min = 0;
                                max = 1;
                                if (this.bytebuf == null || this.bytebuf.length < cTileWidth * numBands) {
                                    this.bytebuf = new byte[cTileWidth * numBands];
                                }
                                j = lineLength - 1;
                                while (j >= 0) {
                                    tmp = (data[k1] >> fracBit) + lS;
                                    this.bytebuf[j] = (byte)(tmp < min ? min : (tmp > max ? max : tmp));
                                    --j;
                                    k1 -= this.scaleX;
                                }
                                ImageUtil.setUnpackedBinaryData(this.bytebuf, raster, new Rectangle(x1, m, lineLength, 1));
                                continue;
                            }
                            j = lineLength - 1;
                            while (j >= 0) {
                                tmp = (data[k1] >> fracBit) + lS;
                                pixbuf[j] = tmp < min ? min : (tmp > max ? max : tmp);
                                --j;
                                k1 -= this.scaleX;
                            }
                            raster.setSamples(x1, m, lineLength, 1, this.destinationBands[i], pixbuf);
                        }
                        if (this.destImage != null) {
                            this.reader.processImageUpdateWrapper(this.destImage, x1, m, cTileWidth, 1, 1, 1, this.destinationBands);
                        }
                        float fraction = initialFraction + ((float)(l - ty) + 1.0f) / (float)cTileHeight / (float)totalTiles;
                        this.reader.processImageProgressWrapper(100.0f * fraction);
                    }
                    l += this.scaleY;
                    ++m;
                }
            }
        }
        return raster;
    }

    public ImageTypeSpecifier getImageType() throws IOException {
        this.getSampleModel();
        this.getColorModel();
        return new ImageTypeSpecifier(this.colorModel, this.sampleModel);
    }

    public SampleModel getSampleModel() {
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        int realWidth = Math.min(this.tileWidth, this.width);
        int realHeight = Math.min(this.tileHeight, this.height);
        if (this.nComp == 1 && (this.maxDepth == 1 || this.maxDepth == 2 || this.maxDepth == 4)) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, realWidth, realHeight, this.maxDepth);
        } else if (this.maxDepth <= 8) {
            this.sampleModel = new PixelInterleavedSampleModel(0, realWidth, realHeight, this.nComp, realWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 16) {
            this.sampleModel = new PixelInterleavedSampleModel(this.isSigned ? 2 : 1, realWidth, realHeight, this.nComp, realWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 32) {
            this.sampleModel = new PixelInterleavedSampleModel(3, realWidth, realHeight, this.nComp, realWidth * this.nComp, this.bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + this.maxDepth);
        }
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        this.colorModel = this.ff.getColorModel();
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.hi.siz.csiz <= 4) {
            ColorSpace cs = this.hi.siz.csiz > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] bitsPerComponent = new int[this.hi.siz.csiz];
            boolean isSigned = false;
            int maxBitDepth = -1;
            for (int i = 0; i < this.hi.siz.csiz; ++i) {
                bitsPerComponent[i] = this.hi.siz.getOrigBitDepth(i);
                if (maxBitDepth < bitsPerComponent[i]) {
                    maxBitDepth = bitsPerComponent[i];
                }
                isSigned |= this.hi.siz.isOrigSigned(i);
            }
            boolean hasAlpha = this.hi.siz.csiz % 2 == 0;
            int type = -1;
            if (maxBitDepth <= 8) {
                type = 0;
            } else if (maxBitDepth <= 16) {
                type = isSigned ? 2 : 1;
            } else if (maxBitDepth <= 32) {
                type = 3;
            }
            if (type != -1) {
                this.colorModel = this.hi.siz.csiz == 1 && (maxBitDepth == 1 || maxBitDepth == 2 || maxBitDepth == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel(cs, bitsPerComponent, hasAlpha, false, hasAlpha ? 3 : 1, type);
                return this.colorModel;
            }
        }
        if (this.sampleModel == null) {
            this.sampleModel = this.getSampleModel();
        }
        if (this.sampleModel == null) {
            return null;
        }
        return ImageUtil.createColorModel(null, this.sampleModel);
    }

    Rectangle getTile0Rect() {
        return new Rectangle(this.tileXOffset, this.tileYOffset, this.tileWidth, this.tileHeight);
    }

    private int clip(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private void clipDestination(Rectangle dest) {
        Point offset = this.j2krparam.getDestinationOffset();
        if (dest.x < offset.x) {
            dest.width += dest.x - offset.x;
            dest.x = offset.x;
        }
        if (dest.y < offset.y) {
            dest.height += dest.y - offset.y;
            dest.y = offset.y;
        }
    }
}

