# Generated by Django 3.2.3 on 2022-09-21 15:01

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_apscheduler', '0009_djangojobexecution_unique_job_executions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('is_deleted', models.BooleanField(db_index=True, default=False, help_text='是否软删除', verbose_name='是否软删除')),
                ('status', models.IntegerField(choices=[(0, '停用'), (1, '启用')], default=1, help_text='任务状态', verbose_name='任务状态')),
                ('name', models.CharField(help_text='任务名称', max_length=30, verbose_name='任务名称')),
                ('cron', models.CharField(help_text='cron表达式', max_length=255, verbose_name='cron表达式')),
                ('job', models.CharField(help_text='执行的任务', max_length=255, verbose_name='执行的任务')),
                ('creator', models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
                ('job_id', models.OneToOneField(blank=True, db_constraint=False, help_text='关联DjangoJob', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_apscheduler.djangojob', verbose_name='关联DjangoJob')),
            ],
            options={
                'verbose_name': '定时任务表',
                'verbose_name_plural': '定时任务表',
                'db_table': 'dvadmin_apscheduler_task',
                'ordering': ('create_datetime',),
            },
        ),
    ]
