import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type AWSQS::VPC::VPCQS::MODULE.
 *
 * @schema CfnVpcqsModuleProps
 */
export interface CfnVpcqsModuleProps {
    /**
     * @schema CfnVpcqsModuleProps#Parameters
     */
    readonly parameters?: CfnVpcqsModulePropsParameters;
    /**
     * @schema CfnVpcqsModuleProps#Resources
     */
    readonly resources?: CfnVpcqsModulePropsResources;
}
/**
 * Converts an object of type 'CfnVpcqsModuleProps' to JSON representation.
 */
export declare function toJson_CfnVpcqsModuleProps(obj: CfnVpcqsModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsParameters
 */
export interface CfnVpcqsModulePropsParameters {
    /**
     * List of Availability Zones to use for the subnets in the VPC.
     *
     * Note: The logical order is preserved.
     *
     * @schema CfnVpcqsModulePropsParameters#AvailabilityZones
     */
    readonly availabilityZones?: CfnVpcqsModulePropsParametersAvailabilityZones;
    /**
     * Set to true to create a network ACL protected subnet in each Availability Zone.
     *
     * If false, the CIDR parameters for those subnets will be ignored. If true, it also requires that the 'Create private subnets' parameter is also true to have any effect.
     *
     * @schema CfnVpcqsModulePropsParameters#CreateAdditionalPrivateSubnets
     */
    readonly createAdditionalPrivateSubnets?: CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets;
    /**
     * Set to false when creating only private subnets.
     *
     * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
     *
     * @schema CfnVpcqsModulePropsParameters#CreateNATGateways
     */
    readonly createNatGateways?: CfnVpcqsModulePropsParametersCreateNatGateways;
    /**
     * Set to false to create only private subnets.
     *
     * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
     *
     * @schema CfnVpcqsModulePropsParameters#CreatePublicSubnets
     */
    readonly createPublicSubnets?: CfnVpcqsModulePropsParametersCreatePublicSubnets;
    /**
     * Set to false to create only public subnets.
     *
     * If false, the CIDR parameters for ALL private subnets will be ignored.
     *
     * @schema CfnVpcqsModulePropsParameters#CreatePrivateSubnets
     */
    readonly createPrivateSubnets?: CfnVpcqsModulePropsParametersCreatePrivateSubnets;
    /**
     * Set to true to create VPC flow logs for the VPC and publish them to CloudWatch.
     *
     * If false, VPC flow logs will not be created.
     *
     * @schema CfnVpcqsModulePropsParameters#CreateVPCFlowLogsToCloudWatch
     */
    readonly createVpcFlowLogsToCloudWatch?: CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch;
    /**
     * Number of Availability Zones to use in the VPC.
     *
     * This must match your selections in the list of Availability Zones parameter.
     *
     * @schema CfnVpcqsModulePropsParameters#NumberOfAZs
     */
    readonly numberOfAZs?: CfnVpcqsModulePropsParametersNumberOfAZs;
    /**
     * CIDR block for private subnet 1A located in Availability Zone 1.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet1ACIDR
     */
    readonly privateSubnet1Acidr?: CfnVpcqsModulePropsParametersPrivateSubnet1Acidr;
    /**
     * CIDR block for private subnet 1B with dedicated network ACL located in Availability Zone 1.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet1BCIDR
     */
    readonly privateSubnet1Bcidr?: CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr;
    /**
     * CIDR block for private subnet 2A located in Availability Zone 2.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet2ACIDR
     */
    readonly privateSubnet2Acidr?: CfnVpcqsModulePropsParametersPrivateSubnet2Acidr;
    /**
     * CIDR block for private subnet 2B with dedicated network ACL located in Availability Zone 2.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet2BCIDR
     */
    readonly privateSubnet2Bcidr?: CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr;
    /**
     * CIDR block for private subnet 3A located in Availability Zone 3.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet3ACIDR
     */
    readonly privateSubnet3Acidr?: CfnVpcqsModulePropsParametersPrivateSubnet3Acidr;
    /**
     * CIDR block for private subnet 3B with dedicated network ACL located in Availability Zone 3.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet3BCIDR
     */
    readonly privateSubnet3Bcidr?: CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr;
    /**
     * CIDR block for private subnet 4A located in Availability Zone 4.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet4ACIDR
     */
    readonly privateSubnet4Acidr?: CfnVpcqsModulePropsParametersPrivateSubnet4Acidr;
    /**
     * CIDR block for private subnet 4B with dedicated network ACL located in Availability Zone 4.
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnet4BCIDR
     */
    readonly privateSubnet4Bcidr?: CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetATag1
     */
    readonly privateSubnetATag1?: CfnVpcqsModulePropsParametersPrivateSubnetATag1;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetATag2
     */
    readonly privateSubnetATag2?: CfnVpcqsModulePropsParametersPrivateSubnetATag2;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetATag3
     */
    readonly privateSubnetATag3?: CfnVpcqsModulePropsParametersPrivateSubnetATag3;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetBTag1
     */
    readonly privateSubnetBTag1?: CfnVpcqsModulePropsParametersPrivateSubnetBTag1;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetBTag2
     */
    readonly privateSubnetBTag2?: CfnVpcqsModulePropsParametersPrivateSubnetBTag2;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PrivateSubnetBTag3
     */
    readonly privateSubnetBTag3?: CfnVpcqsModulePropsParametersPrivateSubnetBTag3;
    /**
     * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnet1CIDR
     */
    readonly publicSubnet1Cidr?: CfnVpcqsModulePropsParametersPublicSubnet1Cidr;
    /**
     * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnet2CIDR
     */
    readonly publicSubnet2Cidr?: CfnVpcqsModulePropsParametersPublicSubnet2Cidr;
    /**
     * CIDR block for the public DMZ subnet 3 located in Availability Zone 3.
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnet3CIDR
     */
    readonly publicSubnet3Cidr?: CfnVpcqsModulePropsParametersPublicSubnet3Cidr;
    /**
     * CIDR block for the public DMZ subnet 4 located in Availability Zone 4.
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnet4CIDR
     */
    readonly publicSubnet4Cidr?: CfnVpcqsModulePropsParametersPublicSubnet4Cidr;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnetTag1
     */
    readonly publicSubnetTag1?: CfnVpcqsModulePropsParametersPublicSubnetTag1;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnetTag2
     */
    readonly publicSubnetTag2?: CfnVpcqsModulePropsParametersPublicSubnetTag2;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnVpcqsModulePropsParameters#PublicSubnetTag3
     */
    readonly publicSubnetTag3?: CfnVpcqsModulePropsParametersPublicSubnetTag3;
    /**
     * CIDR block for the VPC.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCCIDR
     */
    readonly vpccidr?: CfnVpcqsModulePropsParametersVpccidr;
    /**
     * (Optional) KMS Key ARN to use for encrypting the VPC flow logs data.
     *
     * If empty, encryption is enabled with CloudWatch Logs managing the server-side encryption keys.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCFlowLogsCloudWatchKMSKey
     */
    readonly vpcFlowLogsCloudWatchKmsKey?: CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey;
    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     *
     * Specify the fields using the ${field-id} format, separated by spaces. Using the Default Format as the default value.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCFlowLogsLogFormat
     */
    readonly vpcFlowLogsLogFormat?: CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat;
    /**
     * Number of days to retain the VPC Flow Logs in CloudWatch.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCFlowLogsLogGroupRetention
     */
    readonly vpcFlowLogsLogGroupRetention?: CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention;
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     *
     * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     *
     * @schema CfnVpcqsModulePropsParameters#VPCFlowLogsMaxAggregationInterval
     */
    readonly vpcFlowLogsMaxAggregationInterval?: CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval;
    /**
     * The type of traffic to log.
     *
     * You can log traffic that the resource accepts or rejects, or all traffic.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCFlowLogsTrafficType
     */
    readonly vpcFlowLogsTrafficType?: CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType;
    /**
     * The allowed tenancy of instances launched into the VPC.
     *
     * @schema CfnVpcqsModulePropsParameters#VPCTenancy
     */
    readonly vpcTenancy?: CfnVpcqsModulePropsParametersVpcTenancy;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParameters(obj: CfnVpcqsModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResources
 */
export interface CfnVpcqsModulePropsResources {
    /**
     * @schema CfnVpcqsModulePropsResources#DHCPOptions
     */
    readonly dhcpOptions?: CfnVpcqsModulePropsResourcesDhcpOptions;
    /**
     * @schema CfnVpcqsModulePropsResources#VPC
     */
    readonly vpc?: CfnVpcqsModulePropsResourcesVpc;
    /**
     * @schema CfnVpcqsModulePropsResources#VPCDHCPOptionsAssociation
     */
    readonly vpcdhcpOptionsAssociation?: CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#InternetGateway
     */
    readonly internetGateway?: CfnVpcqsModulePropsResourcesInternetGateway;
    /**
     * @schema CfnVpcqsModulePropsResources#VPCGatewayAttachment
     */
    readonly vpcGatewayAttachment?: CfnVpcqsModulePropsResourcesVpcGatewayAttachment;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1A
     */
    readonly privateSubnet1A?: CfnVpcqsModulePropsResourcesPrivateSubnet1A;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1B
     */
    readonly privateSubnet1B?: CfnVpcqsModulePropsResourcesPrivateSubnet1B;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2A
     */
    readonly privateSubnet2A?: CfnVpcqsModulePropsResourcesPrivateSubnet2A;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2B
     */
    readonly privateSubnet2B?: CfnVpcqsModulePropsResourcesPrivateSubnet2B;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3A
     */
    readonly privateSubnet3A?: CfnVpcqsModulePropsResourcesPrivateSubnet3A;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3B
     */
    readonly privateSubnet3B?: CfnVpcqsModulePropsResourcesPrivateSubnet3B;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4A
     */
    readonly privateSubnet4A?: CfnVpcqsModulePropsResourcesPrivateSubnet4A;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4B
     */
    readonly privateSubnet4B?: CfnVpcqsModulePropsResourcesPrivateSubnet4B;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet1
     */
    readonly publicSubnet1?: CfnVpcqsModulePropsResourcesPublicSubnet1;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet2
     */
    readonly publicSubnet2?: CfnVpcqsModulePropsResourcesPublicSubnet2;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet3
     */
    readonly publicSubnet3?: CfnVpcqsModulePropsResourcesPublicSubnet3;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet4
     */
    readonly publicSubnet4?: CfnVpcqsModulePropsResourcesPublicSubnet4;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1ARouteTable
     */
    readonly privateSubnet1ARouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1ARoute
     */
    readonly privateSubnet1ARoute?: CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1ARouteTableAssociation
     */
    readonly privateSubnet1ARouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2ARouteTable
     */
    readonly privateSubnet2ARouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2ARoute
     */
    readonly privateSubnet2ARoute?: CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2ARouteTableAssociation
     */
    readonly privateSubnet2ARouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3ARouteTable
     */
    readonly privateSubnet3ARouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3ARoute
     */
    readonly privateSubnet3ARoute?: CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3ARouteTableAssociation
     */
    readonly privateSubnet3ARouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4ARouteTable
     */
    readonly privateSubnet4ARouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4ARoute
     */
    readonly privateSubnet4ARoute?: CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4ARouteTableAssociation
     */
    readonly privateSubnet4ARouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BRouteTable
     */
    readonly privateSubnet1BRouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BRoute
     */
    readonly privateSubnet1BRoute?: CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BRouteTableAssociation
     */
    readonly privateSubnet1BRouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BNetworkAcl
     */
    readonly privateSubnet1BNetworkAcl?: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BNetworkAclEntryInbound
     */
    readonly privateSubnet1BNetworkAclEntryInbound?: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BNetworkAclEntryOutbound
     */
    readonly privateSubnet1BNetworkAclEntryOutbound?: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet1BNetworkAclAssociation
     */
    readonly privateSubnet1BNetworkAclAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BRouteTable
     */
    readonly privateSubnet2BRouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BRoute
     */
    readonly privateSubnet2BRoute?: CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BRouteTableAssociation
     */
    readonly privateSubnet2BRouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BNetworkAcl
     */
    readonly privateSubnet2BNetworkAcl?: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BNetworkAclEntryInbound
     */
    readonly privateSubnet2BNetworkAclEntryInbound?: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BNetworkAclEntryOutbound
     */
    readonly privateSubnet2BNetworkAclEntryOutbound?: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet2BNetworkAclAssociation
     */
    readonly privateSubnet2BNetworkAclAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BRouteTable
     */
    readonly privateSubnet3BRouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BRoute
     */
    readonly privateSubnet3BRoute?: CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BRouteTableAssociation
     */
    readonly privateSubnet3BRouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BNetworkAcl
     */
    readonly privateSubnet3BNetworkAcl?: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BNetworkAclEntryInbound
     */
    readonly privateSubnet3BNetworkAclEntryInbound?: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BNetworkAclEntryOutbound
     */
    readonly privateSubnet3BNetworkAclEntryOutbound?: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet3BNetworkAclAssociation
     */
    readonly privateSubnet3BNetworkAclAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BRouteTable
     */
    readonly privateSubnet4BRouteTable?: CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BRoute
     */
    readonly privateSubnet4BRoute?: CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BRouteTableAssociation
     */
    readonly privateSubnet4BRouteTableAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BNetworkAcl
     */
    readonly privateSubnet4BNetworkAcl?: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BNetworkAclEntryInbound
     */
    readonly privateSubnet4BNetworkAclEntryInbound?: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BNetworkAclEntryOutbound
     */
    readonly privateSubnet4BNetworkAclEntryOutbound?: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound;
    /**
     * @schema CfnVpcqsModulePropsResources#PrivateSubnet4BNetworkAclAssociation
     */
    readonly privateSubnet4BNetworkAclAssociation?: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnetRouteTable
     */
    readonly publicSubnetRouteTable?: CfnVpcqsModulePropsResourcesPublicSubnetRouteTable;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnetRoute
     */
    readonly publicSubnetRoute?: CfnVpcqsModulePropsResourcesPublicSubnetRoute;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet1RouteTableAssociation
     */
    readonly publicSubnet1RouteTableAssociation?: CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet2RouteTableAssociation
     */
    readonly publicSubnet2RouteTableAssociation?: CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet3RouteTableAssociation
     */
    readonly publicSubnet3RouteTableAssociation?: CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#PublicSubnet4RouteTableAssociation
     */
    readonly publicSubnet4RouteTableAssociation?: CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation;
    /**
     * @schema CfnVpcqsModulePropsResources#NAT1EIP
     */
    readonly nat1Eip?: CfnVpcqsModulePropsResourcesNat1Eip;
    /**
     * @schema CfnVpcqsModulePropsResources#NAT2EIP
     */
    readonly nat2Eip?: CfnVpcqsModulePropsResourcesNat2Eip;
    /**
     * @schema CfnVpcqsModulePropsResources#NAT3EIP
     */
    readonly nat3Eip?: CfnVpcqsModulePropsResourcesNat3Eip;
    /**
     * @schema CfnVpcqsModulePropsResources#NAT4EIP
     */
    readonly nat4Eip?: CfnVpcqsModulePropsResourcesNat4Eip;
    /**
     * @schema CfnVpcqsModulePropsResources#NATGateway1
     */
    readonly natGateway1?: CfnVpcqsModulePropsResourcesNatGateway1;
    /**
     * @schema CfnVpcqsModulePropsResources#NATGateway2
     */
    readonly natGateway2?: CfnVpcqsModulePropsResourcesNatGateway2;
    /**
     * @schema CfnVpcqsModulePropsResources#NATGateway3
     */
    readonly natGateway3?: CfnVpcqsModulePropsResourcesNatGateway3;
    /**
     * @schema CfnVpcqsModulePropsResources#NATGateway4
     */
    readonly natGateway4?: CfnVpcqsModulePropsResourcesNatGateway4;
    /**
     * @schema CfnVpcqsModulePropsResources#S3VPCEndpoint
     */
    readonly s3VpcEndpoint?: CfnVpcqsModulePropsResourcesS3VpcEndpoint;
    /**
     * @schema CfnVpcqsModulePropsResources#VPCFlowLogsRole
     */
    readonly vpcFlowLogsRole?: CfnVpcqsModulePropsResourcesVpcFlowLogsRole;
    /**
     * @schema CfnVpcqsModulePropsResources#VPCFlowLogsLogGroup
     */
    readonly vpcFlowLogsLogGroup?: CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup;
    /**
     * @schema CfnVpcqsModulePropsResources#VPCFlowLogsToCloudWatch
     */
    readonly vpcFlowLogsToCloudWatch?: CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResources(obj: CfnVpcqsModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * List of Availability Zones to use for the subnets in the VPC.
 *
 * Note: The logical order is preserved.
 *
 * @schema CfnVpcqsModulePropsParametersAvailabilityZones
 */
export interface CfnVpcqsModulePropsParametersAvailabilityZones {
    /**
     * @schema CfnVpcqsModulePropsParametersAvailabilityZones#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersAvailabilityZones#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersAvailabilityZones' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersAvailabilityZones(obj: CfnVpcqsModulePropsParametersAvailabilityZones | undefined): Record<string, any> | undefined;
/**
 * Set to true to create a network ACL protected subnet in each Availability Zone.
 *
 * If false, the CIDR parameters for those subnets will be ignored. If true, it also requires that the 'Create private subnets' parameter is also true to have any effect.
 *
 * @schema CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets
 */
export interface CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets {
    /**
     * @schema CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets(obj: CfnVpcqsModulePropsParametersCreateAdditionalPrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false when creating only private subnets.
 *
 * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
 *
 * @schema CfnVpcqsModulePropsParametersCreateNatGateways
 */
export interface CfnVpcqsModulePropsParametersCreateNatGateways {
    /**
     * @schema CfnVpcqsModulePropsParametersCreateNatGateways#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersCreateNatGateways#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersCreateNatGateways' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersCreateNatGateways(obj: CfnVpcqsModulePropsParametersCreateNatGateways | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only private subnets.
 *
 * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
 *
 * @schema CfnVpcqsModulePropsParametersCreatePublicSubnets
 */
export interface CfnVpcqsModulePropsParametersCreatePublicSubnets {
    /**
     * @schema CfnVpcqsModulePropsParametersCreatePublicSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersCreatePublicSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersCreatePublicSubnets' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersCreatePublicSubnets(obj: CfnVpcqsModulePropsParametersCreatePublicSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only public subnets.
 *
 * If false, the CIDR parameters for ALL private subnets will be ignored.
 *
 * @schema CfnVpcqsModulePropsParametersCreatePrivateSubnets
 */
export interface CfnVpcqsModulePropsParametersCreatePrivateSubnets {
    /**
     * @schema CfnVpcqsModulePropsParametersCreatePrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersCreatePrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersCreatePrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersCreatePrivateSubnets(obj: CfnVpcqsModulePropsParametersCreatePrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to true to create VPC flow logs for the VPC and publish them to CloudWatch.
 *
 * If false, VPC flow logs will not be created.
 *
 * @schema CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch
 */
export interface CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch {
    /**
     * @schema CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch(obj: CfnVpcqsModulePropsParametersCreateVpcFlowLogsToCloudWatch | undefined): Record<string, any> | undefined;
/**
 * Number of Availability Zones to use in the VPC.
 *
 * This must match your selections in the list of Availability Zones parameter.
 *
 * @schema CfnVpcqsModulePropsParametersNumberOfAZs
 */
export interface CfnVpcqsModulePropsParametersNumberOfAZs {
    /**
     * @schema CfnVpcqsModulePropsParametersNumberOfAZs#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersNumberOfAZs#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersNumberOfAZs' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersNumberOfAZs(obj: CfnVpcqsModulePropsParametersNumberOfAZs | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1A located in Availability Zone 1.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Acidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet1Acidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet1Acidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet1Acidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet1Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1B with dedicated network ACL located in Availability Zone 1.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet1Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2A located in Availability Zone 2.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Acidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet2Acidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet2Acidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet2Acidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet2Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2B with dedicated network ACL located in Availability Zone 2.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet2Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 3A located in Availability Zone 3.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Acidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet3Acidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet3Acidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet3Acidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet3Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 3B with dedicated network ACL located in Availability Zone 3.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet3Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 4A located in Availability Zone 4.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Acidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet4Acidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet4Acidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet4Acidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet4Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 4B with dedicated network ACL located in Availability Zone 4.
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr(obj: CfnVpcqsModulePropsParametersPrivateSubnet4Bcidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag1
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetATag1 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetATag1' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetATag1(obj: CfnVpcqsModulePropsParametersPrivateSubnetATag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag2
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetATag2 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetATag2' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetATag2(obj: CfnVpcqsModulePropsParametersPrivateSubnetATag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag3
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetATag3 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetATag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetATag3' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetATag3(obj: CfnVpcqsModulePropsParametersPrivateSubnetATag3 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag1
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetBTag1 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetBTag1' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetBTag1(obj: CfnVpcqsModulePropsParametersPrivateSubnetBTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag2
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetBTag2 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetBTag2' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetBTag2(obj: CfnVpcqsModulePropsParametersPrivateSubnetBTag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag3
 */
export interface CfnVpcqsModulePropsParametersPrivateSubnetBTag3 {
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPrivateSubnetBTag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPrivateSubnetBTag3' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPrivateSubnetBTag3(obj: CfnVpcqsModulePropsParametersPrivateSubnetBTag3 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnet1Cidr
 */
export interface CfnVpcqsModulePropsParametersPublicSubnet1Cidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnet1Cidr(obj: CfnVpcqsModulePropsParametersPublicSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnet2Cidr
 */
export interface CfnVpcqsModulePropsParametersPublicSubnet2Cidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnet2Cidr(obj: CfnVpcqsModulePropsParametersPublicSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 3 located in Availability Zone 3.
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnet3Cidr
 */
export interface CfnVpcqsModulePropsParametersPublicSubnet3Cidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet3Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet3Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnet3Cidr(obj: CfnVpcqsModulePropsParametersPublicSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 4 located in Availability Zone 4.
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnet4Cidr
 */
export interface CfnVpcqsModulePropsParametersPublicSubnet4Cidr {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet4Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnet4Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnet4Cidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnet4Cidr(obj: CfnVpcqsModulePropsParametersPublicSubnet4Cidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnetTag1
 */
export interface CfnVpcqsModulePropsParametersPublicSubnetTag1 {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnetTag1' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnetTag1(obj: CfnVpcqsModulePropsParametersPublicSubnetTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnetTag2
 */
export interface CfnVpcqsModulePropsParametersPublicSubnetTag2 {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnetTag2' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnetTag2(obj: CfnVpcqsModulePropsParametersPublicSubnetTag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnVpcqsModulePropsParametersPublicSubnetTag3
 */
export interface CfnVpcqsModulePropsParametersPublicSubnetTag3 {
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersPublicSubnetTag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersPublicSubnetTag3' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersPublicSubnetTag3(obj: CfnVpcqsModulePropsParametersPublicSubnetTag3 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC.
 *
 * @schema CfnVpcqsModulePropsParametersVpccidr
 */
export interface CfnVpcqsModulePropsParametersVpccidr {
    /**
     * @schema CfnVpcqsModulePropsParametersVpccidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpccidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpccidr' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpccidr(obj: CfnVpcqsModulePropsParametersVpccidr | undefined): Record<string, any> | undefined;
/**
 * (Optional) KMS Key ARN to use for encrypting the VPC flow logs data.
 *
 * If empty, encryption is enabled with CloudWatch Logs managing the server-side encryption keys.
 *
 * @schema CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey
 */
export interface CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey(obj: CfnVpcqsModulePropsParametersVpcFlowLogsCloudWatchKmsKey | undefined): Record<string, any> | undefined;
/**
 * The fields to include in the flow log record, in the order in which they should appear.
 *
 * Specify the fields using the ${field-id} format, separated by spaces. Using the Default Format as the default value.
 *
 * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat
 */
export interface CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat(obj: CfnVpcqsModulePropsParametersVpcFlowLogsLogFormat | undefined): Record<string, any> | undefined;
/**
 * Number of days to retain the VPC Flow Logs in CloudWatch.
 *
 * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention
 */
export interface CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention(obj: CfnVpcqsModulePropsParametersVpcFlowLogsLogGroupRetention | undefined): Record<string, any> | undefined;
/**
 * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
 *
 * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
 *
 * @schema CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval
 */
export interface CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval(obj: CfnVpcqsModulePropsParametersVpcFlowLogsMaxAggregationInterval | undefined): Record<string, any> | undefined;
/**
 * The type of traffic to log.
 *
 * You can log traffic that the resource accepts or rejects, or all traffic.
 *
 * @schema CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType
 */
export interface CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType(obj: CfnVpcqsModulePropsParametersVpcFlowLogsTrafficType | undefined): Record<string, any> | undefined;
/**
 * The allowed tenancy of instances launched into the VPC.
 *
 * @schema CfnVpcqsModulePropsParametersVpcTenancy
 */
export interface CfnVpcqsModulePropsParametersVpcTenancy {
    /**
     * @schema CfnVpcqsModulePropsParametersVpcTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnVpcqsModulePropsParametersVpcTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsParametersVpcTenancy' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsParametersVpcTenancy(obj: CfnVpcqsModulePropsParametersVpcTenancy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesDhcpOptions
 */
export interface CfnVpcqsModulePropsResourcesDhcpOptions {
    /**
     * @schema CfnVpcqsModulePropsResourcesDhcpOptions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesDhcpOptions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesDhcpOptions' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesDhcpOptions(obj: CfnVpcqsModulePropsResourcesDhcpOptions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpc
 */
export interface CfnVpcqsModulePropsResourcesVpc {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpc' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpc(obj: CfnVpcqsModulePropsResourcesVpc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation
 */
export interface CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation(obj: CfnVpcqsModulePropsResourcesVpcdhcpOptionsAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesInternetGateway
 */
export interface CfnVpcqsModulePropsResourcesInternetGateway {
    /**
     * @schema CfnVpcqsModulePropsResourcesInternetGateway#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesInternetGateway#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesInternetGateway' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesInternetGateway(obj: CfnVpcqsModulePropsResourcesInternetGateway | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpcGatewayAttachment
 */
export interface CfnVpcqsModulePropsResourcesVpcGatewayAttachment {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcGatewayAttachment#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcGatewayAttachment#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpcGatewayAttachment' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpcGatewayAttachment(obj: CfnVpcqsModulePropsResourcesVpcGatewayAttachment | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1A
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1A {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1A' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1A(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1B
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1B {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1B' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1B(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2A
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2A {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2A' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2A(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2B
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2B {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2B' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2B(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3A
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3A {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3A' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3A(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3B
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3B {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3B' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3B(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4A
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4A {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4A' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4A(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4B
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4B {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4B' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4B(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet1
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet1 {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet1' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet1(obj: CfnVpcqsModulePropsResourcesPublicSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet2
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet2 {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet2' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet2(obj: CfnVpcqsModulePropsResourcesPublicSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet3
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet3 {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet3' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet3(obj: CfnVpcqsModulePropsResourcesPublicSubnet3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet4
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet4 {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet4' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet4(obj: CfnVpcqsModulePropsResourcesPublicSubnet4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet1BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet2BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet3BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation
 */
export interface CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation(obj: CfnVpcqsModulePropsResourcesPrivateSubnet4BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnetRouteTable
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnetRouteTable {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnetRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnetRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnetRouteTable' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnetRouteTable(obj: CfnVpcqsModulePropsResourcesPublicSubnetRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnetRoute
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnetRoute {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnetRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnetRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnetRoute' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnetRoute(obj: CfnVpcqsModulePropsResourcesPublicSubnetRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPublicSubnet1RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPublicSubnet2RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPublicSubnet3RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation
 */
export interface CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation {
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation(obj: CfnVpcqsModulePropsResourcesPublicSubnet4RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNat1Eip
 */
export interface CfnVpcqsModulePropsResourcesNat1Eip {
    /**
     * @schema CfnVpcqsModulePropsResourcesNat1Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNat1Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNat1Eip' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNat1Eip(obj: CfnVpcqsModulePropsResourcesNat1Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNat2Eip
 */
export interface CfnVpcqsModulePropsResourcesNat2Eip {
    /**
     * @schema CfnVpcqsModulePropsResourcesNat2Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNat2Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNat2Eip' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNat2Eip(obj: CfnVpcqsModulePropsResourcesNat2Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNat3Eip
 */
export interface CfnVpcqsModulePropsResourcesNat3Eip {
    /**
     * @schema CfnVpcqsModulePropsResourcesNat3Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNat3Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNat3Eip' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNat3Eip(obj: CfnVpcqsModulePropsResourcesNat3Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNat4Eip
 */
export interface CfnVpcqsModulePropsResourcesNat4Eip {
    /**
     * @schema CfnVpcqsModulePropsResourcesNat4Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNat4Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNat4Eip' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNat4Eip(obj: CfnVpcqsModulePropsResourcesNat4Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNatGateway1
 */
export interface CfnVpcqsModulePropsResourcesNatGateway1 {
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNatGateway1' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNatGateway1(obj: CfnVpcqsModulePropsResourcesNatGateway1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNatGateway2
 */
export interface CfnVpcqsModulePropsResourcesNatGateway2 {
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNatGateway2' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNatGateway2(obj: CfnVpcqsModulePropsResourcesNatGateway2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNatGateway3
 */
export interface CfnVpcqsModulePropsResourcesNatGateway3 {
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNatGateway3' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNatGateway3(obj: CfnVpcqsModulePropsResourcesNatGateway3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesNatGateway4
 */
export interface CfnVpcqsModulePropsResourcesNatGateway4 {
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesNatGateway4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesNatGateway4' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesNatGateway4(obj: CfnVpcqsModulePropsResourcesNatGateway4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesS3VpcEndpoint
 */
export interface CfnVpcqsModulePropsResourcesS3VpcEndpoint {
    /**
     * @schema CfnVpcqsModulePropsResourcesS3VpcEndpoint#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesS3VpcEndpoint#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesS3VpcEndpoint' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesS3VpcEndpoint(obj: CfnVpcqsModulePropsResourcesS3VpcEndpoint | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsRole
 */
export interface CfnVpcqsModulePropsResourcesVpcFlowLogsRole {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpcFlowLogsRole' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpcFlowLogsRole(obj: CfnVpcqsModulePropsResourcesVpcFlowLogsRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup
 */
export interface CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup(obj: CfnVpcqsModulePropsResourcesVpcFlowLogsLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch
 */
export interface CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch {
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch#Type
     */
    readonly type?: string;
    /**
     * @schema CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch' to JSON representation.
 */
export declare function toJson_CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch(obj: CfnVpcqsModulePropsResourcesVpcFlowLogsToCloudWatch | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::VPC::VPCQS::MODULE`.
 *
 * @external
 * @cloudformationResource AWSQS::VPC::VPCQS::MODULE
 * @link http://unknown-url
 */
export declare class CfnVpcqsModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::VPC::VPCQS::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnVpcqsModuleProps;
    /**
     * Create a new `AWSQS::VPC::VPCQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVpcqsModuleProps);
}
