# generated by datamodel-codegen:
#   timestamp: 2025-10-03T21:04:43+00:00

from __future__ import annotations

from typing import Any

from msgspec import Struct


class Date(Struct):
    type: str
    label: str
    date: str


class Label(Struct):
    type: str
    body: str


class Category(Struct):
    id: int
    color: str
    distributionColor: str
    label: str
    parentLabel: str
    iconId: str
    visualId: str
    parentVisualId: str


class Status(Struct):
    id: str
    label: str


class Params(Struct):
    resourceId: str | None = None
    movement: str | None = None
    accountKey: str | None = None
    operationId: str | None = None


class Api(Struct):
    href: str
    method: str
    params: Params


class Action(Struct):
    label: str
    featureId: str
    web: str
    disabled: bool
    api: Api | None = None


class Parameters(Struct):
    date: str | None = None


class AdditionalInformation(Struct):
    id: str
    label: str
    value: str
    flags: list[Any]
    parameters: Parameters


class Question(Struct):
    title: str
    answer: str


class HelpSection(Struct):
    title: str
    questions: list[Question]


class Operation(Struct):
    id: str
    amount: float
    typeId: str
    accountKey: str
    dates: list[Date]
    labels: list[Label]
    currency: str
    tags: list[Any]
    flags: list[str]
    category: Category
    comments: list[Any]
    status: Status
    relatedOperations: list[Any]
    actions: list[Action]
    additionalInformations: list[AdditionalInformation] | None = None
    attachmentsLabels: list[Any] | None = None
    products: list[Any] | None = None
    transactionTypeLabel: str | None = None
    city: str | None = None
    cardOwnerName: str | None = None
    supplierFound: str | None = None
    helpSection: HelpSection | None = None


class BoursoApiOperation(Struct):
    operation: Operation

    def getDate(self):
        for dt in self.operation.dates:
            if dt.type == "operation_date":
                return dt.date
