Contribution Guide
==================
Anyone is more than welcome to contribute to the development of warnings-plugin,
no matter your programming skill level. It is the reviewer's obligation to help bring your
contribution to our desired quality level and you should do your best to help the reviewer
understand your decisions. Standard GitHub flow is used https://guides.github.com/introduction/flow/
to start Pull Requests, which are then merged. We also prefer to make a Work In Progress
Merge request once you starting your work just in case someone else is not working on the
same issue.

Getting Started
===============
There may be a few issues opened to request new features, but you are also
more than welcome to make some of your own suggestions. The `help wanted` label
indicates that it is an easy enough task for anyone to start with, so go and pick up the
feature you feel most excited about and start implementing it.

Quality of Contribution
-----------------------
All new contributions need to be properly tested. We are not targeting some coverage
percentage but rather focus on regression testing to confirm expected functionality
and border cases. This will help us keep existing features even after years of constant
development and it helps fixing regression bugs.

Documentation
-------------
Basic documentation is expected, but every bit of detail you can include will help in
the future. It might look obvious, but it will also help everyone reviewing the code to
correctly understand the intended functionality so that they can focus more on the implementation
aspect.

Code Review
-----------
Anyone is more than welcome to check open Pull requests and make a code review. Everyone
benefits from fresh eyes looking at new features or bug fixes and it also improves
coding skills of all included. Remember to act politely. Since some people might not be
frequent contributors to various repositories, do not intimidate them, but rather
help them improve. We are all learning.

Reporting Issues or Requesting a New Feature
============================================
Please open a new Issue if you have any problems with the plugin. We will be happy
to fix them as soon as possible. If you want some feature to be included but do not know
where to start, you should also open an Issue with label `enhancement` and we
can implement it when we have time and it fits in our view.
