# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['archimedes_config']

package_data = \
{'': ['*']}

install_requires = \
['cryptography>=39.0.1,<40.0.0', 'toml>=0.10.2,<0.11.0']

extras_require = \
{'archimedes-config': ['azure-keyvault-secrets', 'azure-identity']}

setup_kwargs = {
    'name': 'archimedes-config',
    'version': '0.0.6',
    'description': '',
    'long_description': '# archimedes-config\n\nThis library handles config files for services used by Optimeering AS.\n\nThe library is built around `ConfigManager` class. An instance of this class is meant to represent a single set of configuration for the execution environment. The library can also be used to encrypt and decrypt configurations selectively for security.\n\n## Installation\nThe library is published on PyPi as "archimedes-config".\n\n### Pip\n\n```\n# Base installation\npip install archimedes_config\n\n# Installation with keyvault feature\npip install archimedes_config[archimedes_config]\n```\n\n### Poetry\n\n```\n# Base Installation \npoetry add archimedes_config\n\n# Installation with keyvault feature\npoetry add archimedes_config[archimedes_config]\n```\n\n### Using azure key vault for secret key management\n\nTo authenticate to azure key vault service, `AZURE_TENANT_ID` , `AZURE_CLIENT_ID` and `AZURE_CLIENT_SECRET` should be set up as environment variable. If any one of these environment variables have not been set up, the authentication will instead be done though Azure CLI utility. Failing both the authentication process will raise an exception.\n\n## Configuration Specification\n\n1. The configuration should be in TOML standard.\n2. There should be no root level configuration.\n3. All the configurations are expected to be under one and only one level of group.\n4. Each configuration must have `value` key where the value for the configuration must be store. All types supported by TOML are supported.\n5. Additionally, each configuration can optionally have another key `encrypted`. The value for this must be boolean. This flag determines if the provided value is a secret; i.e. if the value must be encrypted or decrypted.\n6. If `encrypted` is True, the `value` field must be a string.\n7. If `encrypted` field is not available in the configuration, the `value` will be treated as an unprotected config and will be excluded from encryption and decryption.\n\n\n    The library has adequate functionality to create a new configuration and add key values to existing ones. \n    While it is possible to manually create/ edit the cnfiguration, it is recomended to use the functionality provided to make changes to the configurations.\n\n### Configuration keys\n\n1. Key `_IS_CONFIG_ENCRYPTED` under  `CONFIGURATIONS` group : \n   - Used to determine encryption state of the configuration during load.\n   - This is a required configuration.\n2. Key `VAULT_NAME` under  `AZURE_KEYVAULT` group :\n   - Name of vault to connect to.\n   - Only required if Key Vault feature is used.\n3. Key `VAULT_KEY` under  `AZURE_KEYVAULT` group :\n   - Name of the key holding the encryption/decryption secret is store.\n   - Only required if Key Vault feature is used. \n\n\n## Usage\n\n### Import ConfigManager class\n\n`from archimedes_config import ConfigManager`\n\nConfigManger is an in memory storage for all the configuration.\n\nFeatures related to azure key vaults has been implemented in another Manager class.\nTo use keyvault features, use `KeyvaultConfigManager` instead.\n\n`from archimedes_config import KeyvaultConfigManager`\n\nAll the interfaces for the two classes are same except the addition of `set_default_key_from_key_vault` method to set the secret key configured in azure vault as the default key for encryption and decryption of configurations.\n\n### Create a new configuration set\n\n```\nconfig = ConfigManager()\nconfig.create()\n```\n\nThis instantiates a new config in memory.\n\n### Load an existing configuration set\n\n```\nconfig = ConfigManager()\nconfig.load(path = <PATH_TO_CONFIG> )\n```\n\nThe `load` method optionally has the following parameters:\n1. `default_key`\n   - Assigns a default secret for encryption and decryption\n2. `decrypt_on_load`\n    - Decrypts the configurations on load\n\n### Assign a default key\n\nFernet can be used to create a new key.\n```\nfrom cryptography.fernet import Fernet\nsecret = Fernet.Fernet.generate_key()\n```\n\nTo add the key as a default key for the configuration instance.\n```\nconfig.set_default_key(key = secret)\n```\n\nTo add secret from Azure key vault as encryption/ decryption key,\n```\nconfig = KeyvaultConfigManager()\nconfig.set_default_key_from_key_vault()\n```\n\n### Add new configuration\n\nTo add a new configuration key value pair,\n```\nconfig.add_new_config(\n        group_name = <NAME_OF_GROUP> ,\n        key_name = <KEY_NAME>,\n        unencrypted_values = <CONFIG_VALUE>,\n        encrypted = <ENCRYPTION_FLAG>\n    )\n```\nAdditionally, the method optionally supports the following parameters:\n\n1. `create_group_if_not_exist`\n   - Boolean flag.\n   - If True, creates new group if the group doesn\'t exist.\n   - If False, raised an exception if the group doesn\'t exist.\n   - \n2. `allow_updating`\n   - Boolean flag.\n   - If True, allows update of existing key value pair.\n   - If False, raises an exception if key value pair already exists.\n\n### Encrypt configurations\nEncrypts all the configurations.\n```\nconfig.encrypt_configs()\n```\n\n### Decrypt configurations\n\nDecrypts all the configuration.\n```\nconfig.decrypt_configs()\n```\n\n### List all groups in configurations\n\n```\nconfig.list_groups()\n```\n\n### List all keys under a group\n\n```\nconfig.list_keys(group = <NAME_OF_GROUP>)\n```\n\n### Get a single value for configuration\n\n```\nvalue = config.get(<NAME_OF_GROUP> , <NAME_OF_KEY>)\n```\nThe `get` method optionally has `default_return` parameter. By default, if the group or the key is not found in the configuration set, a Key error is raised. If `default_return` is set, if the group or the key is not found, the value provided under `default_return` is returned instead.\n\n### Saving a configuration set\n\n```\nconfig.save()\n```\n\nThe `save` method optionally accepts the following parameters:\n1. `path`\n    - Path to save the configuration set.\n     - If not set, will overwrite the configuration in the path used while calling the `load` method.\n2. `allow_saving_decrypted`\n    - Allows saving decrypted config.\n     - By default, attempting to save a decrypted config results in an exception for security purposes. This flag allows saving protected secrets in plain text.\n\n\n> All the operations performed on the configuration instance is performed on memory. \n`To persist the changes onto local disk, `save` method must be called.\n\n### Generating a new key and encrypting configuration with the new key\n\n```\nconfig.create_new_key(<PATH_TO_SAVE_NEW_CONFIGURATION>, <PATH_TO_SAVE_NEW_KEY>)\n```\nThe `create_new_key` method generates a new key and encrypts the loaded config with the new key. \nThe new config and key is exported to provided paths respectively.\n',
    'author': 'BigyaPradhan',
    'author_email': 'bigya.pradhan@optimeering.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7.0,<3.12',
}


setup(**setup_kwargs)
