#!/usr/bin/env python
# coding: utf-8
# /*##########################################################################
#
# Copyright (c) 2017 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/
"""This module describe tomwer applications which are available  through
the silx launcher.

Your environment should provide a command `tomwer`. You can reach help with
`tomwer --help`, and check the version with `tomwer --version`.
"""

__authors__ = ["H. Payno"]
__license__ = "MIT"
__date__ = "06/12/2019"


import logging
logging.basicConfig()

import sys
from silx.utils.launcher import Launcher
try:
    import est._version
    import_version = True
except ImportError:
    import_version = False


def main():
    """Main function of the launcher

    This function is referenced in the setup.py file, to create a
    launcher script generated by setuptools.

    :rtype: int
    :returns: The execution status
    """
    if import_version is False:
        _version = '???'
    else:
        _version = est._version.version
    launcher = Launcher(prog="est", version=_version)
    launcher.add_command("process",
                         module_name="est.app.process",
                         description="process a workflow from a .xml.ows file"
                                     "description")
    launcher.add_command("test",
                         module_name="est.app.test_",
                         description="Launch est unittest")
    status = launcher.execute(sys.argv)
    return status


if __name__ == "__main__":
    # executed when using python -m PROJECT_NAME
    status = main()
    sys.exit(status)
