# Scikit-bot

[![CI](https://github.com/FirefoxMetzger/ropy/actions/workflows/ci.yml/badge.svg)](https://github.com/FirefoxMetzger/ropy/actions/workflows/ci.yml)
[![CD](https://github.com/FirefoxMetzger/ropy/actions/workflows/cd.yml/badge.svg)](https://github.com/FirefoxMetzger/ropy/actions/workflows/cd.yml)
[![codecov](https://codecov.io/gh/FirefoxMetzger/scikit-bot/branch/main/graph/badge.svg?token=VNND9WET47)](https://codecov.io/gh/FirefoxMetzger/scikit-bot)
[![Documentation Status](https://readthedocs.org/projects/robotics-python/badge/?version=latest)](https://scikit-bot.org/en/latest/?badge=latest)

scikit-bot is a robotics library that aims to address the large heterogeneity of
code in the robotics community by providing a selection of commonly used
algorithms and functions in an easy access manner. It focusses on begin easy to
use and on enabling rapid prototyping.

- **Curious**? Check out our detailed [API
  documentation](https://robotics-python.readthedocs.io/en/latest/api_reference.html)
  to see if there is anything that meets your need. 
- Got an **idea for a new feature** or spotted something that is missing? Submit
  a [feature request](https://github.com/FirefoxMetzger/ropy/issues).
- Want to **contribute code**? Awesome! We are very happy about PRs. You can
  check open issues (may I suggest a [good first
  issue](https://github.com/FirefoxMetzger/ropy/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22))
  for an overview of what is currently needed. Alternatively, you can submit a
  new [feature request](https://github.com/FirefoxMetzger/ropy/issues) and -
  after we figured out where the feature should go - you can submit a PR for
  exactly this feature.

**Note:** If you find any part of the API particularly useful in its current
form, please leave a note in the issue section (and a comment on what could be
improved). Feedback like this helps maturing the API more quickly. This way, we
can keep the things that are useful and improve the things that aren't.

### Why does ropy redirect here?

Originally this library was named ropy, because it didn't seem grand enough to
be a fully grown scikit. However, as things evolved, it was rebranded into
scikit-bot.
