# Code of Conduct

## Our Pledge

The Qiskit Community is dedicated to our values of treating every individual
with respect and dignity. In the interest of fostering an open and welcoming
environment, all participants, including attendees, speakers, sponsors,
volunteers, online contributors, and IBM employees are expected to show
courtesy for each other and our community by creating a harassment-free
experience for everyone, regardless of age, personal appearance, disability,
ethnicity, gender identity and expression, body size, level of experience,
nationality, race, religion, caste, or sexual identity and orientation.
Expected behavior applies to both online and offline engagement within the
Qiskit Community.

## Scope

The purpose of this Code of Conduct is to define and enforce the values and
conduct of contributors and participants in the Qiskit open source community.
The Code of Conduct applies both within project spaces and in public spaces
when an individual is engaging with the Qiskit open source community. Examples
include attending a Qiskit event, contributing to online projects, commentary
on Slack, or representing a project or community, including using an official
project e-mail address, posting via an official social media account, or
acting as an appointed representative at an online or offline event.
Representation of a project may be further defined and clarified by project
maintainers.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

- Using welcoming and inclusive language
- Being respectful of differing viewpoints, experiences, and cultures
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members
- Being mindful of your surroundings and your fellow participants and listening
  to others
- Valuing the contributions of all participants
- Engaging in collaboration before conflict
- Pointing out unintentionally racist, sexist, casteist, or biased comments and
  jokes made by community members when they happen

Examples of unacceptable behavior by participants, even when presented as
"ironic" or "joking," include:

- The use of sexualized language or imagery and unwelcome physical contact,
  sexual attention, or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment, including offensive or degrading language
- Publishing others' private information, such as a physical or electronic
  address, without explicit permission. This includes any sort of "outing" of
  any aspect of someone's identity without their consent.
- "Doxxing," Publishing screenshots or quotes, especially from identity slack
  channels, private chat, or public events, without all quoted users' explicit
  consent.
- Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Responsibilities & Enforcement

The entire Qiskit community is responsible for upholding the terms of the Code
of Conduct in Qiskit Community events and spaces and reporting violations if
they see them. The internal Qiskit team at IBM is ultimately responsible for
clarifying the standards of acceptable behavior and enforcement, and is expected
to take appropriate and fair corrective action in response to any instances of
unacceptable behavior.

If a participant or contributor engages in negative or harmful behavior, IBM
will take any action they deem appropriate, including but not limited to
issuing warnings, expulsion from an event with no refund, deleting comments,
permanent banning from future events or online community, or calling local law
enforcement. IBM has the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, or to temporarily or permanently ban any
contributor or participant for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

If you see a Code of Conduct violation:

1. If you feel comfortable, let the person know that what they did is not
   appropriate and ask them to stop and/or edit or delete their message(s) or
   comment(s).
2. If the person does not immediately stop the behavior or correct the issue,
   or if you're uncomfortable speaking up, flag a moderator and, if appropriate,
   fill out the anonymous
   [Code of Conduct violation form](https://airtable.com/shrl5mEF4Eun1aIDm).
3. The Qiskit Community will open an investigation upon receiving your form
   entry. When reporting, please include any relevant details, links,
   screenshots, context, or other information that may be used to better
   understand and resolve the situation.
4. If the code of conduct violation occurs at an event and requires immediate
   response or contains a concern about an individual attending an upcoming
   event, contact the event's on-call Code of Conduct point of contact listed
   in the event specific code of conduct document. If you don't feel comfortable
   speaking to the point of contact in person, fill out a Code of Conduct
   violation form entry and include the details of the event so that the Code of
   Conduct enforcement board can contact the event's on-call Code of Conduct
   point of contact.
5. If an IBM employee witnesses a Code of Conduct violation at any time, such as
   at events, in a Slack channel, or open source forums, it is their
   responsibility to file a Code of Conduct violation report.

This Code of Conduct does not supersede existing IBM corporate policies, such as
the IBM Business Conduct Guidelines and IBM Business Partner Code of Conduct.
IBM employees must follow IBM's Business Conduct Guidelines. IBM's business
partners must follow the IBM Business Partner Code of Conduct. IBM employees
concerned with a fellow IBMer's behavior should follow IBM's own internal HR
reporting protocols, which include engaging the offending IBMer's manager and
involving IBM Concerns and Appeals. IBM employees concerned with an IBM
business partner's behavior should notify tellibm@us.ibm.com.
