import threading


class GeneratorMeta(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super().__call__(*args, **kwargs)
        return cls._instances[cls]


class GeneratorBase(metaclass=GeneratorMeta):

    def __init__(self):
        self.lock = threading.Lock()

    def generate(self):
        pass

