# Generated by Django 3.1.2 on 2021-01-17 17:44

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("authentication", "0017_remove_fleetup_permission"),
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (("basic_access", "Can access this app"),),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="LeaveOfAbsence",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "start",
                    models.DateField(help_text="The start of the leave of absence."),
                ),
                (
                    "end",
                    models.DateField(
                        blank=True,
                        help_text="The end of the leave of absence. Leave blank for an indefinite leave.",
                        null=True,
                    ),
                ),
                ("notes", models.TextField(blank=True)),
                (
                    "approver",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="InactivityPingConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Internal name for the ping config. Must be unique.",
                        max_length=48,
                        unique=True,
                    ),
                ),
                (
                    "days",
                    models.PositiveIntegerField(
                        help_text="The number of days the user must be inactive."
                    ),
                ),
                (
                    "text",
                    models.TextField(
                        help_text="The text of the message or notification sent to the end user."
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Groups subject to the inactivity ping. If empty, applies to all groups.",
                        related_name="_inactivitypingconfig_groups_+",
                        to="auth.Group",
                    ),
                ),
                (
                    "states",
                    models.ManyToManyField(
                        blank=True,
                        help_text="States subject to the inactivity ping. If empty, applies to all states.",
                        related_name="_inactivitypingconfig_states_+",
                        to="authentication.State",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="InactivityPing",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField()),
                (
                    "config",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inactivity.inactivitypingconfig",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
    ]
