#
# Makefile.PL for egd, the entropy gathering daemon
#
# $Id: Makefile.PL,v 1.13 2002/07/25 08:01:00 warner Exp $
#

use ExtUtils::MakeMaker;

# This module is meant to function both by itself and as a part of GnuPG.

# By itself, just build with the usual 'perl Makefile.PL; make; make test;
#  sudo make install' sequence. This will install the daemon in your standard
#  perl script directory, frequently /usr/local/bin . As a daemon process that
#  may be run by the sysadmin at startup instead of by normal users, you might
#  want it in /usr/local/sbin instead. Set INSTALLBIN as an argument (see
#  below) to accomplish this.

# As a part of GPG, this Makefile.PL is run at configure time if EGD is needed
# for this system, probably because it doesn't have /dev/random, which
# generally means anything other than Linux. The top-level configure script
# should call us with two args:
#   FULLPERL=/path/to/perl   # this is the perl5 found by configure, and must
#                              be the same one as used to run this Makefile.PL
#   INSTALLBIN=/usr/local/sbin  # this is configure's $sbindir. 'egd' goes here

# We must test for the presence of the SHA module and arrange to build/install
# a local copy if it isn't already there.


# test for Digest::SHA1
eval "use Digest::SHA1;"; $has_SHA = $@ eq "";

if ($has_SHA) {
    print " Digest::SHA1 module found.. no need to install our own.\n";
} else {
    print " Digest::SHA1 module not found. We will install our own.\n";
}

# this is to turn the automake-style 'check' target into a MakeMaker-style
# 'test' target.
sub MY::postamble {
    "check :: test\n";
}

WriteMakefile(
	      NAME => "egd",
	      VERSION => "0.9",
	      EXE_FILES => [qw(egd.pl)],
# recent MakeMakers will fix up the shbang line in EXE_FILES. This will
# result in /usr/local/sbin/egd.pl being installed with whatever #! line is
# appropriate for this system.
	      DIR => $has_SHA ? [] : ['Digest-SHA1-2.00'],
	      # DIR is the list of subdirs. If Digest::SHA1 is already
	      # installed, tell MakeMaker to pretend our copy isn't there.
	      PM => {}, # disable installation of egd.pl in library directory
	      'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
);
