#!/usr/bin/env python
from setuptools import setup, find_packages
import os
from pathlib import Path

here = Path(__file__).parent.absolute()
with open('src/paratc/_version.py') as f:  
    exec(f.read())

# Get the long description from the README file
with open(here.joinpath('README.md'), encoding='utf-8') as f:
    long_description = f.read()
    setup(    
        name='paratc',    
        version=__version__,    
        description='Functions for creating parametric tropical cyclone models.',    
        long_description=long_description,    
        long_description_content_type="text/markdown",    
        url='https://github.com/davbyr/ParaTC',    
        author='David Byrne',    
        author_email='dbyrne@woodwellclimate.org',       
        packages=find_packages(where = 'src'),
        package_dir={"": "src"},
        install_requires = [ 'pandas',
                              'numpy',
                              'matplotlib',
                              'xarray',
                              'netcdf4',
                              'jupyterlab',
                              'pip',
                              'xesmf',
                              'shapely'])