# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['arguable']

package_data = \
{'': ['*']}

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.6.1,<2.0.0']}

setup_kwargs = {
    'name': 'arguable',
    'version': '1.0',
    'description': 'class-level configuration via argparse',
    'long_description': '.. image:: https://github.com/Dominik1123/arguable/workflows/Tests/badge.svg\n   :target: https://github.com/Dominik1123/arguable/actions?workflow=Tests\n\n.. image:: https://codecov.io/gh/Dominik1123/arguable/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/Dominik1123/arguable\n\n.. image:: https://img.shields.io/pypi/v/arguable.svg\n   :target: https://pypi.org/project/arguable/\n\n\nArguable\n========\n\n"arguable" stands for "argparse configurable". This project enables class-level configuration via argparse and the command line interface.\n\n\nInstallation\n------------\n\n.. code-block::\n\n   pip install arguable\n\n\nUsage\n-----\n\nClasses inheriting from ``arguable.Arguable`` define a class-level\n``argparse.Namespace`` object ``config`` which holds relevant\nparameters and their defaults. The corresponding argument parser is\ncreated automatically from these parameters and is stored as the\n``config_parser`` class attribute.\n\nFor example:\n\n.. code-block:: python\n\n   from argparse import Namespace\n   from arguable import Arguable\n\n\n   class Example(Arguable):\n       config = Namespace(language=\'en\')\n\n\n   print(Example().config.language)\n\nWhen the class is created, the ``Example.config_parser`` attribute holds\nan argument parser with an argument ``--example-language`` with\n``type=str`` and ``default=\'en\'``.\n\nWhen the class is instantiated it automatically configures its instances\nby assigning an instance-level attribute ``config`` which picks up the\nprovided command line arguments and shadows the class-level ``config`` defaults.\n\nSo invoking the above script via ``python example.py --example-language=de`` prints ``de`` while omitting the parameter uses the default ``en``.\n\n\nParameter types\n~~~~~~~~~~~~~~~\n\nOther supported parameter types are sequences (e.g. tuples) which will\nuse the following argument definition:\n\n.. code-block:: python\n\n   # `par` is the tuple parameter default.\n   parser.add_argument(name, type=type(par[0]), nargs=len(par), default=par)\n\n``bool``:\n\n.. code-block:: python\n\n   # `par` is the bool parameter default.\n   parser.add_argument(name, action=f\'store_{"false" if par else "true"}\')\n\nand of course all the numeric types.\n\n\nCustomization\n~~~~~~~~~~~~~\n\nBy default the class name in lowercase will be used as a prefix for\nparameter names. This can be configured by two class variables:\n\n* ``config_prefix`` -- If provided then this is used directly as the prefix.\n* ``config_removesuffix`` -- If ``config_prefix`` is not provided,\n  the class name in lowercase is used and reduced by this suffix\n  (if provided).\n\nThese variables can also be provided during class creation without\nthe ``config_`` prefix, e.g.:\n\n.. code-block:: python\n\n   class ExampleA(Arguable, prefix=\'test\'):\n       config_prefix = \'text\'  # similar\n\n\n   class ExampleB(Arguable, removesuffix=\'b\'):\n       config_removesuffix = \'b\'  # similar\n\n\nShowing the full help text\n~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nIn order to make the application aware of all registered parameters,\nthe ``Arguable`` class has a ``super_parser`` attribute which is an\ninstance of ``argparse.ArgumentParser``. Whenever a class registers\nnew parameters, not only the class-level parser ``config_parser`` gets\nupdated, but also the application-level ``super_parser``. This parser\ncan be used to show the help text involving all parameters.\n\nThis package provides a helper parser class, ``arguable.ArgumentParser``,\nwhich automatically falls back on ``super_parser`` when ``--help``\nis requested.\n\nThis ``super_parser`` can also be used used to verify the correctness of\nall given parameters. Since every class is only concerned with their own\nparameters, excess arguments are simply ignored (using ``parse_known_args``).\nUsing the ``super_parser`` one can verify that all provided arguments\nare supported by the application:\n\n.. code-block:: python\n\n   from arguable import Arguable\n\n\n   if __name__ == \'__main__\':\n       # The following will report any excess arguments.\n       Arguable.super_parser.parse_args()\n',
    'author': 'Dominik1123',
    'author_email': '15989985+Dominik1123@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Dominik1123/arguable',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
