# generated by datamodel-codegen:
#   filename:  bom-1.4.schema.json
#   timestamp: 2022-09-13T13:16:29+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, List, Optional, Union

from pydantic import AnyUrl, BaseModel, EmailStr, Extra, Field, conint, constr

from . import spdx


class _Schema(Enum):
    http___cyclonedx_org_schema_bom_1_4_schema_json = (
        'http://cyclonedx.org/schema/bom-1.4.schema.json'
    )


class BomFormat(Enum):
    CycloneDX = 'CycloneDX'


class RefType(BaseModel):
    __root__: str


class OrganizationalContact(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = Field(
        None,
        description='The name of a contact',
        examples=['Contact name'],
        title='Name',
    )
    email: Optional[EmailStr] = Field(
        None,
        description='The email address of the contact.',
        examples=['firstname.lastname@example.com'],
        title='Email Address',
    )
    phone: Optional[str] = Field(
        None,
        description='The phone number of the contact.',
        examples=['800-555-1212'],
        title='Phone',
    )


class Type(Enum):
    application = 'application'
    framework = 'framework'
    library = 'library'
    container = 'container'
    operating_system = 'operating-system'
    device = 'device'
    firmware = 'firmware'
    file = 'file'


class Scope(Enum):
    required = 'required'
    optional = 'optional'
    excluded = 'excluded'


class Encoding(Enum):
    base64 = 'base64'


class Attachment(BaseModel):
    class Config:
        extra = Extra.allow

    contentType: Optional[str] = Field(
        'text/plain',
        description='Specifies the content type of the text. Defaults to text/plain if not specified.',
        title='Content-Type',
    )
    encoding: Optional[Encoding] = Field(
        None,
        description='Specifies the optional encoding the text is represented in.',
        title='Encoding',
    )
    content: str = Field(
        ...,
        description='The attachment data. Proactive controls such as input validation and sanitization should be employed to prevent misuse of attachment text.',
        title='Attachment Text',
    )


class HashAlg(Enum):
    MD5 = 'MD5'
    SHA_1 = 'SHA-1'
    SHA_256 = 'SHA-256'
    SHA_384 = 'SHA-384'
    SHA_512 = 'SHA-512'
    SHA3_256 = 'SHA3-256'
    SHA3_384 = 'SHA3-384'
    SHA3_512 = 'SHA3-512'
    BLAKE2b_256 = 'BLAKE2b-256'
    BLAKE2b_384 = 'BLAKE2b-384'
    BLAKE2b_512 = 'BLAKE2b-512'
    BLAKE3 = 'BLAKE3'


class HashContent(BaseModel):
    __root__: constr(
        regex=r'^([a-fA-F0-9]{32}|[a-fA-F0-9]{40}|[a-fA-F0-9]{64}|[a-fA-F0-9]{96}|[a-fA-F0-9]{128})$'
    ) = Field(
        ..., examples=['3942447fac867ae5cdb3229b658f4d48'], title='Hash Content (value)'
    )


class Type1(Enum):
    unofficial = 'unofficial'
    monkey = 'monkey'
    backport = 'backport'
    cherry_pick = 'cherry-pick'


class Diff(BaseModel):
    class Config:
        extra = Extra.allow

    text: Optional[Attachment] = Field(
        None, description='Specifies the optional text of the diff', title='Diff text'
    )
    url: Optional[str] = Field(
        None, description='Specifies the URL to the diff', title='URL'
    )


class Type2(Enum):
    defect = 'defect'
    enhancement = 'enhancement'
    security = 'security'


class Source(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = Field(
        None,
        description="The name of the source. For example 'National Vulnerability Database', 'NVD', and 'Apache'",
        title='Name',
    )
    url: Optional[str] = Field(
        None,
        description='The url of the issue documentation as provided by the source',
        title='URL',
    )


class Issue(BaseModel):
    class Config:
        extra = Extra.allow

    type: Type2 = Field(..., description='Specifies the type of issue', title='Type')
    id: Optional[str] = Field(
        None,
        description='The identifier of the issue assigned by the source of the issue',
        title='ID',
    )
    name: Optional[str] = Field(None, description='The name of the issue', title='Name')
    description: Optional[str] = Field(
        None, description='A description of the issue', title='Description'
    )
    source: Optional[Source] = Field(
        None,
        description='The source of the issue where it is documented',
        title='Source',
    )
    references: Optional[List[str]] = Field(
        None,
        description="A collection of URL's for reference. Multiple URLs are allowed.",
        examples=['https://example.com'],
        title='References',
    )


class IdentifiableAction(BaseModel):
    class Config:
        extra = Extra.allow

    timestamp: Optional[datetime] = Field(
        None,
        description='The timestamp in which the action occurred',
        title='Timestamp',
    )
    name: Optional[str] = Field(
        None,
        description='The name of the individual who performed the action',
        title='Name',
    )
    email: Optional[EmailStr] = Field(
        None,
        description='The email address of the individual who performed the action',
        title='E-mail',
    )


class Type3(Enum):
    vcs = 'vcs'
    issue_tracker = 'issue-tracker'
    website = 'website'
    advisories = 'advisories'
    bom = 'bom'
    mailing_list = 'mailing-list'
    social = 'social'
    chat = 'chat'
    documentation = 'documentation'
    support = 'support'
    distribution = 'distribution'
    license = 'license'
    build_meta = 'build-meta'
    build_system = 'build-system'
    release_notes = 'release-notes'
    other = 'other'


class Dependency(BaseModel):
    class Config:
        extra = Extra.allow

    ref: RefType = Field(
        ...,
        description='References a component by the components bom-ref attribute',
        title='Reference',
    )
    dependsOn: Optional[List[RefType]] = Field(
        None,
        description='The bom-ref identifiers of the components that are dependencies of this dependency object.',
        title='Depends On',
        
    )


class DataFlow(Enum):
    inbound = 'inbound'
    outbound = 'outbound'
    bi_directional = 'bi-directional'
    unknown = 'unknown'


class Copyright(BaseModel):
    class Config:
        extra = Extra.allow

    text: str = Field(..., title='Copyright Text')


class AggregateType(Enum):
    complete = 'complete'
    incomplete = 'incomplete'
    incomplete_first_party_only = 'incomplete_first_party_only'
    incomplete_third_party_only = 'incomplete_third_party_only'
    unknown = 'unknown'
    not_specified = 'not_specified'


class Property(BaseModel):
    name: Optional[str] = Field(
        None,
        description='The name of the property. Duplicate names are allowed, each potentially having a different value.',
        title='Name',
    )
    value: Optional[str] = Field(
        None, description='The value of the property.', title='Value'
    )


class LocaleType(BaseModel):
    __root__: constr(regex=r'^([a-z]{2})(-[A-Z]{2})?$') = Field(
        ...,
        description='Defines a syntax for representing two character language code (ISO-639) followed by an optional two character country code. The language code MUST be lower case. If the country code is specified, the country code MUST be upper case. The language code and country code MUST be separated by a minus sign. Examples: en, en-US, fr, fr-CA',
        title='Locale',
    )


class ReleaseType(BaseModel):
    __root__: str = Field(
        ...,
        description="The software versioning type. It is RECOMMENDED that the release type use one of 'major', 'minor', 'patch', 'pre-release', or 'internal'. Representing all possible software release types is not practical, so standardizing on the recommended values, whenever possible, is strongly encouraged.\n\n* __major__ = A major release may contain significant changes or may introduce breaking changes.\n* __minor__ = A minor release, also known as an update, may contain a smaller number of changes than major releases.\n* __patch__ = Patch releases are typically unplanned and may resolve defects or important security issues.\n* __pre-release__ = A pre-release may include alpha, beta, or release candidates and typically have limited support. They provide the ability to preview a release prior to its general availability.\n* __internal__ = Internal releases are not for public consumption and are intended to be used exclusively by the project or manufacturer that produced it.",
        examples=['major', 'minor', 'patch', 'pre-release', 'internal'],
    )


class Note(BaseModel):
    class Config:
        extra = Extra.allow

    locale: Optional[LocaleType] = Field(
        None,
        description='The ISO-639 (or higher) language code and optional ISO-3166 (or higher) country code. Examples include: "en", "en-US", "fr" and "fr-CA"',
        title='Locale',
    )
    text: Attachment = Field(
        ...,
        description='Specifies the full content of the release note.',
        title='Release note content',
    )


class ReleaseNotes(BaseModel):
    class Config:
        extra = Extra.allow

    type: ReleaseType = Field(
        ...,
        description='The software versioning type the release note describes.',
        title='Type',
    )
    title: Optional[str] = Field(
        None, description='The title of the release.', title='Title'
    )
    featuredImage: Optional[str] = Field(
        None,
        description='The URL to an image that may be prominently displayed with the release note.',
        title='Featured image',
    )
    socialImage: Optional[str] = Field(
        None,
        description='The URL to an image that may be used in messaging on social media platforms.',
        title='Social image',
    )
    description: Optional[str] = Field(
        None, description='A short description of the release.', title='Description'
    )
    timestamp: Optional[datetime] = Field(
        None,
        description='The date and time (timestamp) when the release note was created.',
        title='Timestamp',
    )
    aliases: Optional[List[str]] = Field(
        None,
        description='One or more alternate names the release may be referred to. This may include unofficial terms used by development and marketing teams (e.g. code names).',
        title='Aliases',
    )
    tags: Optional[List[str]] = Field(
        None,
        description='One or more tags that may aid in search or retrieval of the release note.',
        title='Tags',
    )
    resolves: Optional[List[Issue]] = Field(
        None,
        description='A collection of issues that have been resolved.',
        title='Resolves',
    )
    notes: Optional[List[Note]] = Field(
        None,
        description='Zero or more release notes containing the locale and content. Multiple note objects may be specified to support release notes in a wide variety of languages.',
        title='Notes',
    )
    properties: Optional[List[Property]] = Field(
        None,
        description='Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.',
        title='Properties',
    )


class Advisory(BaseModel):
    class Config:
        extra = Extra.allow

    title: Optional[str] = Field(
        None, description='An optional name of the advisory.', title='Title'
    )
    url: str = Field(
        ..., description='Location where the advisory can be obtained.', title='URL'
    )


class Cwe(BaseModel):
    __root__: conint(ge=1) = Field(
        ...,
        description='Integer representation of a Common Weaknesses Enumerations (CWE). For example 399 (of https://cwe.mitre.org/data/definitions/399.html)',
        title='CWE',
    )


class Severity(Enum):
    critical = 'critical'
    high = 'high'
    medium = 'medium'
    low = 'low'
    info = 'info'
    none = 'none'
    unknown = 'unknown'


class ScoreMethod(Enum):
    CVSSv2 = 'CVSSv2'
    CVSSv3 = 'CVSSv3'
    CVSSv31 = 'CVSSv31'
    OWASP = 'OWASP'
    other = 'other'


class ImpactAnalysisState(Enum):
    resolved = 'resolved'
    resolved_with_pedigree = 'resolved_with_pedigree'
    exploitable = 'exploitable'
    in_triage = 'in_triage'
    false_positive = 'false_positive'
    not_affected = 'not_affected'


class ImpactAnalysisJustification(Enum):
    code_not_present = 'code_not_present'
    code_not_reachable = 'code_not_reachable'
    requires_configuration = 'requires_configuration'
    requires_dependency = 'requires_dependency'
    requires_environment = 'requires_environment'
    protected_by_compiler = 'protected_by_compiler'
    protected_at_runtime = 'protected_at_runtime'
    protected_at_perimeter = 'protected_at_perimeter'
    protected_by_mitigating_control = 'protected_by_mitigating_control'


class VulnerabilitySource(BaseModel):
    class Config:
        extra = Extra.allow

    url: Optional[str] = Field(
        None,
        description='The url of the vulnerability documentation as provided by the source.',
        examples=['https://nvd.nist.gov/vuln/detail/CVE-2021-39182'],
        title='URL',
    )
    name: Optional[str] = Field(
        None,
        description='The name of the source.',
        examples=[
            'NVD',
            'National Vulnerability Database',
            'OSS Index',
            'VulnDB',
            'GitHub Advisories',
        ],
        title='Name',
    )


class Reference(BaseModel):
    class Config:
        extra = Extra.allow

    id: str = Field(
        ...,
        description='An identifier that uniquely identifies the vulnerability.',
        examples=[
            'CVE-2021-39182',
            'GHSA-35m5-8cvj-8783',
            'SNYK-PYTHON-ENROCRYPT-1912876',
        ],
        title='ID',
    )
    source: VulnerabilitySource = Field(
        ..., description='The source that published the vulnerability.'
    )


class ResponseEnum(Enum):
    can_not_fix = 'can_not_fix'
    will_not_fix = 'will_not_fix'
    update = 'update'
    rollback = 'rollback'
    workaround_available = 'workaround_available'


class Analysis(BaseModel):
    class Config:
        extra = Extra.allow

    state: Optional[ImpactAnalysisState] = None
    justification: Optional[ImpactAnalysisJustification] = None
    response: Optional[List[ResponseEnum]] = Field(
        None,
        description='A response to the vulnerability by the manufacturer, supplier, or project responsible for the affected component or service. More than one response is allowed. Responses are strongly encouraged for vulnerabilities where the analysis state is exploitable.',
        title='Response',
    )
    detail: Optional[str] = Field(
        None,
        description='Detailed description of the impact including methods used during assessment. If a vulnerability is not exploitable, this field should include specific details on why the component or service is not impacted by this vulnerability.',
        title='Detail',
    )


class Affect(BaseModel):
    class Config:
        extra = Extra.allow

    ref: RefType = Field(
        ...,
        description='References a component or service by the objects bom-ref',
        title='Reference',
    )
    versions: Optional[List[Union[Any, Any]]] = Field(
        None,
        description='Zero or more individual versions or range of versions.',
        title='Versions',
    )


class AffectedStatus(Enum):
    affected = 'affected'
    unaffected = 'unaffected'
    unknown = 'unknown'


class Version(BaseModel):
    __root__: constr(min_length=1, max_length=1024) = Field(
        ..., description='A single version of a component or service.'
    )


class Range(BaseModel):
    __root__: constr(min_length=1, max_length=1024) = Field(
        ...,
        description='A version range specified in Package URL Version Range syntax (vers) which is defined at https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst',
    )


class AlgorithmEnum(Enum):
    RS256 = 'RS256'
    RS384 = 'RS384'
    RS512 = 'RS512'
    PS256 = 'PS256'
    PS384 = 'PS384'
    PS512 = 'PS512'
    ES256 = 'ES256'
    ES384 = 'ES384'
    ES512 = 'ES512'
    Ed25519 = 'Ed25519'
    Ed448 = 'Ed448'
    HS256 = 'HS256'
    HS384 = 'HS384'
    HS512 = 'HS512'


class KeyType(Enum):
    EC = 'EC'
    OKP = 'OKP'
    RSA = 'RSA'


class PublicKey(BaseModel):
    class Config:
        extra = Extra.allow

    kty: KeyType


class OrganizationalEntity(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = Field(
        None,
        description='The name of the organization',
        examples=['Example Inc.'],
        title='Name',
    )
    url: Optional[List[str]] = Field(
        None,
        description='The URL of the organization. Multiple URLs are allowed.',
        examples=['https://example.com'],
        title='URL',
    )
    contact: Optional[List[OrganizationalContact]] = Field(
        None,
        description='A contact at the organization. Multiple contacts are allowed.',
        title='Contact',
    )


class Swid(BaseModel):
    class Config:
        extra = Extra.allow

    tagId: str = Field(
        ..., description='Maps to the tagId of a SoftwareIdentity.', title='Tag ID'
    )
    name: str = Field(
        ..., description='Maps to the name of a SoftwareIdentity.', title='Name'
    )
    version: Optional[str] = Field(
        '0.0', description='Maps to the version of a SoftwareIdentity.', title='Version'
    )
    tagVersion: Optional[int] = Field(
        0,
        description='Maps to the tagVersion of a SoftwareIdentity.',
        title='Tag Version',
    )
    patch: Optional[bool] = Field(
        False, description='Maps to the patch of a SoftwareIdentity.', title='Patch'
    )
    text: Optional[Attachment] = Field(
        None,
        description='Specifies the metadata and content of the SWID tag.',
        title='Attachment text',
    )
    url: Optional[str] = Field(
        None, description='The URL to the SWID file.', title='URL'
    )


class Hash(BaseModel):
    class Config:
        extra = Extra.allow

    alg: HashAlg
    content: HashContent


class License(BaseModel):
    class Config:
        extra = Extra.allow

    id: Optional[spdx.Schema] = Field(
        None,
        description='A valid SPDX license ID',
        examples=['Apache-2.0'],
        title='License ID (SPDX)',
    )
    name: Optional[str] = Field(
        None,
        description='If SPDX does not define the license used, this field may be used to provide the license name',
        examples=['Acme Software License'],
        title='License Name',
    )
    text: Optional[Attachment] = Field(
        None,
        description='An optional way to include the textual content of a license.',
        title='License text',
    )
    url: Optional[str] = Field(
        None,
        description="The URL to the license file. If specified, a 'license' externalReference should also be specified for completeness",
        examples=['https://www.apache.org/licenses/LICENSE-2.0.txt'],
        title='License URL',
    )


class License1(BaseModel):
    __root__: Union[License, Any, Any] = Field(..., title='License Object')


class LicenseChoice1(BaseModel):
    class Config:
        extra = Extra.allow

    license: Optional[License1] = None
    expression: Optional[str] = Field(
        None,
        examples=[
            'Apache-2.0 AND (MIT OR GPL-2.0-only)',
            'GPL-3.0-only WITH Classpath-exception-2.0',
        ],
        title='SPDX License Expression',
    )


class LicenseChoice(BaseModel):
    __root__: Union[LicenseChoice1, Any, Any] = Field(..., title='License(s)')


class Commit(BaseModel):
    class Config:
        extra = Extra.allow

    uid: Optional[str] = Field(
        None,
        description='A unique identifier of the commit. This may be version control specific. For example, Subversion uses revision numbers whereas git uses commit hashes.',
        title='UID',
    )
    url: Optional[str] = Field(
        None,
        description='The URL to the commit. This URL will typically point to a commit in a version control system.',
        title='URL',
    )
    author: Optional[IdentifiableAction] = Field(
        None,
        description='The author who created the changes in the commit',
        title='Author',
    )
    committer: Optional[IdentifiableAction] = Field(
        None,
        description='The person who committed or pushed the commit',
        title='Committer',
    )
    message: Optional[str] = Field(
        None,
        description='The text description of the contents of the commit',
        title='Message',
    )


class Patch(BaseModel):
    class Config:
        extra = Extra.allow

    type: Type1 = Field(
        ...,
        description='Specifies the purpose for the patch including the resolution of defects, security issues, or new behavior or functionality.\n\n* __unofficial__ = A patch which is not developed by the creators or maintainers of the software being patched. Refer to [https://en.wikipedia.org/wiki/Unofficial_patch](https://en.wikipedia.org/wiki/Unofficial_patch)\n* __monkey__ = A patch which dynamically modifies runtime behavior. Refer to [https://en.wikipedia.org/wiki/Monkey_patch](https://en.wikipedia.org/wiki/Monkey_patch)\n* __backport__ = A patch which takes code from a newer version of software and applies it to older versions of the same software. Refer to [https://en.wikipedia.org/wiki/Backporting](https://en.wikipedia.org/wiki/Backporting)\n* __cherry-pick__ = A patch created by selectively applying commits from other versions or branches of the same software.',
        title='Type',
    )
    diff: Optional[Diff] = Field(
        None,
        description='The patch file (or diff) that show changes. Refer to [https://en.wikipedia.org/wiki/Diff](https://en.wikipedia.org/wiki/Diff)',
        title='Diff',
    )
    resolves: Optional[List[Issue]] = Field(
        None, description='A collection of issues the patch resolves', title='Resolves'
    )


class ExternalReference(BaseModel):
    class Config:
        extra = Extra.allow

    url: str = Field(..., description='The URL to the external reference', title='URL')
    comment: Optional[str] = Field(
        None,
        description='An optional comment describing the external reference',
        title='Comment',
    )
    type: Type3 = Field(
        ...,
        description='Specifies the type of external reference. There are built-in types to describe common references. If a type does not exist for the reference being referred to, use the "other" type.',
        title='Type',
    )
    hashes: Optional[List[Hash]] = Field(
        None,
        description='The hashes of the external reference (if applicable).',
        title='Hashes',
    )


class DataClassification(BaseModel):
    class Config:
        extra = Extra.allow

    flow: DataFlow = Field(
        ...,
        description='Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states that data enters the service. Outbound flow states that data leaves the service. Bi-directional states that data flows both ways, and unknown states that the direction is not known.',
        title='Directional Flow',
    )
    classification: str = Field(
        ...,
        description='Data classification tags data according to its type, sensitivity, and value if altered, stolen, or destroyed.',
        title='Classification',
    )


class ComponentEvidence(BaseModel):
    class Config:
        extra = Extra.allow

    licenses: Optional[List[LicenseChoice]] = Field(None, title='Component License(s)')
    copyright: Optional[List[Copyright]] = Field(None, title='Copyright')


class Rating(BaseModel):
    class Config:
        extra = Extra.allow

    source: Optional[VulnerabilitySource] = Field(
        None,
        description='The source that calculated the severity or risk rating of the vulnerability.',
    )
    score: Optional[float] = Field(
        None, description='The numerical score of the rating.', title='Score'
    )
    severity: Optional[Severity] = Field(
        None,
        description='Textual representation of the severity that corresponds to the numerical score of the rating.',
    )
    method: Optional[ScoreMethod] = None
    vector: Optional[str] = Field(
        None,
        description='Textual representation of the metric values used to score the vulnerability',
        title='Vector',
    )
    justification: Optional[str] = Field(
        None,
        description='An optional reason for rating the vulnerability as it was',
        title='Justification',
    )


class Credits(BaseModel):
    class Config:
        extra = Extra.allow

    organizations: Optional[List[OrganizationalEntity]] = Field(
        None,
        description='The organizations credited with vulnerability discovery.',
        title='Organizations',
    )
    individuals: Optional[List[OrganizationalContact]] = Field(
        None,
        description='The individuals, not associated with organizations, that are credited with vulnerability discovery.',
        title='Individuals',
    )


class Signer(BaseModel):
    class Config:
        extra = Extra.allow

    algorithm: Union[AlgorithmEnum, AnyUrl]
    keyId: Optional[str] = Field(
        None,
        description='Optional. Application specific string identifying the signature key.',
        title='Key ID',
    )
    publicKey: Optional[PublicKey] = Field(
        None, description='Optional. Public key object.', title='Public key'
    )
    certificatePath: Optional[List[str]] = Field(
        None,
        description='Optional. Sorted array of X.509 [RFC5280] certificates, where the first element must contain the signature certificate. The certificate path must be contiguous but is not required to be complete.',
        title='Certificate path',
    )
    excludes: Optional[List[str]] = Field(
        None,
        description='Optional. Array holding the names of one or more application level properties that must be excluded from the signature process. Note that the "excludes" property itself, must also be excluded from the signature process. Since both the "excludes" property and the associated data it points to are unsigned, a conforming JSF implementation must provide options for specifying which properties to accept.',
        title='Excludes',
    )
    value: str = Field(
        ...,
        description='The signature data. Note that the binary representation must follow the JWA [RFC7518] specifications.',
        title='Signature',
    )


class Tool(BaseModel):
    class Config:
        extra = Extra.allow

    vendor: Optional[str] = Field(
        None,
        description='The name of the vendor who created the tool',
        title='Tool Vendor',
    )
    name: Optional[str] = Field(
        None, description='The name of the tool', title='Tool Name'
    )
    version: Optional[str] = Field(
        None, description='The version of the tool', title='Tool Version'
    )
    hashes: Optional[List[Hash]] = Field(
        None, description='The hashes of the tool (if applicable).', title='Hashes'
    )
    externalReferences: Optional[List[ExternalReference]] = Field(
        None,
        description='External references provide a way to document systems, sites, and information that may be relevant but which are not included with the BOM.',
        title='External References',
    )


class Vulnerability(BaseModel):
    class Config:
        extra = Extra.allow

    bom_ref: Optional[RefType] = Field(
        None,
        alias='bom-ref',
        description='An optional identifier which can be used to reference the vulnerability elsewhere in the BOM. Every bom-ref MUST be unique within the BOM.',
        title='BOM Reference',
    )
    id: Optional[str] = Field(
        None,
        description='The identifier that uniquely identifies the vulnerability.',
        examples=[
            'CVE-2021-39182',
            'GHSA-35m5-8cvj-8783',
            'SNYK-PYTHON-ENROCRYPT-1912876',
        ],
        title='ID',
    )
    source: Optional[VulnerabilitySource] = Field(
        None, description='The source that published the vulnerability.'
    )
    references: Optional[List[Reference]] = Field(
        None,
        description='Zero or more pointers to vulnerabilities that are the equivalent of the vulnerability specified. Often times, the same vulnerability may exist in multiple sources of vulnerability intelligence, but have different identifiers. References provide a way to correlate vulnerabilities across multiple sources of vulnerability intelligence.',
        title='References',
    )
    ratings: Optional[List[Rating]] = Field(
        None, description='List of vulnerability ratings', title='Ratings'
    )
    cwes: Optional[List[Cwe]] = Field(
        None,
        description='List of Common Weaknesses Enumerations (CWEs) codes that describes this vulnerability. For example 399 (of https://cwe.mitre.org/data/definitions/399.html)',
        examples=['399'],
        title='CWEs',
    )
    description: Optional[str] = Field(
        None,
        description='A description of the vulnerability as provided by the source.',
        title='Description',
    )
    detail: Optional[str] = Field(
        None,
        description='If available, an in-depth description of the vulnerability as provided by the source organization. Details often include examples, proof-of-concepts, and other information useful in understanding root cause.',
        title='Details',
    )
    recommendation: Optional[str] = Field(
        None,
        description='Recommendations of how the vulnerability can be remediated or mitigated.',
        title='Details',
    )
    advisories: Optional[List[Advisory]] = Field(
        None,
        description='Published advisories of the vulnerability if provided.',
        title='Advisories',
    )
    created: Optional[datetime] = Field(
        None,
        description='The date and time (timestamp) when the vulnerability record was created in the vulnerability database.',
        title='Created',
    )
    published: Optional[datetime] = Field(
        None,
        description='The date and time (timestamp) when the vulnerability record was first published.',
        title='Published',
    )
    updated: Optional[datetime] = Field(
        None,
        description='The date and time (timestamp) when the vulnerability record was last updated.',
        title='Updated',
    )
    credits: Optional[Credits] = Field(
        None,
        description='Individuals or organizations credited with the discovery of the vulnerability.',
        title='Credits',
    )
    tools: Optional[List[Tool]] = Field(
        None,
        description='The tool(s) used to identify, confirm, or score the vulnerability.',
        title='Creation Tools',
    )
    analysis: Optional[Analysis] = Field(
        None,
        description='An assessment of the impact and exploitability of the vulnerability.',
        title='Impact Analysis',
    )
    affects: Optional[List[Affect]] = Field(
        None,
        description='The components or services that are affected by the vulnerability.',
        title='Affects',
        
    )
    properties: Optional[List[Property]] = Field(
        None,
        description='Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.',
        title='Properties',
    )


class SignatureItem(BaseModel):
    class Config:
        extra = Extra.allow

    signers: Optional[List[Signer]] = Field(
        None,
        description='Unique top level property for Multiple Signatures. (multisignature)',
        title='Signature',
    )


class SignatureItem1(BaseModel):
    class Config:
        extra = Extra.allow

    chain: Optional[List[Signer]] = Field(
        None,
        description='Unique top level property for Signature Chains. (signaturechain)',
        title='Signature',
    )


class Signature(BaseModel):
    __root__: Union[SignatureItem, SignatureItem1, Signer] = Field(
        ..., title='Signature'
    )


class Service(BaseModel):
    class Config:
        extra = Extra.allow

    bom_ref: Optional[RefType] = Field(
        None,
        alias='bom-ref',
        description='An optional identifier which can be used to reference the service elsewhere in the BOM. Every bom-ref MUST be unique within the BOM.',
        title='BOM Reference',
    )
    provider: Optional[OrganizationalEntity] = Field(
        None,
        description='The organization that provides the service.',
        title='Provider',
    )
    group: Optional[str] = Field(
        None,
        description='The grouping name, namespace, or identifier. This will often be a shortened, single name of the company or project that produced the service or domain name. Whitespace and special characters should be avoided.',
        examples=['com.acme'],
        title='Service Group',
    )
    name: str = Field(
        ...,
        description='The name of the service. This will often be a shortened, single name of the service.',
        examples=['ticker-service'],
        title='Service Name',
    )
    version: Optional[str] = Field(
        None,
        description='The service version.',
        examples=['1.0.0'],
        title='Service Version',
    )
    description: Optional[str] = Field(
        None,
        description='Specifies a description for the service',
        title='Service Description',
    )
    endpoints: Optional[List[str]] = Field(
        None,
        description='The endpoint URIs of the service. Multiple endpoints are allowed.',
        examples=['https://example.com/api/v1/ticker'],
        title='Endpoints',
    )
    authenticated: Optional[bool] = Field(
        None,
        description='A boolean value indicating if the service requires authentication. A value of true indicates the service requires authentication prior to use. A value of false indicates the service does not require authentication.',
        title='Authentication Required',
    )
    x_trust_boundary: Optional[bool] = Field(
        None,
        alias='x-trust-boundary',
        description='A boolean value indicating if use of the service crosses a trust zone or boundary. A value of true indicates that by using the service, a trust boundary is crossed. A value of false indicates that by using the service, a trust boundary is not crossed.',
        title='Crosses Trust Boundary',
    )
    data: Optional[List[DataClassification]] = Field(
        None,
        description='Specifies the data classification.',
        title='Data Classification',
    )
    licenses: Optional[List[LicenseChoice]] = Field(None, title='Component License(s)')
    externalReferences: Optional[List[ExternalReference]] = Field(
        None,
        description='External references provide a way to document systems, sites, and information that may be relevant but which are not included with the BOM.',
        title='External References',
    )
    services: Optional[List[Service]] = Field(
        None,
        description='A list of services included or deployed behind the parent service. This is not a dependency tree. It provides a way to specify a hierarchical representation of service assemblies.',
        title='Services',
    )
    releaseNotes: Optional[ReleaseNotes] = Field(
        None, description='Specifies optional release notes.', title='Release notes'
    )
    properties: Optional[List[Property]] = Field(
        None,
        description='Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.',
        title='Properties',
    )
    signature: Optional[Signature] = Field(
        None,
        description='Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).',
        title='Signature',
    )


class Compositions(BaseModel):
    class Config:
        extra = Extra.allow

    aggregate: AggregateType = Field(
        ...,
        description='Specifies an aggregate type that describe how complete a relationship is.',
        title='Aggregate',
    )
    assemblies: Optional[List[str]] = Field(
        None,
        description='The bom-ref identifiers of the components or services being described. Assemblies refer to nested relationships whereby a constituent part may include other constituent parts. References do not cascade to child parts. References are explicit for the specified constituent part only.',
        title='BOM references',
        
    )
    dependencies: Optional[List[str]] = Field(
        None,
        description='The bom-ref identifiers of the components or services being described. Dependencies refer to a relationship whereby an independent constituent part requires another independent constituent part. References do not cascade to transitive dependencies. References are explicit for the specified dependency only.',
        title='BOM references',
        
    )
    signature: Optional[Signature] = Field(
        None,
        description='Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).',
        title='Signature',
    )


class CyclonedxSoftwareBillOfMaterialsStandard(BaseModel):
    class Config:
        extra = Extra.allow

    _schema: Optional[_Schema] = Field(None, alias='$schema')
    bomFormat: BomFormat = Field(
        ...,
        description='Specifies the format of the BOM. This helps to identify the file as CycloneDX since BOMs do not have a filename convention nor does JSON schema support namespaces. This value MUST be "CycloneDX".',
        title='BOM Format',
    )
    specVersion: str = Field(
        ...,
        description='The version of the CycloneDX specification a BOM conforms to (starting at version 1.2).',
        examples=['1.4'],
        title='CycloneDX Specification Version',
    )
    serialNumber: Optional[
        constr(
            regex=r'^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$'
        )
    ] = Field(
        None,
        description='Every BOM generated SHOULD have a unique serial number, even if the contents of the BOM have not changed over time. If specified, the serial number MUST conform to RFC-4122. Use of serial numbers are RECOMMENDED.',
        examples=['urn:uuid:3e671687-395b-41f5-a30f-a58921a69b79'],
        title='BOM Serial Number',
    )
    version: int = Field(
        ...,
        description="Whenever an existing BOM is modified, either manually or through automated processes, the version of the BOM SHOULD be incremented by 1. When a system is presented with multiple BOMs with identical serial numbers, the system SHOULD use the most recent version of the BOM. The default version is '1'.",
        examples=[1],
        title='BOM Version',
    )
    metadata: Optional[Metadata] = Field(
        None,
        description='Provides additional information about a BOM.',
        title='BOM Metadata',
    )
    components: Optional[List[Component]] = Field(
        None,
        description='A list of software and hardware components.',
        title='Components',
        
    )
    services: Optional[List[Service]] = Field(
        None,
        description='A list of services. This may include microservices, function-as-a-service, and other types of network or intra-process services.',
        title='Services',
        
    )
    externalReferences: Optional[List[ExternalReference]] = Field(
        None,
        description='External references provide a way to document systems, sites, and information that may be relevant but which are not included with the BOM.',
        title='External References',
    )
    dependencies: Optional[List[Dependency]] = Field(
        None,
        description='Provides the ability to document dependency relationships.',
        title='Dependencies',
        
    )
    compositions: Optional[List[Compositions]] = Field(
        None,
        description='Compositions describe constituent parts (including components, services, and dependency relationships) and their completeness.',
        title='Compositions',
        
    )
    vulnerabilities: Optional[List[Vulnerability]] = Field(
        None,
        description='Vulnerabilities identified in components or services.',
        title='Vulnerabilities',
        
    )
    signature: Optional[Signature] = Field(
        None,
        description='Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).',
        title='Signature',
    )


class Metadata(BaseModel):
    class Config:
        extra = Extra.allow

    timestamp: Optional[datetime] = Field(
        None,
        description='The date and time (timestamp) when the BOM was created.',
        title='Timestamp',
    )
    tools: Optional[List[Tool]] = Field(
        None,
        description='The tool(s) used in the creation of the BOM.',
        title='Creation Tools',
    )
    authors: Optional[List[OrganizationalContact]] = Field(
        None,
        description='The person(s) who created the BOM. Authors are common in BOMs created through manual processes. BOMs created through automated means may not have authors.',
        title='Authors',
    )
    component: Optional[Component] = Field(
        None, description='The component that the BOM describes.', title='Component'
    )
    manufacture: Optional[OrganizationalEntity] = Field(
        None,
        description='The organization that manufactured the component that the BOM describes.',
        title='Manufacture',
    )
    supplier: Optional[OrganizationalEntity] = Field(
        None,
        description=' The organization that supplied the component that the BOM describes. The supplier may often be the manufacturer, but may also be a distributor or repackager.',
        title='Supplier',
    )
    licenses: Optional[List[LicenseChoice]] = Field(None, title='BOM License(s)')
    properties: Optional[List[Property]] = Field(
        None,
        description='Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.',
        title='Properties',
    )


class Pedigree(BaseModel):
    class Config:
        extra = Extra.allow

    ancestors: Optional[List[Component]] = Field(
        None,
        description='Describes zero or more components in which a component is derived from. This is commonly used to describe forks from existing projects where the forked version contains a ancestor node containing the original component it was forked from. For example, Component A is the original component. Component B is the component being used and documented in the BOM. However, Component B contains a pedigree node with a single ancestor documenting Component A - the original component from which Component B is derived from.',
        title='Ancestors',
    )
    descendants: Optional[List[Component]] = Field(
        None,
        description='Descendants are the exact opposite of ancestors. This provides a way to document all forks (and their forks) of an original or root component.',
        title='Descendants',
    )
    variants: Optional[List[Component]] = Field(
        None,
        description='Variants describe relations where the relationship between the components are not known. For example, if Component A contains nearly identical code to Component B. They are both related, but it is unclear if one is derived from the other, or if they share a common ancestor.',
        title='Variants',
    )
    commits: Optional[List[Commit]] = Field(
        None,
        description='A list of zero or more commits which provide a trail describing how the component deviates from an ancestor, descendant, or variant.',
        title='Commits',
    )
    patches: Optional[List[Patch]] = Field(
        None,
        description='>A list of zero or more patches describing how the component deviates from an ancestor, descendant, or variant. Patches may be complimentary to commits or may be used in place of commits.',
        title='Patches',
    )
    notes: Optional[str] = Field(
        None,
        description='Notes, observations, and other non-structured commentary describing the components pedigree.',
        title='Notes',
    )


class Component(BaseModel):
    class Config:
        extra = Extra.allow

    type: Type = Field(
        ...,
        description="Specifies the type of component. For software components, classify as application if no more specific appropriate classification is available or cannot be determined for the component. Types include:\n\n* __application__ = A software application. Refer to [https://en.wikipedia.org/wiki/Application_software](https://en.wikipedia.org/wiki/Application_software) for information about applications.\n* __framework__ = A software framework. Refer to [https://en.wikipedia.org/wiki/Software_framework](https://en.wikipedia.org/wiki/Software_framework) for information on how frameworks vary slightly from libraries.\n* __library__ = A software library. Refer to [https://en.wikipedia.org/wiki/Library_(computing)](https://en.wikipedia.org/wiki/Library_(computing))\n for information about libraries. All third-party and open source reusable components will likely be a library. If the library also has key features of a framework, then it should be classified as a framework. If not, or is unknown, then specifying library is RECOMMENDED.\n* __container__ = A packaging and/or runtime format, not specific to any particular technology, which isolates software inside the container from software outside of a container through virtualization technology. Refer to [https://en.wikipedia.org/wiki/OS-level_virtualization](https://en.wikipedia.org/wiki/OS-level_virtualization)\n* __operating-system__ = A software operating system without regard to deployment model (i.e. installed on physical hardware, virtual machine, image, etc) Refer to [https://en.wikipedia.org/wiki/Operating_system](https://en.wikipedia.org/wiki/Operating_system)\n* __device__ = A hardware device such as a processor, or chip-set. A hardware device containing firmware SHOULD include a component for the physical hardware itself, and another component of type 'firmware' or 'operating-system' (whichever is relevant), describing information about the software running on the device.\n* __firmware__ = A special type of software that provides low-level control over a devices hardware. Refer to [https://en.wikipedia.org/wiki/Firmware](https://en.wikipedia.org/wiki/Firmware)\n* __file__ = A computer file. Refer to [https://en.wikipedia.org/wiki/Computer_file](https://en.wikipedia.org/wiki/Computer_file) for information about files.",
        examples=['library'],
        title='Component Type',
    )
    mime_type: Optional[constr(regex=r'^[-+a-z0-9.]+/[-+a-z0-9.]+$')] = Field(
        None,
        alias='mime-type',
        description='The optional mime-type of the component. When used on file components, the mime-type can provide additional context about the kind of file being represented such as an image, font, or executable. Some library or framework components may also have an associated mime-type.',
        examples=['image/jpeg'],
        title='Mime-Type',
    )
    bom_ref: Optional[RefType] = Field(
        None,
        alias='bom-ref',
        description='An optional identifier which can be used to reference the component elsewhere in the BOM. Every bom-ref MUST be unique within the BOM.',
        title='BOM Reference',
    )
    supplier: Optional[OrganizationalEntity] = Field(
        None,
        description=' The organization that supplied the component. The supplier may often be the manufacturer, but may also be a distributor or repackager.',
        title='Component Supplier',
    )
    author: Optional[str] = Field(
        None,
        description='The person(s) or organization(s) that authored the component',
        examples=['Acme Inc'],
        title='Component Author',
    )
    publisher: Optional[str] = Field(
        None,
        description='The person(s) or organization(s) that published the component',
        examples=['Acme Inc'],
        title='Component Publisher',
    )
    group: Optional[str] = Field(
        None,
        description='The grouping name or identifier. This will often be a shortened, single name of the company or project that produced the component, or the source package or domain name. Whitespace and special characters should be avoided. Examples include: apache, org.apache.commons, and apache.org.',
        examples=['com.acme'],
        title='Component Group',
    )
    name: str = Field(
        ...,
        description='The name of the component. This will often be a shortened, single name of the component. Examples: commons-lang3 and jquery',
        examples=['tomcat-catalina'],
        title='Component Name',
    )
    version: Optional[str] = Field(
        None,
        description='The component version. The version should ideally comply with semantic versioning but is not enforced.',
        examples=['9.0.14'],
        title='Component Version',
    )
    description: Optional[str] = Field(
        None,
        description='Specifies a description for the component',
        title='Component Description',
    )
    scope: Optional[Scope] = Field(
        'required',
        description="Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by the consumer of the BOM.",
        title='Component Scope',
    )
    hashes: Optional[List[Hash]] = Field(None, title='Component Hashes')
    licenses: Optional[List[LicenseChoice]] = Field(None, title='Component License(s)')
    copyright: Optional[str] = Field(
        None,
        description='A copyright notice informing users of the underlying claims to copyright ownership in a published work.',
        examples=['Acme Inc'],
        title='Component Copyright',
    )
    cpe: Optional[str] = Field(
        None,
        description='Specifies a well-formed CPE name that conforms to the CPE 2.2 or 2.3 specification. See [https://nvd.nist.gov/products/cpe](https://nvd.nist.gov/products/cpe)',
        examples=['cpe:2.3:a:acme:component_framework:-:*:*:*:*:*:*:*'],
        title='Component Common Platform Enumeration (CPE)',
    )
    purl: Optional[str] = Field(
        None,
        description='Specifies the package-url (purl). The purl, if specified, MUST be valid and conform to the specification defined at: [https://github.com/package-url/purl-spec](https://github.com/package-url/purl-spec)',
        examples=['pkg:maven/com.acme/tomcat-catalina@9.0.14?packaging=jar'],
        title='Component Package URL (purl)',
    )
    swid: Optional[Swid] = Field(
        None,
        description='Specifies metadata and content for [ISO-IEC 19770-2 Software Identification (SWID) Tags](https://www.iso.org/standard/65666.html).',
        title='SWID Tag',
    )
    modified: Optional[bool] = Field(
        None,
        description='[Deprecated] - DO NOT USE. This will be removed in a future version. Use the pedigree element instead to supply information on exactly how the component was modified. A boolean value indicating if the component has been modified from the original. A value of true indicates the component is a derivative of the original. A value of false indicates the component has not been modified from the original.',
        title='Component Modified From Original',
    )
    pedigree: Optional[Pedigree] = Field(
        None,
        description='Component pedigree is a way to document complex supply chain scenarios where components are created, distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to document variants where the exact relation may not be known.',
        title='Component Pedigree',
    )
    externalReferences: Optional[List[ExternalReference]] = Field(
        None,
        description='External references provide a way to document systems, sites, and information that may be relevant but which are not included with the BOM.',
        title='External References',
    )
    components: Optional[List[Component]] = Field(
        None,
        description='A list of software and hardware components included in the parent component. This is not a dependency tree. It provides a way to specify a hierarchical representation of component assemblies, similar to system &#8594; subsystem &#8594; parts assembly in physical supply chains.',
        title='Components',
    )
    evidence: Optional[ComponentEvidence] = Field(
        None,
        description='Provides the ability to document evidence collected through various forms of extraction or analysis.',
        title='Evidence',
    )
    releaseNotes: Optional[ReleaseNotes] = Field(
        None, description='Specifies optional release notes.', title='Release notes'
    )
    properties: Optional[List[Property]] = Field(
        None,
        description='Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is OPTIONAL.',
        title='Properties',
    )
    signature: Optional[Signature] = Field(
        None,
        description='Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).',
        title='Signature',
    )


Service.update_forward_refs()
CyclonedxSoftwareBillOfMaterialsStandard.update_forward_refs()
Metadata.update_forward_refs()
Pedigree.update_forward_refs()
