from enum import Enum


class GENERAL_MESSAGE(Enum):  # Used only Client and Server
    SHUTDOWN = -1
    OK = 0
    FILE_TRANSFER_START = 1
    FILE_TRANSFER_END = 2
    CLIENT_REGISTER = 3


class MANAGER_MESSAGE(Enum):
    CREATE_NODE = 4
    REQUEST_NODE_SERVER_DATA = 5
    BROADCAST_NODE_SERVER_DATA = 6
    REPORT_STATUS = 7
    REQUEST_STEP = 8
    START_NODES = 9
    STOP_NODES = 10
    REQUEST_GATHER = 11
    REQUEST_COLLECT = 12
    REQUEST_CODE_LOAD = 13
    CLUSTER_SHUTDOWN = 14


class WORKER_MESSAGE(Enum):
    PACKAGE_LOADED = 15
    REGISTER = 16
    DEREGISTER = 17
    REPORT_NODE_SERVER_DATA = 18
    BROADCAST_NODE_SERVER_DATA = 19
    REPORT_NODES_STATUS = 20
    COMPLETE_BROADCAST = 21
    REQUEST_STEP = 22
    REQUEST_GATHER = 23
    REPORT_GATHER = 24
    START_NODES = 25
    STOP_NODES = 26
    TRANSFER_COMPLETE = 27


class NODE_MESSAGE(Enum):
    STATUS = 28
    REPORT_GATHER = 29
