# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fs2es_indexer']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>5.0', 'elasticsearch>=8.0,<9.0']

entry_points = \
{'console_scripts': ['fs2es-indexer = fs2es_indexer.fs2es_indexer:main']}

setup_kwargs = {
    'name': 'fs2es-indexer',
    'version': '0.5.0a3',
    'description': 'Index files and directories into elastic search',
    'long_description': '# FileSystem To ElasticSearch Indexer\n\nThis tool indexes your files and directories into an elastic search index and prepares them for searching \nvia macOS Spotlight search in a samba file server.\n\n## Dependencies:\n- Python3 (Debian package: `python3`)\n- Poetry (see [Poetry Installation](https://python-poetry.org/docs/#installation))\n- a running ElasticSearch instance v8 or higher (see [ElasticSearch installation](https://www.elastic.co/guide/en/elasticsearch/reference/current/install-elasticsearch.html#install-elasticsearch))\n\n## Installation\n\nGrab the source code and call `poetry install`.\n\n### Configuration\n\nCopy the `config.dist.yml` to `/etc/fs2es-indexer/config.yml` and tweak it to your hearts content!\n\nYou have to configure which directories should be indexed and the URL & credentials for your ElasticSearch instance.\n\n### Running it\n\n```bash\n# When using a virtualenv created by Poetry:\npoetry run fs2es-indexer\n\n# Index the configured directories once\nfs2es-indexer index\n\n# Index the configured directories, wait for the specified amount of time and index again\n# Continously!\nfs2es-indexer daemon\n\n# Deletes all documents in the elasticsearch index\nfs2es-indexer clear\n\n# You can test the Spotlight search with this indexer!\n\n# Shows the first 100 elasticsearch documents\nfs2es-indexer search --search-path /srv/samba\n\n# Searches elasticsearch documents with a match on all attributes:\nfs2es-indexer search --search-path /srv/samba --search-term "my-doc.pdf"\n\n# Searches elasticsearch documents with a match on the filename:\nfs2es-indexer search --search-path /srv/samba --search-filename "my-doc.pdf"\n\n# Displays some help texts\nfs2es-indexer --help\n```\n\nYou can use the `fs2es-indexer.service` in order to register the daemon-mode as a SystemD service. \n\n## Configuration of Samba\nAdd this to your `[global]` section in your `smb.conf`:\n```ini\nspotlight backend = elasticsearch\nelasticsearch:address = 127.0.0.1\nelasticsearch:port = 9200\n```\n\nIf your elasticsearch instance is not on the local machine, use the correct IP address above.\n\n## User authentication\n\nIn elasticsearch v8 the user authentication was made mandatory for elasticsearch.\n\n### 1. Add the roles\n\nAdd the content of `role.yml` to the `roles.yml` of your elasticsearch (e. g. in Debian: `/etc/elasticsearch/roles.yml`).\n\nUnknown if needed: restart your elasticsearch (e. g. in Debian: `systemctl restart elasticsearch`).\n\n### 2. Add the user\n\nNavigate to the installation directory of elasticsearch (e. g. in Debian: `/usr/share/elasticsearch`).\n\n```bash\n# Create a new user\nbin/elasticsearch-users useradd fs2es-indexer\n# Use a good password!\n\n# Add the new role to it\nbin/elasticsearch-users roles -a fs2es-indexer fs2es-indexer\n```\n\n### 3. Configure fs2es-indexer\n\nEdit your `/etc/fs2es-indexer/config.yml` and insert your values for `user` and `password` in `elasticsearch`. \nSee the template `config.dist.yml` for an example.\n\n### 4. Configure ElasticSearch\n\nSamba as of 4.15.6 can\'t use user authentication yet. \nThere is a [pull request](https://gitlab.com/samba-team/samba/-/merge_requests/1847) to add this feature, but it\'s not merged (yet).\n\nThat\'s why we have to enable the anonymous access to ES with a role that can read all indexed files.\n\nAdd this to your `/etc/elasticsearch/elasticsearch.yml`:\n```yaml\n# Allow access without user credentials for Samba 4.15\n# See https://www.elastic.co/guide/en/elasticsearch/reference/current/anonymous-access.html\nxpack.security.authc:\n  anonymous:\n    username:        anonymous_user\n    roles:           fs2es-indexer-ro\n    authz_exception: true\n```\n\n## Debugging the search\n\nThe whole macOS finder -> Spotlight -> Samba -> ES system is complex and a number of things can go wrong.\n\nUse this guideline to determine where the problem might be.\n\n### 1. Is Elasticsearch running correctly?\n\nIs elasticsearch running / accepting any connections? In debian run `systemctl status elasticsearch`.\nAdditionally, look through the logs found in `/var/log/elasticsearch`.\n\n### 2. Is fs2es-indexer running correctly?\n\nDid the tool correctly index your directories? Look through the output of `fs2es-indexer index` or `daemon`. \n\nCheck your configuration in `/etc/fs2es-indexer/config.yml`, use the `config.dist.yml` as base.\n\n### 3. Does the indexer find the files you\'re looking for?\n\nTry to find some files with `fs2es-indexer search --search-path <Local Path> --search-term <Term>`.\n\nIf nothing is found: Did the indexer run correctly? Are there any auth or connection problem? \nCheck your ES and indexer logs!\n\nMake sure your search term is the start of a word in the file name. E.g. searching for "Test" could find files\nnamed "Test123.pdf", "Testing-yesterday.doc" and "This_Is_My_Test.xml" but *not* the file named "notestingdone.pdf".\n\nThis constraint comes from the way samba (4.15) creates the ES query and fs2es-indexer mimicks this behavior as close \nas possible. There is currently no way to change this in samba (and therefor impossible in fs2es-indexer too).\n\n### 4. Does your Mac uses the correct search index?\n\nGo on your macOS client and connect to the samba share ( = mounting the share in /Volumes/my-share).\n\nStart a terminal and execute\n\n```bash\nmdutil -s /Volumes/my-share\n```\n\nDoes it say "Server search enabled"? \n\nIf not: \n- is elasticsearch enabled in your smb.conf (on the server)? \n- Was Samba compiled with spotlight support? \n- Are you using Samba 4.12.0 or later?\n\n### 5. Does your Mac\'s mdfind finds anything?\n\nStart a terminal on your Mac-Client and execute\n```bash\nmdfind -onlyin /Volumes/my-share <search-term>\n```\n\nUse the same search-term as in step 3!\n\nIf no output is produced: wait 5 seconds and try again.\n\nIf this fails: check your samba-logs on the server. Any entries with "rpc_server", "mds" or "mdssvc" in it?\n\n### 6. Does your Mac\'s Finder find anything?\n\nStart the Finder on your Mac and navigate to the samba share. Use the search field at the top right and type in your \nsearch term.\n\nWait for the spinner to finish. If no files are returned and Step 5 succeeded: IDK (srsly).\n\nIf your finder hangs then you have a problem with the `.DS_Store` and `DOSATTRIBS` on your server. This can happen \nif you rsync files from an old macOS server to the new linux samba server.\n\nIn order to fix this you have to execute these on the samba server:\n```bash\nfind /my-storage-path -type f -name ".DS_Store" -delete\nfind /my-storage-path -exec setfattr -x user.DOSATTRIB {} \\;\n```\n\nAnd add these lines to your [global] section in the smb.conf on the samba server:\n```bash\n    veto files = /.DS_Store/\n    delete veto files = yes\n```\n\nYou have to restart your Mac-OS client btw, because it crashed and won\'t be usable otherwise.\n\n## Advanced: Switch to elasticsearch v7\n\nYou have to install the elasticsearch-python library in version 7, e.g. via the setup.py\n```python\ninstall_requires=[\n  \'PyYaml\',\n  \'elasticsearch>=7,<8\'\n]\n```\n\nAnd configure this in your `config.yml`:\n```yaml\nelasticsearch:\n  library_version: 7\n```\n\nThis **should** work!\n\n## Advanced: How does it work?\n\nFirst the current timestamp is saved as a marker to flag new and updated documents as uptodate.\n\nIt goes through all of your directories and indexes them into elastic search documents, these documents get a "time" \nattribute that has the value of the saved marker.\n\nAfter that, all documents with a "time" value of less than the saved marker will be deleted. \nThis ensures that documents of old files in the filesystem will be deleted from the elasticsearch index.\n',
    'author': 'Matthias Kühne',
    'author_email': 'matthias.kuehne@ellerhold.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Ellerhold/fs2es-indexer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
