# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from typing import MutableMapping, MutableSequence

import proto  # type: ignore

from google.cloud.websecurityscanner_v1alpha.types import finding_addon

__protobuf__ = proto.module(
    package="google.cloud.websecurityscanner.v1alpha",
    manifest={
        "Finding",
    },
)


class Finding(proto.Message):
    r"""A Finding resource represents a vulnerability instance
    identified during a ScanRun.

    Attributes:
        name (str):
            The resource name of the Finding. The name
            follows the format of
            'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
            The finding IDs are generated by the system.
        finding_type (google.cloud.websecurityscanner_v1alpha.types.Finding.FindingType):
            The type of the Finding.
        http_method (str):
            The http method of the request that triggered
            the vulnerability, in uppercase.
        fuzzed_url (str):
            The URL produced by the server-side fuzzer
            and used in the request that triggered the
            vulnerability.
        body (str):
            The body of the request that triggered the
            vulnerability.
        description (str):
            The description of the vulnerability.
        reproduction_url (str):
            The URL containing human-readable payload
            that user can leverage to reproduce the
            vulnerability.
        frame_url (str):
            If the vulnerability was originated from
            nested IFrame, the immediate parent IFrame is
            reported.
        final_url (str):
            The URL where the browser lands when the
            vulnerability is detected.
        tracking_id (str):
            The tracking ID uniquely identifies a
            vulnerability instance across multiple ScanRuns.
        outdated_library (google.cloud.websecurityscanner_v1alpha.types.OutdatedLibrary):
            An addon containing information about
            outdated libraries.
        violating_resource (google.cloud.websecurityscanner_v1alpha.types.ViolatingResource):
            An addon containing detailed information
            regarding any resource causing the vulnerability
            such as JavaScript sources, image, audio files,
            etc.
        vulnerable_headers (google.cloud.websecurityscanner_v1alpha.types.VulnerableHeaders):
            An addon containing information about
            vulnerable or missing HTTP headers.
        vulnerable_parameters (google.cloud.websecurityscanner_v1alpha.types.VulnerableParameters):
            An addon containing information about request
            parameters which were found to be vulnerable.
        xss (google.cloud.websecurityscanner_v1alpha.types.Xss):
            An addon containing information reported for
            an XSS, if any.
    """

    class FindingType(proto.Enum):
        r"""Types of Findings.

        Values:
            FINDING_TYPE_UNSPECIFIED (0):
                The invalid finding type.
            MIXED_CONTENT (1):
                A page that was served over HTTPS also
                resources over HTTP. A man-in-the-middle
                attacker could tamper with the HTTP resource and
                gain full access to the website that loads the
                resource or to monitor the actions taken by the
                user.
            OUTDATED_LIBRARY (2):
                The version of an included library is known
                to contain a security issue. The scanner checks
                the version of library in use against a known
                list of vulnerable libraries. False positives
                are possible if the version detection fails or
                if the library has been manually patched.
            ROSETTA_FLASH (5):
                This type of vulnerability occurs when the
                value of a request parameter is reflected at the
                beginning of the response, for example, in
                requests using JSONP. Under certain
                circumstances, an attacker may be able to supply
                an alphanumeric-only Flash file in the
                vulnerable parameter causing the browser to
                execute the Flash file as if it originated on
                the vulnerable server.
            XSS_CALLBACK (3):
                A cross-site scripting (XSS) bug is found via
                JavaScript callback. For detailed explanations
                on XSS, see
                https://www.google.com/about/appsecurity/learning/xss/.
            XSS_ERROR (4):
                A potential cross-site scripting (XSS) bug
                due to JavaScript breakage. In some
                circumstances, the application under test might
                modify the test string before it is parsed by
                the browser. When the browser attempts to runs
                this modified test string, it will likely break
                and throw a JavaScript execution error, thus an
                injection issue is occurring. However, it may
                not be exploitable. Manual verification is
                needed to see if the test string modifications
                can be evaded and confirm that the issue is in
                fact an XSS vulnerability. For detailed
                explanations on XSS, see
                https://www.google.com/about/appsecurity/learning/xss/.
            CLEAR_TEXT_PASSWORD (6):
                An application appears to be transmitting a
                password field in clear text. An attacker can
                eavesdrop network traffic and sniff the password
                field.
            INVALID_CONTENT_TYPE (7):
                An application returns sensitive content with
                an invalid content type, or without an
                'X-Content-Type-Options: nosniff' header.
            XSS_ANGULAR_CALLBACK (8):
                A cross-site scripting (XSS) vulnerability in
                AngularJS module that occurs when a
                user-provided string is interpolated by Angular.
            INVALID_HEADER (9):
                A malformed or invalid valued header.
            MISSPELLED_SECURITY_HEADER_NAME (10):
                Misspelled security header name.
            MISMATCHING_SECURITY_HEADER_VALUES (11):
                Mismatching values in a duplicate security
                header.
        """
        FINDING_TYPE_UNSPECIFIED = 0
        MIXED_CONTENT = 1
        OUTDATED_LIBRARY = 2
        ROSETTA_FLASH = 5
        XSS_CALLBACK = 3
        XSS_ERROR = 4
        CLEAR_TEXT_PASSWORD = 6
        INVALID_CONTENT_TYPE = 7
        XSS_ANGULAR_CALLBACK = 8
        INVALID_HEADER = 9
        MISSPELLED_SECURITY_HEADER_NAME = 10
        MISMATCHING_SECURITY_HEADER_VALUES = 11

    name: str = proto.Field(
        proto.STRING,
        number=1,
    )
    finding_type: FindingType = proto.Field(
        proto.ENUM,
        number=2,
        enum=FindingType,
    )
    http_method: str = proto.Field(
        proto.STRING,
        number=3,
    )
    fuzzed_url: str = proto.Field(
        proto.STRING,
        number=4,
    )
    body: str = proto.Field(
        proto.STRING,
        number=5,
    )
    description: str = proto.Field(
        proto.STRING,
        number=6,
    )
    reproduction_url: str = proto.Field(
        proto.STRING,
        number=7,
    )
    frame_url: str = proto.Field(
        proto.STRING,
        number=8,
    )
    final_url: str = proto.Field(
        proto.STRING,
        number=9,
    )
    tracking_id: str = proto.Field(
        proto.STRING,
        number=10,
    )
    outdated_library: finding_addon.OutdatedLibrary = proto.Field(
        proto.MESSAGE,
        number=11,
        message=finding_addon.OutdatedLibrary,
    )
    violating_resource: finding_addon.ViolatingResource = proto.Field(
        proto.MESSAGE,
        number=12,
        message=finding_addon.ViolatingResource,
    )
    vulnerable_headers: finding_addon.VulnerableHeaders = proto.Field(
        proto.MESSAGE,
        number=15,
        message=finding_addon.VulnerableHeaders,
    )
    vulnerable_parameters: finding_addon.VulnerableParameters = proto.Field(
        proto.MESSAGE,
        number=13,
        message=finding_addon.VulnerableParameters,
    )
    xss: finding_addon.Xss = proto.Field(
        proto.MESSAGE,
        number=14,
        message=finding_addon.Xss,
    )


__all__ = tuple(sorted(__protobuf__.manifest))
