import { Schedule } from '@aws-cdk/aws-events';
import { IFunction, IDestination } from '@aws-cdk/aws-lambda';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Sandbox } from './sandbox';
export interface ScannerProps {
    readonly buckets?: Bucket[];
    readonly onResult?: IDestination;
    readonly onError?: IDestination;
    readonly updateSchedule?: Schedule;
    /**
     * @default cc:scan-status
     */
    readonly scanStatusTagName?: string;
}
export declare class Scanner extends Construct {
    readonly scanFunction: IFunction;
    readonly updateFunction: IFunction;
    readonly sandbox: Sandbox;
    readonly scanStatusTagName: string;
    constructor(scope: Construct, id: string, props?: ScannerProps);
    addSourceBucket(bucket: Bucket): void;
}
